/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: SnapshotDisplayDevice.C,v $
 *	$Author: leech $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1996/11/22 03:04:57 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Dump the screen shot to a file by calling the machine specific external
 * program with the right options.  (Actually, someday the routines might
 * be put here as well; your preference.)
 *
 ***************************************************************************/

// This turned out to be mroe painless than I expected
// Basically, I already know the screen parameters since I'm a DisplayDevice,
// and I got the info from "display".  It is just a matter of constructing
// the correct string.

#include <stdio.h>
#include <stdlib.h>
#include "SnapshotDisplayDevice.h"

// this must change depending on the machine type
// the data in the sprintf stack is:
//  x wx x+wx-1   y wy y+wy-1  filename
// the option is changed in the configure script; it used to be
// #define VMDSNAPSHOT "/usr/sbin/scrsave %7$s %1$d %3$d %4$d %6$d"
extern char *vmdSnapshot;
#define VMDSNAPSHOT vmdSnapshot;

SnapshotDisplayDevice::SnapshotDisplayDevice(void) : 
  FileRenderer("snapshot", "snap.rgb", "ipaste %s") {
}

// construct the exec string, then system() it
// pretty easy, eh?
void SnapshotDisplayDevice::close_file(void)
{
  // construct the string for ouput (no, I don't gaurantee enough space :(
  char *s = new char[strlen(vmdSnapshot) + strlen(my_filename) + 100];
  sprintf(s, vmdSnapshot, xOrig, xSize, xOrig + xSize - 1, 
	  yOrig, ySize, yOrig + ySize - 1, my_filename);
  system(s);
  delete [] s;
}


