/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: SnapshotDisplayDevice.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1996/11/05 04:16:42 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  Dump the screen shot to a file by calling the machine specific external 
 *  program with the right options. See SnapshotDisplayDevice.C for
 *  how to change the default program
 *
 ***************************************************************************/


#ifndef SNAPSHOTDISPLAYDEVICE
#define SNAPSHOTDISPLAYDEVICE

#include "FileRenderer.h"
class SnapshotDisplayDevice : public FileRenderer {
  
public:
  // set up the commands for grabbing images from the screen
  SnapshotDisplayDevice(void);

  // replace the "open" so I don't even get the attempt at fopen
  // everything else should be okay
  virtual int open_file(char *filename) {
    my_filename = stringdup(filename);
    isOpened = TRUE;
    return TRUE;
  }

  // ignore the renders
  virtual void render(void *){}

  // At the end, save the screen display to file
  // Here's where the main action occurs
  virtual void close_file(void);
};  
#endif


