/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Surf.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 1997/03/23 09:24:58 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fstream.h>
#include <string.h>
#include <errno.h>
#include <math.h>

/*  
   various rendering packages have amuzingly different ideas about what 
   constitutes a degenerate triangle.  -1 and 1 work well.  numbers
   below 0.999 and -0.999 show up in OpenGL
   numbers as low as 0.98 have worked in POVRay with certain models while
   numbers as high as 0.999999 have produced massive holes in other
   models
	 -matt 11/13/96
 */

#define HIGH_TOLERANCE 1.0
#define LOW_TOLERANCE -1.0

#include "utilities.h"
#include "Surf.h"

#define SURF_BIN "surf"
//#define SURF_TMPDIR "/usr/tmp"
extern char *VMDtempFile(const char *);
#define SURF_TMPDIR VMDtempFile("")

// these are VMD specific
#include "Inform.h"
#define cerr msgErr
#define endl sendmsg

// delete the directory
#define DELETE_TMPDIR							      \
{									      \
   char *s = new char [strlen(dirname) + 50];				      \
   strcpy(s, "/bin/rm -fr ");						      \
   strcat(s, dirname);							      \
   system(s);								      \
   delete [] s;								      \
}

// delete tmp names and return
#define CLEAN_RETURN							      \
{									      \
   if (filename) delete [] filename;					      \
   if (dirname)  delete [] dirname;					      \
   return;								      \
}


Surf::Surf(float probe_r, int num, float *r, float *x, float *y, float *z)
:triangles(100)
{
   float v1[3],v2[3],v1_length,v2_length;
   is_okay = FALSE;
   char *dirname = NULL;
   char *filename = NULL;
   // create a temporary directory
   // first, get a good name
   char randprefix[20];
   {  // make a four digit random number
      int i = rand();
      sprintf(randprefix, "%d", i);
      randprefix[4] = 0;
   }
   if (getenv("SURF_TMPDIR")) {
      dirname = new char[strlen(getenv("SURF_TMPDIR"))+100];
      sprintf(dirname, "%s/surf%d.%sXXXXXX", getenv("SURF_TMPDIR"), getuid(),
	      randprefix);
   } else {
      dirname = new char[strlen(SURF_TMPDIR) + 100];
      sprintf(dirname, "%ssurf%d.%sXXXXXX", SURF_TMPDIR, getuid(),
	      randprefix);
   }
   mktemp(dirname);
   if (dirname[0] == 0) {
      cerr << "Cannot make new dir name for SURF: "
	   << strerror(errno) << endl;
      CLEAN_RETURN;
   }
   // make the temp directory
   {
      mode_t tmpmask = umask(0);
      umask(tmpmask);
      if (mkdir(dirname, 0544 | ~tmpmask) != 0) {
	 cerr << "Cannot create temp directory " << dirname
	      << " for SURF calculation: " << strerror(errno) << endl;
	 CLEAN_RETURN;
      }
   }
   // create the input file for that directory
   filename = new char[strlen(dirname) + strlen("/surf.in") + 20];
   strcpy(filename, dirname);
   strcat(filename, "/surf.in");

   // write everything to the data file
   {
      ofstream outfile(filename);
      for (int i=0; i<num; i++) {
	 outfile << i << " " << r[i] << " " << x[i] << " "
		 << y[i] << " " << z[i] << "\n";
      }
   }
   // call the system program for conversion
   {
      char *s;
      if (getenv("SURF_BIN")) {
	 s = new char[strlen(filename)+strlen(getenv("SURF_BIN"))+80];
	 strcpy(s, getenv("SURF_BIN"));
      } else {
	 s = new char[strlen(filename)+strlen(SURF_BIN)+80];
	 strcpy(s, SURF_BIN);
      }
      strcat(s, " ");
      {
	 char tmps[30];
	 sprintf(tmps, " -W 1 -R %f ", probe_r);
	 probe_radius = probe_r;
	 strcat(s, tmps);
      }
      strcat(s, filename);
      static int surf_firsttime = 1;
      system(s);
      delete [] s;
      if (surf_firsttime == 1) {
	surf_firsttime = 0;
	msgInfo << "This surface is made with SURF from UNC-Chapel Hill.  "
		<< "The reference is:" << sendmsg;
	msgInfo << 
"A. Varshney, F. P. Brooks, W. V. Wright, Linearly Scalable Computation"
		<< sendmsg;
	msgInfo << 
"of Smooth Molecular Surfaces, IEEE Comp. Graphics and Applications, "
		<< sendmsg;
	msgInfo << "v. 14 (1994) pp. 19-25." << sendmsg;

      }
   }
   
   // read the data
   strcat(filename, ".tri");

   { // read the file
      ifstream infile(filename);
      if (!infile) {
	 cerr << "Cannot read SURF output file: " << filename << endl;
	 DELETE_TMPDIR;
	 CLEAN_RETURN;
      }


      /* get the first tmp.index so that the infile.eof stuff works */

      tri tmp;
      infile >> tmp.index;
      while (!infile.eof()){

        for (int i=0; i<3; i++){ 
          infile >> tmp.point[i].pos[0] >>tmp.point[i].pos[1] >>tmp.point[i].pos[2]>>
	            tmp.point[i].norm[0]>>tmp.point[i].norm[1]>>tmp.point[i].norm[2];

        }
        if(infile.fail()){
	   cerr << "was there a core dump or disk error? premature End Of File"<<endl;
	   break;
	}


/**************************************************************/
/*    turn the triangle into 2 normalized vectors.            */
/*    If the dot product is 1 or -1 then                      */
/*   the triangle is degenerate                               */
/**************************************************************/
	    v1[0] = tmp.point[0].pos[0]-tmp.point[1].pos[0]; 
	    v1[1] = tmp.point[0].pos[1]-tmp.point[1].pos[1]; 
	    v1[2] = tmp.point[0].pos[2]-tmp.point[1].pos[2]; 

	    v2[0] = tmp.point[0].pos[0]-tmp.point[2].pos[0]; 
	    v2[1] = tmp.point[0].pos[1]-tmp.point[2].pos[1]; 
	    v2[2] = tmp.point[0].pos[2]-tmp.point[2].pos[2]; 

	    v1_length = sqrtf( v1[0]*v1[0]+ v1[1]*v1[1]+ v1[2]*v1[2]);
	    v2_length = sqrtf( v2[0]*v2[0]+ v2[1]*v2[1]+ v2[2]*v2[2]);

/**************************************************************/
/*                   invert to avoid divides:                 */
/*                         1.0/v1_length * 1.0/v2_length      */
/**************************************************************/

	    v2_length = 1.0/(v1_length*v2_length); 
 
	    v1_length = 
		  v1[0]*v2[0]*v2_length +
		  v1[1]*v2[1]*v2_length +
		  v1[2]*v2[2]*v2_length ;
	     
	 // and add it to the list if it's not degenerate
	 if(   (v1_length>=HIGH_TOLERANCE)
	    || (v1_length<=LOW_TOLERANCE) ) {
	   //	   msgInfo << "removing triangle with dot product "<<v1_length<<sendmsg;
	  } else{  
	  
	    triangles.append(tmp); 
	  
	  }

      /* get the next tmp.index so that the infile.eof stuff works */
      /* this is obnoxious, but it works                           */

	  infile >> tmp.index;
      }
   } // file has been read

   is_okay = TRUE;
   DELETE_TMPDIR;
   CLEAN_RETURN;
}


Surf::~Surf(void){
}

