/***************************************************************************
 *cr
 *cr		(C) Copyright 1995 The Board of Trustees of the
 *cr			    University of Illinois
 *cr			     All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: TokenDisplayDevice.h,v $
 *	$Author: ulrich $		$Locker:  $		   $State: Exp $
 *	$Revision: 1.4 $	      $Date: 1997/03/18 20:35:51 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * FileRenderer type for listing all tokens in the display list
 *
 ***************************************************************************/
#ifndef TOKENDISPLAYDEVICE
#define TOKENDISPLAYDEVICE

#include <stdio.h>
#include "FileRenderer.h"

class TokenDisplayDevice : public FileRenderer {


protected:

  // functions to print the graphics elements
  void point(float *xyz);
  void sphere(float *xyzr);
  void line(float *xyz1, float *xyz2);
  void cylinder(float *a, float *b, float rad, int filled);
  void cone    (float *a, float *b, float rad);
  void triangle(float *, float *, float *, float *, float *, float *);
  void square(float *, float *, float *, float *, float *);
  // print a matrix
  void prmatop(const char *, const Matrix4& mat);

  // other object information
  void set_line_width(int new_width);
  void set_line_style(int new_style);
  void set_sphere_res(int new_res);
  void set_sphere_style(int new_style);

  // transformation functions
  void push(void);
  void pop(void);
  void load(Matrix4& mat);
  void multmatrix(Matrix4& mat);
  void translate(float x, float y, float z);
  void rot(float ang, char axis);
  void scale(float x, float y, float z);

  // set the color
  void set_color(int color_index);

  // materials
  void activate_materials(void);
  void deactivate_materials(void);

  // deal with text
  void text_position(float x, float y, float z);
  void text(char *);

  // comments
  void comment (char *);

  // picking
  void pick_point(float *xyz, int id);

public:
  // constructor/destructor

  TokenDisplayDevice(void);

  void write_header(void);
  void write_trailer(void);

  //  virtual void render(void *);  /// now done in superclass

};

#endif

