/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ToolControl.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.7 $	$Date: 1997/03/13 17:51:33 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  Code to do a ToolControl
 *
 ***************************************************************************/

#include "ToolControl.h"

///////////////////////////  constructor
ToolControl::ToolControl(int which_id, Tool *default_tool) : my_tool(50) {
  my_info.toolid = which_id;
  reset();
  my_tool.push(default_tool);
};


////////////////////////////  destructor
ToolControl::~ToolControl(void) {
  reset();
}
    

///////////////////////////  member functions
void ToolControl::reset(void) { // reset everything to the NULL parameters
    my_info.tracker = NULL;
    my_info.sensor  = 0;
    my_info.buttons = NULL;
    my_info.internal_radius  = 0.1;
    my_info.internal_length  = 1.0;
    my_info.scale    = 1.0;
    my_info.length = my_info.internal_length * my_info.scale;
    my_info.radius = my_info.internal_radius * my_info.scale;
    my_info.detail = 5;
    delta[0] = delta[1] = delta[2] = 0.0;
    while (my_tool.stack_size()>1)  // don't dis da default
      my_tool.pop();
    pop_count = 0;
  }
  

// check_event figures the appropriate info (locations, etc), and
//   calls the Tool with that information
void ToolControl::check_event(void) {
    // get the current tracker/sensor location
  if (!my_info.tracker)
     return;
  my_info.tracker -> get_position(my_info.sensor, 
           my_info.base[0], my_info.base[1], my_info.base[2]);
  my_info.tracker -> get_orientation(my_info.sensor, my_info.orient);

    // apply the delta
  add(my_info.base, my_info.base, delta);

   // the tip location must be computed by the Tool
   // normally this is done with do_graphics_transformation

  // call the current Tool to check for button events, if
  //   there were any
  if (my_info.buttons) {
    if (my_info.buttons-> changed()) { // any change of state?
      my_tool.top() -> button_event(this, &my_info);
    }
  }

  // call the current Tool to do things like update the image
  my_tool.top() -> check_event(this, &my_info);  
}

