/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: TrackerList.C,v $
 *      $Author: dalke $        $Locker:  $                $State: Exp $
 *      $Revision: 1.13 $      $Date: 1995/12/19 17:49:12 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Maintain a list of trackers.  Trackers can only be added to the list!
 *
 ***************************************************************************/

#include <stdio.h>
#include <strings.h>
#include "utilities.h"
#include "TrackerList.h"
#include "Command.h"
#include "CmdTracker.h"
#include "UIVR.h"
#include "Buttons.h"
#include "Inform.h"
#include "Global.h"
//#include "PVMTracker.h"

// UNC tracker library version of Tracker
#ifdef VMDUNC
#include "UNCTracker.h"
#endif

// CAVE tracker version of Tracker
#ifdef VMDCAVE
#include "CaveTracker.h"
#endif

#include "TextTracker.h"

//  class constructor
TrackerList::TrackerList( void) : availList(9), trackerList(9)
{
#ifdef VMDUNC
  // make the list of available tracking devices
  add_avail("Text emulation of 1 sensor", "text", 1);
  add_avail("Text emulation of 2 sensors", "text", 2);
  add_avail("Fastrak using 1 sensor", "fastrak1", 1);
  add_avail("Fastrak using 2 sensors", "fastrak1", 2);
  add_avail("Fastrak using 3 sensors", "fastrak1", 3);
  add_avail("Fastrak using 4 sensors", "fastrak1", 4);
#endif
#ifdef VMDCAVE
  add_avail("Cave", "cave", 1);
#endif
#ifdef VMDUNC
  add_avail("Polhemus using 1 sensors", "polhemus1", 1);
  add_avail("Polhemus using 2 sensors", "polhemus1", 2);
  add_avail("Polhemus using 3 sensors", "polhemus1", 3);
  add_avail("Polhemus using 4 sensors", "polhemus1", 4);

  add_avail("Boom", "boom1", 1);
#endif
}

// destructor
TrackerList::~TrackerList( void)
{
  //  delete the list of available trackers
  while (availList.num()>0) {
    delete [] availList[0] -> visiblename;
    delete [] availList[0] -> UNCname;
    delete availList[0];
    availList.remove(0);
  }
  //  delete the list of running trackers
  while (trackerList.num()>0) {
    delete [] trackerList[0] -> name;
    delete trackerList[0] -> tracker;
    delete [] trackerList[0];
    trackerList.remove(0);
  }
 // 'Later, dudes and dudettes
}


int TrackerList::check_event( void)
{
  for (int i=0; i<trackerList.num(); i++)
     trackerList[i] -> tracker -> update_sensors();
  return TRUE;
}


//////************  AVAILABLE TRACKERS **************
// add a new term to the availList
void TrackerList::add_avail(char *visiblename, char *UNCname, int numsensors)
{
  AvailTrackertype *tmp = new AvailTrackertype;
  tmp -> visiblename = stringdup( visiblename);
  tmp -> UNCname = stringdup( UNCname);
  tmp -> numsensors = numsensors;
  availList.append( tmp);
}
  // how many types of trackers are available?
int TrackerList::num_avail( void) { return availList.num(); }

  // return the visible name associated with an avail index
const char *TrackerList::avail_name( int availid)
{
  if (availid < 0 || availid >= availList.num())
    return NULL;
  return availList[availid]->visiblename;
}

  // return the avail tracker pointer assoc. with the index
TrackerList::AvailTrackertype *
TrackerList::avail_list_ptr(int availid)
{
  if (availid < 0 || availid >= availList.num())
    return NULL;
  return availList[availid];
}

    // Start up the AvailTracker
    //  on success, it returns TRACKER_OK
    //  anything else is an error (like if you attempt to
    //  start two UNC names on the same machine.)
int TrackerList::start_avail(int availid, char *remotemachine)
{
  Tracker *newtracker=NULL;
  AvailTrackertype *tempptr = avail_list_ptr(availid);
  char *s;
  int status;

  if (tempptr == NULL)
      return TRACKER_NOK;
//printf("Tracker %d found  (%s)\n", availid, remotemachine);
  if (remotemachine == NULL)         // construct the name for the tracker
   s = stringdup(tempptr->UNCname);  // on a local machine
  else
   {                                 // or a remote one
    s = new char[strlen(tempptr->UNCname)+strlen(remotemachine)+3];
    sprintf(s,"%s(%s)", tempptr->UNCname, remotemachine);
   }
//  msgInfo << "Tracker name is " << s << sendmsg;
  if (strcasecmp(s, "text")  &&     // if this isn't the text tracker
      !name_is_unique(s))            // only one instance per machine allowed
   {
    delete [] s;
    return TRACKER_NOK;
   }

//printf("Tracker is unique on the machine\n");

   // Here I try to start up a tracker
   newtracker = NULL;
//  if (remotemachine == NULL) {
#ifdef VMDCAVE
     if (!strcasecmp(tempptr->UNCname, "cave")) {
       newtracker = new CaveTracker("cave", 1);
       if (!newtracker) {
         msgErr << "Couldn't create CAVE tracker" << sendmsg;
       }
     }
#endif
     if (!strcasecmp(tempptr->UNCname, "text")) {
	newtracker = new TextTracker(tempptr->numsensors);
//	msgInfo << "Created text tracker" << sendmsg;
     }
#ifdef VMDUNC
     if (!newtracker)
       newtracker = new UNCTracker(tempptr->UNCname, tempptr->numsensors);
#else
     // for now, no tracker option supported.  Put here later code to start
     // non-UNC tracker 
     msgInfo << "Spatial tracking capability has not been included in this ";
     msgInfo << "executable.\nRecompile with VMDUNC defined." << sendmsg;
     delete [] s;
     if(newtracker);		// keep compiler happy
     return TRACKER_NOK;
#endif
     
//   } else {
//     newtracker = new PVMTracker(remotemachine, tempptr->UNCname, 
//		tempptr->numsensors);
//   }

   // now I see if it started up
  if ((status = newtracker -> startup_status()) == TRACKER_OK) {
      // it did, so associate a button input with it (hardwired and
      //    site dependent!!!)  Only have fastrak1 and cave1
//      if ( !strncmp(tempptr->UNCname, "fastrak1", 9) ) {
//         if (0< tempptr -> numsensors)
//             newtracker -> assign_buttons(0, uiVR -> kbdButtons1);
//         if (1< tempptr -> numsensors)
//             newtracker -> assign_buttons(1, uiVR -> kbdButtons2);
//         if (2< tempptr -> numsensors)
//             newtracker -> assign_buttons(2, uiVR -> kbdButtons3);
//     } else {
//         for (int i=0; i<tempptr -> numsensors; i++)
//           newtracker -> assign_buttons(i, uiVR -> pointerButtons);
//     }
         if (0< tempptr -> numsensors)
             newtracker -> assign_buttons(0, uiVR -> kbdButtons1);
         if (1< tempptr -> numsensors)
             newtracker -> assign_buttons(1, uiVR -> kbdButtons2);
         if (2< tempptr -> numsensors)
             newtracker -> assign_buttons(2, uiVR -> kbdButtons3);
	

     add(newtracker, s);  // add tracker with a uniq name 's'
     return TRACKER_OK;
   }
  msgErr << "Tracker booboo\n" << sendmsg;
  delete [] s;		// oops, won't start, so clean up
  delete newtracker;
  return status;
}

// return FALSE if the name already exists in the Tracker List
int TrackerList::name_is_unique(char *fullname)
{
  for (int i=0; i<trackerList.num(); i++)
    if (!strcmp(trackerList[0] -> name, fullname))
      return FALSE;
  return TRUE;
}

// add a tracker to the tracker list -- easy, with templates
void TrackerList::add(Tracker *tracker, char *name)
{
  TrackerListtype *tmp = new TrackerListtype;
  tmp -> name = name;
  tmp -> tracker = tracker;
  trackerList.append( tmp);
}


// Now that the tracker(s) is(are) up and running, I need to see who
// is there and how to connect to them. ********************/

// Number of trackers in the list
int TrackerList::num( void)
{ return trackerList.num(); }

// returns the pointer to the trackerList element in the
// tracker list (or NULL).  There isn't any reason to use this directly
TrackerList::TrackerListtype *TrackerList::list_ptr(int trackerid)
{
  if (trackerid < 0 || trackerid >= trackerList.num() )
    return NULL;
  return trackerList.item(trackerid);
}

// returns a pointer to that tracker (or NULL)
Tracker *TrackerList::tracker(int trackerid)
{
  TrackerListtype *tmp = list_ptr(trackerid);
  if (tmp)
    return tmp -> tracker;
  else
    return NULL;
}

// returns the pointer to the name of the numbered tracker (or NULL)
char *TrackerList::name(int trackerid)
{
  TrackerListtype *tmp = list_ptr(trackerid);
  if (tmp)
    return tmp->name;
  else
    return NULL;
}

// Given the pointer to the tracker, return its index (or -1)
int TrackerList::find_index(Tracker *tracker)
{
  for (int i=0; i<trackerList.num(); i++)
    if (trackerList[0] -> tracker == tracker)
      return i;
  return -1;
}

