/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * DESCRIPTION:
 *   This type of Tool can be used to pick up and translate molecules.
 * Just press button 0 to pick it up, and again to put it down
 *
 * Simple translation tool, derived from Tool
 ***************************************************************************/
#ifndef TRANSTOOL_H
#define TRANSTOOL_H

#include "Tool.h"

class TransTool : public Tool {

private:
  // draw a cylinder with the given number of sides.
  // because of the graphics transformations already
  // done, I can assume the base is at (0,0,0) and the
  // tip is at (1,0,0).
  void draw_cylindrical_pointer(ToolInfo *info, int numsides);
  int grabbed;
  float x, y, z;
 
public:
  TransTool(char *name, Scene *sc, int drawlist_size = 2) 
     : Tool(name, sc, drawlist_size) {
    tip_checking = FULL;
    grabbed = FALSE;
  }
  virtual void tool_event(ToolControl *toolctrl, ToolInfo *info);
  virtual void redraw_list(ToolInfo *info);
  virtual void button_event(ToolControl *toolctrl, ToolInfo *info);
  
};

#endif

