/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: TugTool.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1997/03/20 04:05:51 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Code for the Tool which tugs an atom
 *
 ***************************************************************************/

#include "TugTool.h"
#include "ToolControl.h"
#include "Buttons.h"
#include "CommandQueue.h"
#include "Global.h"
#include "CmdPick.h"
#include "Mouse.h"
#include "MouseEvent.h"
#include "CommandQueue.h"
#include "Molecule.h"
#include "MoleculeList.h"

// WARNING:  This is also located in "DrawForce.C"
#define FORCE_SCALE 10.0

void TugTool::redraw_list(ToolInfo *info) {
  
  reset_disp_list();  // clear out everything
  
  // the default picture is a simple cylinder with a cone end
  switch (info->detail ) {
    case 1:  // draw a simple line with a cheap end
       {float tip[3]  = {1,0,0}; 
       float base[3] = {0,0,0};
       drawcolor.putdata(info -> toolid, this);  // color each tool differently
       drawline.putdata(base, tip, this);  // line
        base[0] = 0.9;
        base[1] = 0.1;
       drawcolor.putdata(info -> toolid + 1, this);
        drawline.putdata(base, tip, this);  // and tip
        base[1] = -base[1];
        drawline.putdata(base, tip, this);
        base[2] = base[1];
        base[1] = 0.0;
        drawline.putdata(base, tip, this);
        base[1] = -base[1];
        drawline.putdata(base, tip, this);}
      break;
    case 2:  // draw a cylinder with different sized radii
       draw_cylindrical_pointer(info, 3);
      break;
    case 3:
       draw_cylindrical_pointer(info, 4);
      break;
    case 4:
       draw_cylindrical_pointer(info, 6);
      break;
    case 5:
       draw_cylindrical_pointer(info, 10);
      break;
    case 6:
       draw_cylindrical_pointer(info, 16);
      break;
    case 7:  // include material characteristics
       drawmaterials.putdata(TRUE, this);
       draw_cylindrical_pointer(info, 12);
       drawmaterials.putdata(FALSE, this);
      break;
    case 8:
       drawmaterials.putdata(TRUE, this);
       draw_cylindrical_pointer(info, 12);
       drawmaterials.putdata(FALSE, this);
      break;
    case 9:
       drawmaterials.putdata(TRUE, this);
       draw_cylindrical_pointer(info, 16);
       drawmaterials.putdata(FALSE, this);
      break;
    case 10: 
       drawmaterials.putdata(TRUE, this);
       draw_cylindrical_pointer(info, 24);
       drawmaterials.putdata(FALSE, this);
      break;
    default:  // same as 5
       draw_cylindrical_pointer(info, 10);
      break;
  }
}

//
//  Cone with a double cone at the end
//
//  \_____           
//        \__________  _
//                   \/ \
//         __________/\_/
//   _____/
//  /
//                    |0.6
void TugTool::draw_cylindrical_pointer(ToolInfo *info, int numsides)
{
  if (numsides < 3) numsides = 3;
  if (numsides > 30) numsides = 30;
  float base[3] = {0.0,0.0,0.0};
  float tip[3] = {0.6, 0.0, 0.0};
  drawcolor.putdata(info -> toolid, this);  // color each tool differently
  drawcone.putdata(base, tip, 0.7, numsides, this);
  drawcolor.putdata(REGSILVER, this);
  base[0] = 0.80;
  drawcone.putdata(base, tip, 0.4, numsides, this);
  tip[0] = 1.0;
  drawcone.putdata(base, tip, 0.4, numsides, this);
}

// Am I grabbing anything?  If so, move it
void TugTool::tool_event(ToolControl *, ToolInfo *toolinfo)
{
  if (!grabbed) return;

  // compute the difference between the picked atom and the tip
  // that becomes the force to use
  Molecule *mol = moleculeList->molecule(moleculeList->
					 mol_index_from_id(tug_mol));

  if (!mol || mol->frame() < 0) {  // for instance, it is deleted under me
    grabbed = 0;
    return;
  }
  // convert the tip pisition to the molecule's space
  Matrix4 tminv(mol -> tm);
  tminv.inverse();
  float tip[3];
  tminv.multpoint3d(toolinfo -> tip, tip);

  // get the current atom position
  Timestep *ts = mol->current();
  float *pos = ts -> pos + 3 * tug_atom;

  // compute the delta 
  float delta[3];
  subtract(delta, tip, pos);

  // modify the ufx, ufy, ufz components directly
  MolAtom *atm = mol -> atom(tug_atom);
  atm->extra[ATOM_USERFORCEX] = delta[0] * FORCE_SCALE;
  atm->extra[ATOM_USERFORCEY] = delta[1] * FORCE_SCALE;
  atm->extra[ATOM_USERFORCEZ] = delta[2] * FORCE_SCALE;
  atm->changed_userforce = 1;
}


// check which button was pushed, and change the appropriate state 
void TugTool::button_event(ToolControl *, ToolInfo *toolinfo)
{
  Buttons *checkbuttons;
  if (!(checkbuttons=toolinfo -> buttons))
    return;
  // if button 1 was pressed, and this is a grab, reset the molecule
  // to have 0 force and release the grab
  if (grabbed && checkbuttons -> change(1) ==  1) {
    Molecule *mol = moleculeList->molecule(moleculeList->
					   mol_index_from_id(tug_mol));
    if (mol) {
      MolAtom *atm = mol -> atom(tug_atom);
      atm->extra[ATOM_USERFORCEX] = 0;
      atm->extra[ATOM_USERFORCEY] = 0;
      atm->extra[ATOM_USERFORCEZ] = 0;
      atm->changed_userforce = 1;
    }
    grabbed = !grabbed;
  } else {
    // if button 0 was pressed, change the current grab state
    if (checkbuttons -> change(0) == 1) {
      grabbed = !grabbed;
    }
  }

  if (grabbed) {
    tug_mol = -1; // reset the variables
    tug_atom = -1;

    //// Get the atom and molecule numbers
    // From the pick list, get the pickable
    int tag;
    Pickable *p;
    if (display) {
      p = scene -> pick_check(display, 3, toolinfo -> tip, tag);
      if (p) {
	Molecule *m = moleculeList -> check_pickable(p);
	if (m) {
	  tug_mol = m->id();
	  tug_atom = tag;
	}
      }
    }
    if (tug_mol == -1) grabbed = 0;
  }
}

