/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: VButton.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/12 00:10:55 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *    A VButton is a VRegion that listens to a specific button and, when
 *  the button is pressed or unpressed, calls "execute".  In addition,
 *  if used in the "repeat" mode, it will call execute while the
 *  input coordinates stay within the region and the button is pressed.
 *
 ***************************************************************************/

#include "VButton.h"

// a VButton is a VRegion that listens to the button numbered 'button'.
// If that is pressed, it calls the execute function with the
// button state (down == is_pressed = TRUE)
//   'repeat' describes how the VButton calls execute.  You can have
// it call ONCE (when the button is pressed) REPEAT (keep calling when
// the button is pressed and stays inside the region) and ACTIVE (called
// whenever the location is in the region). Just remember that
// your 'execute', 'check_button' and 'left' must call this one after
// they finish, but your inside must not!

VButton::VButton(float *c1, float *c2, float *c3, float *c4, char *newname,
               Scene *sc, int memsize,
               int button, int repeat)
     : VRegion(c1, c2, c3, c4, newname, sc, memsize, FALSE)
{ 
 my_button = button;
 do_repeats = repeat;
 pressed = FALSE;
}

VButton::~VButton(void) {  // nor in my destructor
}

void VButton::execute(int is_pressed) {
  pressed = is_pressed;
}
void VButton::inside(float *delta, ToolControl *toolctrl) {
  if ((do_repeats == REPEAT && pressed) || do_repeats == ACTIVE )
    execute(TRUE);
  VRegion::inside(delta, toolctrl);
}

void VButton::check_button(int buttonnum, int change, float *delta,
                            ToolControl *toolctrl) {
 if (buttonnum == my_button) {  // button just went down
   if (do_repeats != ACTIVE)  // prevent double calls
    if (change == 1)
       execute(TRUE);
      else
       execute(FALSE);
 } else {  // let the parent figure out what to do
   VRegion::check_button(buttonnum, change, delta, toolctrl);
 }
}

void VButton::left(void) { // disengage when you've left the region
  pressed = FALSE;
  VRegion::left();
}


#ifdef VBUTTON_EXAMPLE

/////////////////////////  VButtonRotate functions  //////////////////////

void VButtonRotate::execute(int is_pressed) {
  if (is_pressed)
    commandQueue -> append(new CmdRotate(angle, axis, CmdRotate::BY));
  VButton::execute(is_pressed);
}

#endif

