/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: VrmlDisplayDevice.C,v $
 *	$Author: ulrich $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1997/03/21 18:02:25 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>  /* this is for the Hash Table */
#include "VrmlDisplayDevice.h"
#include "Stack.h"
#include "Matrix4.h"
#include "DispCmds.h"
#include "Inform.h"
#include "utilities.h"

#define DEFAULT_RADIUS 0.002
#define DASH_LENGTH 0.02

///////////////////////// constructor and destructor

// constructor ... initialize some variables
VrmlDisplayDevice::VrmlDisplayDevice(void) : 
  FileRenderer("VRML-1", "render.wrl", "true") {
	
    MSGDEBUG(1,"Creating VrmlDisplayDevice ..." << sendmsg);

  tList = NULL;
  hTable = NULL;

}
               
///////////////////////// protected nonvirtual routines
void VrmlDisplayDevice::set_color(int colorIndex)
{
  // just grab the current material definition
  fprintf(outfile, "Material { \n");
  fprintf(outfile, "diffuseColor %f %f %f\n",
	  matData[colorIndex][DIFFUSE_INDEX + 0], 
	  matData[colorIndex][DIFFUSE_INDEX + 1],
	  matData[colorIndex][DIFFUSE_INDEX + 2]);
  fprintf(outfile, "ambientColor %f %f %f\n",
	  matData[colorIndex][AMBIENT_INDEX + 0], 
	  matData[colorIndex][AMBIENT_INDEX + 1],
	  matData[colorIndex][AMBIENT_INDEX + 2]);
  fprintf(outfile, "specularColor %f %f %f\n",
	  matData[colorIndex][SPECULAR_INDEX + 0], 
	  matData[colorIndex][SPECULAR_INDEX + 1],
	  matData[colorIndex][SPECULAR_INDEX + 2]);
  fprintf(outfile, "shininess %f\n",
	  matData[colorIndex][SHININESS_INDEX]/128.0);
  fprintf(outfile, "transparency %f\n",
	  1.0 - matData[colorIndex][ALPHA_INDEX]);
  fprintf(outfile, "}\n");
}

#ifdef OLD_STUFF
// draw a point
void VrmlDisplayDevice::point(float spdata[]) {
  float vec[3];

  // transform the world coordinates
  (transMat.top()).multpoint3d(spdata, vec);
   
  // draw the sphere
  fprintf(outfile, "Separator {\nTranslation { translation %f %f %f }\n",
	  ORDER(vec[0], vec[1], vec[2]));
  set_color(currentColor[0], currentColor[1], currentColor[2]);
  fprintf(outfile, "Sphere { radius %f }\n}\n", 
	  float(lineWidth) * DEFAULT_RADIUS);
}
#endif

// draw a sphere
void VrmlDisplayDevice::sphere(float *xyzr) {
  
  // draw the sphere
  fprintf(outfile, "Separator {\nTranslation { translation %f %f %f }\n",
	  xyzr[0], xyzr[1], xyzr[2]);

  fprintf(outfile, "Sphere { radius %f }\n}\n", xyzr[3]);
}

//// draw a line (cylinder) from a to b
////  Doesn't yet support the dotted line method
//  if(lineStyle == ::SOLIDLINE ) {
void VrmlDisplayDevice::line(float *a, float*b) {
  // ugly and wasteful, but it will work
  // I guess I really should have done the "correct" indexing ...
  // I'll worry about that later.
  fprintf(outfile, "Coordinate3 {point [ %f %f %f, %f %f %f ] }\n",
	  a[0], a[1], a[2], b[0], b[1], b[2]);
  fprintf(outfile, "IndexedLineSet { coordIndex [0, 1, -1] }\n");
}

static Matrix4& convert_endpoints_to_matrix(float *a, float *b)
{
  // I need to transform (0,-1,0) - (0,1,0) radius 1
  // into a - b
  float c[3];
  subtract(c, b, a);
  
  float len = distance(a,b);
  if (len == 0.0) {
    return Matrix4();
  }
  
  Matrix4 trans;
  trans.translate( (a[0] + b[0]) / 2.0, (a[1] + b[1]) / 2.0, 
		   (a[2] + b[2]) / 2.0);

  // this is a straight copy from transvec, which takes things
  // from the x axis to a given vector
  Matrix4 rot;
  if (c[0] == 0.0 && c[1] == 0.0) {
    // then wants the z axis
    if (c[2] > 0) {
      rot.rot(-90, 'y');
    } else {
      rot.rot(-90, 'y');
    }
  } else {
    float theta, phi;
    theta = atan2(c[1], c[0]);
    phi = atan2(c[2], sqrt(c[0]*c[0] + c[1]*c[1]));
    Matrix4 m1; m1.rot( -phi  * 180.0 / M_PI, 'y');
    Matrix4 m2; m2.rot( theta * 180.0 / M_PI, 'z');
    rot = m2 * m1;
    //    msgInfo << "m1 == " << m1 << sendmsg;
    //    msgInfo << "m2 == " << m2 << sendmsg;
  }
  //  msgInfo << "rot == " << rot << sendmsg;
  

  // Compute everything
  Matrix4 mat;
  mat *= trans;
  mat *= rot;
  //  msgInfo << "Mat: " << mat << sendmsg;

  // now bring to the y axis
  mat.rot(-90, 'z');

  return mat;
}

// draw a cylinder
void VrmlDisplayDevice::cylinder(float *a, float *b, float r,
				 int filled) 
{
  if (a[0] == b[0] && a[1] == b[1] && a[2] == b[2]) {
    return;  // we don't serve your kind here
  }
  push();
  Matrix4 mat = convert_endpoints_to_matrix(a, b);
  load(mat); // print matrix

  // draw the cylinder
  fprintf(outfile, "Cylinder { \n"
	  "radius %f\n"
	  "height %f\n"
	  "parts %s}\n", 
	  r, distance(a,b),  filled ? "ALL" : "SIDES");

  // pop out of this matrix
  pop();
}


// draw a cone
void VrmlDisplayDevice::cone(float *a, float *b, float r) 
{
  if (a[0] == b[0] && a[1] == b[1] && a[2] == b[2]) {
    return;  // we don't serve your kind here
  }
  push();
  Matrix4 mat = convert_endpoints_to_matrix(a, b);
  load(mat); // print matrix

  // draw the cylinder
  fprintf(outfile, "Cone { \n"
	  "bottomRadius %f\n"
	  "height %f}\n",
	  r, distance(a,b));

  // pop out of this matrix
  pop();
}


// draw a triangle
void VrmlDisplayDevice::triangle(float *a, float *b, float *c, 
				 float *n1, float *n2, float *n3) {
//#define MATT_EXPERIMENTAL
#ifdef MATT_EXPERIMENTAL
				 /* don't forget to delete triList in footer */
triList *triL = new triList;
float *datum = new float[6];
if(hTable==NULL){
  printf("creating new hash table\n");
  hTable = new HashTable(10001);
}

printf("doh!");

datum[0] = a[0];
datum[1] = a[1];
datum[2] = a[2];
datum[3] = n1[0];
datum[4] = n1[1];
datum[5] = n1[2];

 hTable->insert_element(datum); 
 triL->ptz[0] = hTable->current_element();

datum = new float[6];

datum[0] = b[0];
datum[1] = b[1];
datum[2] = b[2];
datum[3] = n2[0];
datum[4] = n2[1];
datum[5] = n2[2];

 hTable->insert_element(datum); 
 triL->ptz[1] = hTable->current_element();

datum = new float[6];

datum[0] = c[0];
datum[1] = c[1];
datum[2] = c[2];
datum[3] = n3[0];
datum[4] = n3[1];
datum[5] = n3[2];

 hTable->insert_element(datum); 
 triL->ptz[2] = hTable->current_element();

triL->next = tList;
tList = triL;

#else // MATT_EXPERIMENTAL
  fprintf(outfile,
	  "Normal { vector [\n"
	  " %f %f %f,\n %f %f %f,\n %f %f %f\n"
	  " ] }\n",
	  n1[0], n1[1], n1[2], n2[0], n2[1], n2[2], 
	  n3[0], n3[1], n3[2]);
  fprintf(outfile, 
	  "Coordinate3 {point [\n"
	  " %f %f %f,\n"
	  " %f %f %f,\n"
	  " %f %f %f\n"
	  " ] }\n",
	  a[0], a[1], a[2], b[0], b[1], b[2], c[0], c[1], c[2]);
  fprintf(outfile, "IndexedFaceSet { coordIndex [0, 1, 2, -1] }\n");
#endif // MATT_EXPERIMENTAL

//printf("!hod\n");
}

#ifdef OLD_STUFF
  float vec1[3], vec2[3], vec3[3];
  
  // transform the world coordinates
  (transMat.top()).multpoint3d(a, vec1);
  (transMat.top()).multpoint3d(b, vec2);
  (transMat.top()).multpoint3d(c, vec3);

  // draw the triangle
  fprintf(outfile, "polygon {\n");
  fprintf(outfile, "colour %f,%f,%f\n", currentColor[0], 
	  currentColor[1], currentColor[2]);
  
  fprintf(outfile, "vertex (%f,%f,%f),(%f,%f,%f)\n", 
	  ORDER(vec1[0], vec1[1], vec1[2]), // point one
	  ORDER(n1[0], n1[1], n1[2]));
  
  fprintf(outfile, "vertex (%f,%f,%f),(%f,%f,%f)\n", 
	  ORDER(vec2[0], vec2[1], vec2[2]), // point two
	  ORDER(n2[0], n2[1], n2[2]));
  fprintf(outfile, "vertex (%f,%f,%f),(%f,%f,%f)\n", 
	  ORDER(vec3[0], vec3[1], vec3[2]), // point three
	  ORDER(n3[0], n3[1], n3[2]));
  fprintf(outfile, "}\n");
#endif


#ifdef OLD_STUFF
// draw a square
void VrmlDisplayDevice::square(float *, float *a, float *b, float *c, float *d) {
  
  
  float vec1[3], vec2[3], vec3[3], vec4[3];
  
  // transform the world coordinates
  (transMat.top()).multpoint3d(a, vec1);
  (transMat.top()).multpoint3d(b, vec2);
  (transMat.top()).multpoint3d(c, vec3);
  (transMat.top()).multpoint3d(d, vec4);

  // draw the square
  fprintf(outfile, "polygon {\n");
  fprintf(outfile, "colour %f,%f,%f\n", currentColor[0], 
	  currentColor[1], currentColor[2]);

  fprintf(outfile, "vertex (%f,%f,%f)\n", 
	  ORDER(vec1[0], vec1[1], vec1[2])); // point one
  fprintf(outfile, "vertex (%f,%f,%f)\n", 
	  ORDER(vec2[0], vec2[1], vec2[2])); // point two
  fprintf(outfile, "vertex (%f,%f,%f)\n", 
	  ORDER(vec3[0], vec3[1], vec3[2])); // point three
  fprintf(outfile, "vertex (%f,%f,%f)\n", 
	  ORDER(vec4[0], vec4[1], vec4[2])); // point four
  fprintf(outfile, "}\n");
  
}
#endif


void VrmlDisplayDevice::push(void)
{
  fprintf(outfile, "#push matrix\nSeparator {\n");
}
void VrmlDisplayDevice::pop(void)
{
  fprintf(outfile, "#pop matrix\n}\n");
}
void VrmlDisplayDevice::multmatrix(Matrix4 &mat)
{
  fprintf(outfile, "# multmatrix\n");
  load(mat);
}
void VrmlDisplayDevice::load(Matrix4 &mat)
{
  fprintf(outfile,
	  "MatrixTransform {\n"
	  "  matrix %g %g %g %g\n"
	  "         %g %g %g %g\n"
	  "         %g %g %g %g\n"
	  "         %g %g %g %g\n"
	  "}\n", 
	  mat.mat[0][0], mat.mat[0][1], mat.mat[0][2], mat.mat[0][3],
	  mat.mat[1][0], mat.mat[1][1], mat.mat[1][2], mat.mat[1][3],
	  mat.mat[2][0], mat.mat[2][1], mat.mat[2][2], mat.mat[2][3],
	  mat.mat[3][0], mat.mat[3][1], mat.mat[3][2], mat.mat[3][3]
	  );
}

void VrmlDisplayDevice::comment (char *s)
{
  fprintf (outfile, "# %s\n", s);
}

///////////////////// public virtual routines

// initialize the file for output
void VrmlDisplayDevice::write_header(void) {
  fprintf(outfile, "#VRML V1.0 ascii\n");
  fprintf(outfile, "# Created with VMD: "
	  "http://www.ks.uiuc.edu/Research/vmd/\n");
  fprintf(outfile, "Separator {\n");
  //  fprintf(outfile, "PointLight {\n"
  //	  "on TRUE\nintensity 1\n"
  //	  "color 1 1 1\n"
  //	  "location 0 0 2\n"
  //	  "}\n"
  //	  );

  // set the background
  //    fprintf(outfile, "background %f, %f, %f\n", backColor[0],
  //	    backColor[1], backColor[2]);


}
void VrmlDisplayDevice::write_trailer(void)
{
  fprintf(outfile, "# That's all, folks\n}\n");
}
#ifdef MATT_EXPERIMENTAL
/* this needs to either be integrated into VrmDisplayDevce or be moved into
   a new file
      -matt
 */

HashElement::HashElement(float *datum_,int id_){
  printf(" new(not improved)!");
  id_number = id_; 
  datum = datum_;
  sideways = NULL;
  next_element = NULL;
}

HashElement::~HashElement(){
 if(next_element!=NULL)
 free(next_element);
 free(datum);
}

int HashElement::compare_data(float *datum_){
register int i;
if(datum==NULL) printf("skuttle!\n\n");
printf("%d ",id_number);
  for(i=0;i<3;i++){
   printf("%d ",i);
   if(datum[i]!=datum_[i]){printf("out!"); return 0;}
  }

  return 1;
}

int HashElement::AddNext(float *datum_,int id_,HashElement *next){
   if(compare_data(datum_)){ return id_number;}
   if(next_element==NULL){ next_element = next;return id_;}
   else{ return next_element->AddNext(datum_,id_,next);}
}

int HashElement::return_id(float *datum_){
   if(compare_data(datum_)){ return id_number;}
   if(next_element!=NULL){ return next_element->return_id(datum_);}
   else{ printf("what the fuck?\n");return -1;}
}

void HashElement::add_ordered(HashElement *sybling){
   if(sideways!=NULL){sideways->add_ordered(sybling);}
   else{ sideways = sybling;}
}

void HashElement::print_element_vertex(FILE *outfile){

fprintf(outfile," %g %g %g", datum[0], datum[1], datum[2]);

  if(sideways!=NULL){ fprintf(outfile,",\n"); sideways->print_element_vertex(outfile); }
  else{ fprintf(outfile,"\n");}
}

void HashElement::print_element_normal(FILE *outfile){
fprintf(outfile," %g %g %g", datum[3], datum[4], datum[5]);

  if(sideways!=NULL){ fprintf(outfile,",\n"); sideways->print_element_normal(outfile); }
  else{ fprintf(outfile,"\n");}
}

HashTable::HashTable(int size){
HashElement *base;
float base_datum[6] = {0};

  numpoints = 0;
  MAXSIZE = size;
  hTable = new HashElement*[MAXSIZE];

  base = new HashElement(base_datum,numpoints);

  ordered_list = base;  /* base is here in order to avoid checking for a NULL ordered_list */
}

int HashTable::hash_element(float *datum){
float accum=0;
int i;
  for(i=0;i<3;i++){
    accum += datum[i];
  }

  return ((int)(accum *113*15000))%MAXSIZE;
}

void HashTable::insert_element(float *datum){
HashElement *holder;
int location,h;
  location = hash_element(datum);
  if(hTable[location]==NULL){ 
    hTable[location] = new HashElement(datum,numpoints);
    ordered_list->add_ordered(hTable[location]);
    current_point = numpoints;
    numpoints ++;
   }
  else{
   h = numpoints;
   printf("weeble!");
   holder= new HashElement(datum,numpoints);
   h=hTable[location]->AddNext(datum,numpoints,holder);
   if(h==numpoints){ 
      ordered_list->add_ordered(holder);
      current_point = numpoints;
      numpoints++;
     }
   else{ free(holder);} 
     
  }
}

void HashTable::print_hashdata(FILE *outfile){
 printf("ai! \n"); 
   fprintf(outfile,"Normal { vector [\n");
   ordered_list->sideways->print_element_normal(outfile);
   fprintf(outfile,"]\n}");

   fprintf(outfile,"Coordinate3 {point[\n");
   ordered_list->sideways->print_element_vertex(outfile);
   fprintf(outfile,"]\n}");

}

int HashTable::current_element(){
  return current_point;  
}

#endif // MATT_EXPERIMENTAL

