/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: VrmlDisplayDevice.h,v $
 *	$Author: ulrich $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1997/03/21 18:49:31 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************/

#ifndef VRMLDISPLAYDEVICE_H
#define VRMLDISPLAYDEVICE_H

#include <stdio.h>
#include "FileRenderer.h"

class HashElement{
 
  float *datum;
  int id_number;
  public:
  HashElement *next_element, *sideways;
  
  HashElement(float *datum_,int id_);
  ~HashElement();
  int AddNext(float *datum_,int id_,HashElement *next);  /* make sure not to add duplicate points */
  int return_id(float *datum_); 
  int compare_data(float *datum_);
  void print_element_vertex(FILE *outfile);
  void print_element_normal(FILE *outfile);
  void add_ordered(HashElement *sybling);
};

struct HashTable {
  
  HashElement **hTable,*ordered_list;
  int MAXSIZE;
  int numpoints;
  int current_point;

  int hash_element(float *datum);
  public:
  HashTable(int size); 
  ~HashTable(); 
  void insert_element(float *datum); 
  void print_hashdata(FILE *outfile);
  int current_element();
  /* 
     will expect something in the format
      x,y,z,nx,ny,nz
   */
};

class VrmlDisplayDevice : public FileRenderer {

  HashTable *hTable;
  struct triList {
    triList *next;
    int ptz[3];
  };
  triList *tList;
protected:

  //
  // assorted graphics functions
  //
  
  void sphere(float *xyzr);
  void cylinder(float *a, float *b, float rad, int filled);
  void cone    (float *a, float *b, float rad);
  void line(float *xyz1, float *xyz2);

  void triangle(float *, float *, float *, float *, float *, float *);
#ifdef OLD_STUFF
  void point(float *xyz);
  void square(float *, float *, float *, float *, float *);
  void comment (char *);

  // other object information
  void set_line_width(int new_width);
  void set_line_style(int new_style);
  void set_sphere_res(int new_res);
  void set_sphere_style(int new_style);
#endif
  void comment (char *);
  // transformation functions
  void push(void);
  void pop(void);
  void load(Matrix4& mat);
  void multmatrix(Matrix4& mat);

  // set the color
  void set_color(int color_index);

#ifdef OLD_STUFF
  // materials
  void activate_materials(void);
  void deactivate_materials(void);

  // deal with text
  void text_position(float x, float y, float z);
  void text(char *);

  // picking
  void pick_point(float *xyz, int id);
#endif

public:
  // constructor

  VrmlDisplayDevice(void);

  void write_header(void);
  void write_trailer(void);

  //  virtual void render(void *);  /// now done in superclass
}; 

#endif

