/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: utilities.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.18 $	$Date: 1996/12/10 04:59:29 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * General utility routines and definitions.
 *
 ***************************************************************************/
#ifndef UTILITIES_H
#define UTILITIES_H

#include <string.h>

#ifdef ARCH_LINUX
#define sqrtf(x) sqrt(x)
#define fabsf(x) fabs(x)
#define sinf(x) sin(x)
#define cosf(x) cos(x)
#define acosf(x) acos(x)
#endif

#ifndef FALSE
#define FALSE 0
#define TRUE  1
#endif

#ifndef NULL
#define NULL 0
#endif

#ifndef ABS
#define ABS(A) ((A)>0?(A):-(A))
#endif

#ifndef PI
#define PI      3.141592653589793
#endif
#ifndef TWOPI
#define TWOPI   (2.0 * PI)
#endif


// given an argc, argv pair, take all the arguments from the Nth one on
// and combine them into a single string with spaces separating words.  This
// allocates space for the string, which must be freed by the user.
extern char *combine_arguments(int, char **, int);


// make a copy of a string using c++ new routine for memory alloc
extern char *stringdup(const char *);


// convert the given string to upper case
extern char *stringtoupper(char *);


// do case-insensitive string comparisons
extern int strupcmp(const char *, const char *);
extern int strupncmp(const char *, const char *, int);


//  break a file name up into path + name, returning both in the specified
//      character pointers.  This creates storage for the new strings
//      by allocating space for them.
extern void breakup_filename(char *, char **, char **);


// take a string and break it up into tokens, of form <keyword> = <value>
extern char *command_tokenize(char *, int *, char **);


// tokenize a given string; return char ptr if ok, NULL if error
extern char *str_tokenize(char *, int *, char **);

// get the time of day from the system clock, and return it (in seconds)
//	(This is supposedly accurate to within about 1 millisecond
extern double time_of_day(void);


// return the username of the currently logged-on user
extern char *username(void);


// print out malloc info to stderr
extern void meminfo(char *);

// turn the cursor into the WAIT cursor
void start_wait(void);
// return the cursor to its old state
void stop_wait(void);

// compute the cross product, assumes that x1 memory is _different_ 
// than both x2 and x3, and returns the pointer to x1
extern float * cross_prod(float *x1, float *x2, float *x3);

// compute the inner dot product
inline float dot_prod(float *v1, float *v2)
{
 return v1[0]* v2[0] + v1[1]* v2[1] + v1[2] * v2[2];
}

// copy the first 3 elements from v2 to v1
inline void copy(float *v1, float *v2)
{
 memcpy(v1, v2, 3*sizeof(float));
}

// normalizes the 3-vector to length one and returns the pointer
// note that this changes the vector
extern float * normalize(float *);

// subtract 3rd vector from 2nd and put into 1st
// in other words, a = b - c
inline void subtract(float *a, float *b, float *c)
{
 a[0]=b[0]-c[0];
 a[1]=b[1]-c[1];
 a[2]=b[2]-c[2];
}

// add 2nd and 3rd elements, put into 1st
inline void add(float *a, float *b, float *c)
{
 a[0]=b[0]+c[0];
 a[1]=b[1]+c[1];
 a[2]=b[2]+c[2];
}

// compute the midpoint a between two vectors b & c (a = (b + c)/2)
inline void midpoint(float *a, float *b, float *c)
{
 a[0]=0.5*(b[0]+c[0]);
 a[1]=0.5*(b[1]+c[1]);
 a[2]=0.5*(b[2]+c[2]);
}

// compute the angle between two vectors a & b
extern float angle(float *, float *);

// compute the distance between two points a & b
extern float distance(float *, float *);

// compute the squared distance between two points a & b
extern float distance2(float *, float *);

// find and return the norm of a 3-vector
extern float norm(float *);

/// conversion from a string to a boolean
// returns TRUE == 1, FALSE == 0, and unknown == -1
extern int str2bool(const char *s);


//// These are still experimental
// If not using Tcl, these do nothing
// save a selection to the Tcl variable "pick_selection"
void set_pick_selection(int molid, int num, int *atoms);
// make the pick selection be the 'void' selection, molid == -1, text = none
void set_pick_selection(void);

// save a value to the Tcl variable "pick_value
void set_pick_value(int val);
void set_pick_value(double val);
void set_pick_value(char* val);


/// This contains a reference to the previously picked atom
// either from the mouse or one of the 3D tools
void set_picked_atom(int mol, int atomid);
void get_picked_atom(int *mol, int *atomid);

// Used by Global to tell Tcl the value of the newly
// picked mol / atom.  Must delay until then so the label
// appears FIRST, then Tcl can take action.
void announce_picked_atom(void);
#endif

