#ifndef NNSORT_H
#define NNSORT_H

#ifdef __cplusplus
#define NNEXTERN extern "C"
#else
#define NNEXTERN extern
#endif

/* nnhull[23] compute two and three dimensional convex hulls for their
 *  input points, returning dynamically allocated facets (lists of
 *  point indices).
 * nnsimplex[23] compute two and three dimensional Delaunay triangulations
 *  for their input points, returning dynamically allocated:
 *	simplices (lists of 3/4 point indices)
 *	circumcenters (lists of point coordinates)
 *	square radius (lists of doubles)
 * The number of facets or simplices generated is returned from each call.
 * A return value of -1 indicates failure (due to running out of memory).
 * Freeing dynamically allocated data is the responsibility of the caller.
 */
NNEXTERN int nnhull3(
    double (*pt)[3],
    int npt,
    int (**facets)[3]);

NNEXTERN int nnsimplex3(
    double (*pt)[3],
    int npt,
    int (**simplex)[4],
    double (**center)[3],
    double **radius);

NNEXTERN int nnhull2(
    double (*pt)[2],
    int npt,
    int (**facets)[2]);

NNEXTERN int nnsimplex2(
    double (*pt)[2],
    int npt,
    int (**simplex)[3],
    double (**center)[2],
    double **radius);

#endif /*NNSORT_H*/
