############################################################################
#cr                                                                       
#cr            (C) Copyright 1995 The Board of Trustees of the            
#cr                        University of Illinois                         
#cr                         All Rights Reserved                           
#cr                                                                       
############################################################################

############################################################################
# RCS INFORMATION:
#
# 	$RCSfile: basic.tcl,v $
# 	$Author: dalke $	$Locker:  $		$State: Exp $
#	$Revision: 1.1 $	$Date: 1997/03/23 10:21:27 $
#
############################################################################
# DESCRIPTION:
#   Basic Tcl routines to make life easier
#
############################################################################


#  make 'n' duplicates of the args
proc ldup {count val} {
    set retval {}
    for {set i 0} {$i < $count} {incr i} {
	lappend retval $val
    }
    return $retval
}

# remove sequential duplicates
# (I think there is a more standard Tcl way to do this)
proc luniq {list} {
    set retval {}
    set prev {}
    foreach ele $list {
	if [string compare $ele $prev] {
	    set prev $ele
	    lappend retval $ele
	}
    }
    return $retval
}

# generate a unique index, starting from 0

set vmd_unique_index 0
proc unique_id {} {
	global vmd_unique_index
	set i $vmd_unique_index
	incr vmd_unique_index
	return $i
}

# create a unique file with the given prefix
# NOTE: random is a TclX command
proc unique_file {prefix} {
    for {set i 0} {$i < 10} {incr $i} {
	set name $prefix
	append name ".vmd" [random 10000] "." [pid]
	if {![file exists $name]} {
	    return $name
	}
    }
    error "Cannot create temporary file name: $prefix"
}

##############################################################
# localize procedures in Tcl

# This makes a "local" procedure, in that the procedure is removed
# once the local scope is completed.
# Side effect -- if there is already a procedure with this name,
# it is overwritten
# This method works by setting the local variable "upproc_var_$name" and
# setting a trace on it upon unsetting (as when the context is finished)
# This calls "upproc_del" which calls 'rename' on the local proc


# given the $name as something like atomsel0
# I rename the function to nothing (calls the delete proc)
proc upproc_del {name element op} {
  set self [string range $name 11 end]
  rename $self {}
}

# Usage: upproc level procname
# Makes the procedure $procname "local" to the given scope (level takes
# the same parameters as "uplevel", ie, a number or #number).  This
# works by setting upproc_var_$procname in the given namespace and
# ties a trace from the variable to the deletion function.  If the proc
# is local to the current namespace and upproc is called, the current
# tie is removed.  There is no search of the call chain to remove other
# ties.

proc upproc {level procname} {
    # remove a current tie, if it exists
    uplevel 1 [list trace vdelete upproc_var_$procname u upproc_del]
    # ignore if not a number, else raise the level, since I'm in a proc
    if {! [catch {expr $level}]} {incr level}
    # make the local variable (I never use the actual definition)
    uplevel $level [list set upproc_var_$procname 1]
    # set the trace
    uplevel $level [list trace variable upproc_var_$procname u upproc_del]
}
