############################################################################
#cr                                                                       
#cr            (C) Copyright 1995 The Board of Trustees of the            
#cr                        University of Illinois                         
#cr                         All Rights Reserved                           
#cr                                                                       
############################################################################

############################################################################
# RCS INFORMATION:
#
# 	$RCSfile: draw.tcl,v $
# 	$Author: dalke $	$Locker:  $		$State: Exp $
#	$Revision: 1.1 $	$Date: 1997/03/23 10:21:27 $
#
############################################################################
# DESCRIPTION:
#   easy interface to the drawing (graphics) routines
#
############################################################################


# save the previous mol so I don't have to re-search every time
set vmd_draw_last_mol -2
proc draw {symbol args} {
    global vmd_draw_last_mol
    # find the molecule named "graphics"

    # If the index does not exist (meaning, it was deleted or not yet created)
    if [catch "molinfo $vmd_draw_last_mol get index"] {
	# search for the graphics moleulce named "graphics"
	set mol -1
	foreach m [molinfo list] {
	    if [string compare [molinfo $m get {source name}] "Graphics graphics"] {
	    } else {
		set mol $m
	    }
	}
	# if it wasn't found, create a new one
	if {$mol == -1} {
	    set top [molinfo top]
	    mol load graphics graphics
	    set mol [molinfo top]
	    if {$top != -1} {mol top $top}
	}
	set vmd_draw_last_mol $mol
    } else {
	set mol $vmd_draw_last_mol
    }

    # convert to the right format
    if [catch "graphics $mol $symbol $args" errmsg] {
	# if is a base command, don't override it
	if [string compare $errmsg "graphics: don't understand the command: $symbol"] {
	    error $errmsg
	} else {
	    # is this an extension?
	    if [catch "vmd_draw_$symbol $mol $args" errmsg2] {
		error "couldn't find draw extension '$symbol': $errmsg2"
	    }
	}
    }
}
