############################################################################
#cr                                                                       
#cr            (C) Copyright 1995 The Board of Trustees of the            
#cr                        University of Illinois                         
#cr                         All Rights Reserved                           
#cr                                                                       
############################################################################

############################################################################
# RCS INFORMATION:
#
# 	$RCSfile: popup.tcl,v $
# 	$Author: dalke $	$Locker:  $		$State: Exp $
#	$Revision: 1.1 $	$Date: 1997/03/23 10:21:27 $
#
############################################################################
# DESCRIPTION:
# some of the functions available from the popup mouse are 
# implemented here
#
############################################################################


# last file name used (the default "save" file)
set vmd_script_filename "vmdsave.vmd"

# graphical version of save_state 
proc vmd_save_state {} {
    global vmd_script_filename
    set filename [feedback filename "Save the current VMD configuration into" \
		      "" "*.vmd" $vmd_script_filename]
    save_state $filename
    set vmd_script_filename [file tail $filename]
    return
}

# graphical version of save_state, quit at the end
proc vmd_save_state_q {} {
    set filename [feedback filename "Save the current VMD configuration into" \
		      "" "*.vmd" "vmdsave.vmd"]
    save_state $filename
    quit
}


# ask for a script to play, and source it
proc vmd_play_file {} {
    global vmd_script_filename
    set filename [feedback filename "Enter the name of a VMD script file" \
		      "" "*.vmd" $vmd_script_filename]
    source $filename
    set vmd_script_filename [file tail $filename]
    return
}
