############################################################################
#cr                                                                       
#cr            (C) Copyright 1995 The Board of Trustees of the            
#cr                        University of Illinois                         
#cr                         All Rights Reserved                           
#cr                                                                       
############################################################################

############################################################################
# RCS INFORMATION:
#
# 	$RCSfile: external.tcl,v $
# 	$Author: dalke $	$Locker:  $		$State: Exp $
#	$Revision: 1.1 $	$Date: 1997/03/23 10:21:27 $
#
############################################################################
# DESCRIPTION:
# Define the commands for an external connection
#
#  on     -- start me up as a server, save server port in $vmd_serverport#
#
#  host <machine1> (<machine2 ... ) -- allow/ disallow connections via dp_Host
#  connect <machine> -- connect to a server on another machine, saves
#              file id in $vmd_server. If no machine name is given, assumes
#              the local machine
#  send   -- sends RPC command to other machine
#  close  -- detach from remote server
###########################################################################

# The latest Tcl-DP is run-time loadable.  VMD uses options not fully
# implemented in the the 4.0a2 release
package require dp

# print the current remote connection in a human readable form
if {![info exists vmd_external_port]} {
    set vmd_external_port 3349
}

proc external {opt args} {
    global vmd_serverport
    global vmd_server
    global vmd_external_port
    switch -exact -- $opt {
	on {
	    if {[info exists vmd_serverport]} {
		external off
	    }
	    external host -
	    external host +[info hostname]
	    set vmd_serverport [dp_MakeRPCServer $vmd_external_port \
				    dp_CheckHost none 1]
	    return $vmd_serverport
	}
	off {
	    if {[info exists vmd_serverport]} {
		dp_ShutdownServer [lindex $vmd_serverport 0]
		unset vmd_serverport
	    }
	    return
	}
	host {
	    set retval {}
	    foreach name $args {
		lappend retval [dp_Host $name]
	    }
	    return $retval
	}
	    
	connect {
	    if {[llength $args] == 0} {set args [exec hostname]}
	    if {[llength $args] != 1} {
		error "external: connect: takes the hostname as an option"
	    }
	    if {[info exists vmd_server]} {
		external close
	    }
	    puts [list dp_MakeRPCClient [lindex $args 0] \
				$vmd_external_port]
	    set vmd_server [dp_MakeRPCClient [lindex $args 0] \
				$vmd_external_port]
	    return $vmd_server
	}
	send {
	    if {[info exists vmd_server]} {
		return [dp_RPC $vmd_server eval $args]
	    }
	    error "external: send: not connected"
	}
	close {
	    if {[info exists vmd_server]} {
		dp_CloseRPC $vmd_server
		unset vmd_server
	    }
	    return
	}
    }
    # if I get here, there was a problem
    error "external: unknown option '$opt'"
}
