############################################################################
#cr                                                                       
#cr            (C) Copyright 1995 The Board of Trustees of the            
#cr                        University of Illinois                         
#cr                         All Rights Reserved                           
#cr                                                                       
############################################################################

############################################################################
# RCS INFORMATION:
#
# 	$RCSfile: openURL.tcl,v $
# 	$Author: dalke $	$Locker:  $		$State: Exp $
#	$Revision: 1.4 $	$Date: 1997/03/24 17:37:30 $
#
############################################################################
# DESCRIPTION:
#      Point a browser to the given URL, or get a url to a file
#
############################################################################

#  The browser name is retreived from the environment variable
#  VMDHTMLVIEWER.  If it looks like you are running netscape, and
# it fails, try again with just the command name (this assumes you
# are trying funky signalling between Netscape browsers.
#  There is a puts and an error because this option will probably
# be used in buttons/menus w/o recourse to printing to the screen

proc vmd_open_url {url} {
    global env
    set callstr [format $env(VMDHTMLVIEWER) $url $url $url $url $url $url]
    # open the URL -- this is fraught with SECURITY HOLES
    puts "Opening $url ..."
    if {[catch {eval "exec $callstr &"} ermsg]} {
	set browser [string range $env(VMDHTMLVIEWER) 0 7]
	if {$browser == 'netscape'} {
puts stderr "Calling $env(VMDHTMLVIEWER) failed, trying $browser by itself ..."
	    if {[catch {eval "exec $browser $url &"} errmsg]} {
		puts stderr "vmd_open_url failed: $errmsg"
		error "vmd_open_url faile: $errmsg"
	    }
	    return
	}
	puts stderr "vmd_open_url failed: $errmsg"
	error "vmd_open_url failed: $errmsg"
    }
}


#  Implement the help system here as a simple lookup from topic
#  to URL.
set vmd_help_basepage [string trimright [vmdinfo www] /]

array set vmd_help_lookup "
    homepage    {$vmd_help_basepage/}
    quickhelp   {$vmd_help_basepage/vmd_help.html}
    userguide   {$vmd_help_basepage/ug/ug.html}
    faq         {$vmd_help_basepage/vmd_faq.html}
    maillist    {$vmd_help_basepage/mailing_list/}
    software    {$vmd_help_basepage/software/}
    namd        {http://www.ks.uiuc.edu/Research/namd/}
    mdscope     {http://www.ks.uiuc.edu/Research/mdscope/}
    mdcomm      {http://www.ks.uiuc.edu/Research/mdcomm/}
    babel       {ftp://joplin.biosci.arizona.edu/pub/Babel/}
    raster3d    {http://www.bmsc.washington.edu/raster3d/}
    povray      {http://www.povray.org/}
    radiance    {http://radsite.lbl.gov/radiance/HOME.html}
    rayshade    {http://www-graphics.stanford.edu/~cek/rayshade/rayshade.html}
    vrml        {http://vrml.sgi.com/}
    tcl         {http://www.sunlabs.com/research/tcl/}
    stride      {http://www.embl-heidelberg.de/stride/stride_info.html}
"

# The help interface translates the keyword to a URL.  That's all
proc vmd_help {keyword} {
    global vmd_help_lookup
    if {$keyword == "list"} {
	set list {}
	foreach topic [array names vmd_help_lookup] {
	    lappend list [list $topic $vmd_help_lookup($topic)]
	}
	return $list
    }
    if {$keyword == "print"} {
	foreach topic [array names vmd_help_lookup] {
	    puts [format "%-15s => %s" $topic $vmd_help_lookup($topic)]
	}
	return
    }
    if {![info exists vmd_help_lookup($keyword)]} {
	# do this since this will be called from pop-up options and
	error "Cannot find a URL for the topic '$keyword':\n\
other options are 'list' and 'print'"
    }
    vmd_open_url $vmd_help_lookup($keyword)
}


##############################################################

## call url_get -- a perl script which gets a document based on
## its URL

proc url_get {args} {
    global env
    set len [llength $args]
    set progname "$env(VMDDIR)/scripts/vmd/url_get"
    switch -- $len {
	0 { error "Too many parametes to url_get\nUsage: url_get [-bdh] <url> [userid password]" }
	1 { return [exec $progname $args] }
	2 { 
	    lassign $args a b
	    return [exec $progname $a $b]
	}
	3 {
	    lassign $args a b c
	    return [exec $progname $a $b $c]
	    
	}
	4 {
	    lassign $args a b c d
	    return [exec $progname $a $b $c $d]
	}
	default {
	    error "Too many parameters to url_get\nUsage: url_get [-bdh] <url> [userid password]"
        }
    }
}
