############################################################################
#cr                                                                       
#cr            (C) Copyright 1995 The Board of Trustees of the            
#cr                        University of Illinois                         
#cr                         All Rights Reserved                           
#cr                                                                       
############################################################################

############################################################################
# RCS INFORMATION:
#
# 	$RCSfile: remote.tcl,v $
# 	$Author: dalke $	$Locker:  $		$State: Exp $
#	$Revision: 1.1 $	$Date: 1997/03/23 10:21:27 $
#
############################################################################
# DESCRIPTION:
#  Procedures for the remote connection.  Currently just used to print
# information about the current connection status
#
############################################################################



#
#  For now, this only contains the code for listing information about
# the current connection, in human readable.  It is smart enough to
# only print the information relevant to the current connection status.

# print the current remote connection in a human readable form
proc vmd_remote_list_all {} {
    # possible fields to list are: jobs, apps, parameters and connection
    set connection [remote list connection]
    lassign $connection machine user app status

    # check that there is a connection
    if {$status == "No Connection"} {
	puts "No remote connection established -- use 'remote initialize'"
	return
    }
    # Want to print most appropriate information

    puts "Current remote connection setup for"
    puts "User '$user' on '$machine'"
    puts "-----------------------------------"

    if {$status == "Selecting Application"} {
	# print a list of the available applications
	puts "The following apps can be started (use 'remote new <number>')"
	set i 0
	foreach app [remote list apps] {
	    puts "  $i  $app"
	    incr i
	}
	# print a list of the available remote jobs
	set remote_list [remote list jobs]
	if {$remote_list != {} } {
	    puts "The following jobs are available for attachment (use 'remote attach <number>')"
	    set i 0
	    foreach remote $remote_list {
		puts "  $i $remote"
		incr i
	    }
	}
	return
    }

    if {$status == "Editing Parameters"} {
	puts "To change a parameter, use 'remote set <option> <new value>'"
	puts "When ready, use 'remote run'"
	foreach param [remote list parameters] {
	    puts $param
	}
	return
    }
    error "vmd_print_remote shouldn't get here!"
}
