/* This is an example program used to call STEPIT.
   In the associated project file (RUNNER.PRJ) this
   file is linked to STEPIT.C and a large number of
   routines provided in the F2C distribution. It is
   easiest to build a library out of these and the
   stepit code.

   AC 3/3/94 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <math.h>
#include <float.h>

/* below are global declarations for the stepit file. */

#include "f2c.h"

/* Common Block Declarations */
/* released following structure because it was too large. AC 3/3/94 */
/* was structure stpit after f2c */

    doublereal chisq, x[100], xmax[100], xmin[100], deltax[100],
	 delmin[100], delmax[100];
    doublereal huge err[10000] /* was [100][100] */;
    integer mask[100], nv, ntrace, matrix;

    integer jvary;
    integer icalls, imax;

    extern int stepit();

/* these are the global variables used by function funk() */

float da[2][3],pa[2][3],ra[2][3],db[2][3],pb[2][3],rb[2][3],dab[2][3][3],
	  pab[2][3][3],rab[2][3][3],w0,s0[2],sa[2][3],sb[2][3],wa[2],wb[2],
	  a[2],b[2],ss[2],chi[2];

FILE *in, *dat;
char outname[40];
/* end of global defines */

void main(int argc, char *argv[])
{
/* local variables */
int i,j,k;
float ave[2],y[2],ysq[2];
float initial[23] = {  7.0, 12.5, 18.0,       /* A scales, gain */
		       7.0, 12.5, 18.0,       /* A scales, loss */
		       7.0, 12.5, 18.0,       /* B scales, gain */
		       7.0, 12.5, 18.0,       /* B scales, loss */
		       2.0, 2.0,              /* A weights */
		       2.0, 2.0,              /* B weights */
		       1.0, 12.5, 12.5,       /* w0, s0(g), s0(l) */
		       1.0, 1.0, 0.0, 0.0};   /* J fn., A(g,l), B(g,l) */

if (argc != 2) {
   printf("You must include the input file name (with extension) on the\n");
   printf("   command line. Program aborted.\n");
   exit(1); }
if ((in = fopen(argv[1],"r")) == NULL) {
   printf("Input file %s not found. Program aborted.\n",argv[1]);
   exit(1); }
strcpy(outname, argv[1]);
outname[strlen(argv[1])-3] = 'O';
outname[strlen(argv[1])-2] = 'U';
outname[strlen(argv[1])-1] = 'T';
outname[strlen(argv[1])] = NULL;

if ((dat = fopen(outname,"r")) != NULL) {
   printf("Output file %s already exists. Program aborted.\n",outname);
   exit(1); }
if ((dat = fopen(outname,"a")) == NULL) {
   printf("Can't open output file %s. Program aborted.\n",outname);
   exit(1); }

/* read in data from input data file */
for (i=0;i<2;i++) {
   fscanf(in,"%f%f%f%f",&db[i][0],&db[i][0],&db[i][1],&db[i][2]);
   for (j=0;j<3;j++)
	  fscanf(in,"%f%f%f%f",&da[i][j],&dab[i][j][0],&dab[i][j][1],&dab[i][j][2]); }

/* make STEPIT happy */
icalls = 0;
imax = 60000;
nv = 23;
ntrace = 0;
matrix = 105;
for (i=0;i<nv;i++) {
   xmax[i] = 0.0;
   xmin[i] = 0.0;
   delmin[i] = 0.0;
   deltax[i] = 0.0;
   mask[i] = 0.0; }

mask[12] = 1.0;
mask[16] = 1.0;
mask[19] = 1.0;
mask[20] = 1.0;
mask[21] = 1.0;
mask[22] = 1.0;

for (i=0;i<nv;i++) x[i] = initial[i];

for (i=0;i<2;i++) {
   y[i] = 0.0;
   ysq[i] = 0.0; }

for (i=0;i<2;i++)
   for (j=0;j<3;j++) {
	  y[i] += da[i][j];
	  y[i] += db[i][j];
	  ysq[i] += pow(da[i][j],2.0);
	  ysq[i] += pow(db[i][j],2.0);
	  for (k=0;k<3;k++) {
		 y[i] += dab[i][j][k];
		 ysq[i] += pow(dab[i][j][k],2.0); } }

for (i=0;i<2;i++) {
   ave[i] = y[i] / 15.0;
   ss[i] = ysq[i] - 15.0*ave[i]*ave[i]; }

stepit_();

/* print out results */
fprintf(dat,"Program RUNNER.C\n");
for (i=0;i<2;i++) {
   if (i==0) fprintf(dat,"Results, condition 1\n");
   else fprintf(dat,"Results, condition 2\n");
   fprintf(dat,"A alone:\n");
   fprintf(dat,"Data  %5.3f %5.3f %5.3f\n",da[i][0],da[i][1],da[i][2]);
   fprintf(dat,"Pred. %5.3f %5.3f %5.3f\n",pa[i][0],pa[i][1],pa[i][2]);
   fprintf(dat,"Resi. %5.3f %5.3f %5.3f\n",ra[i][0],ra[i][1],ra[i][2]);
   fprintf(dat,"B alone:\n");
   fprintf(dat,"Data  %5.3f %5.3f %5.3f\n",db[i][0],db[i][1],db[i][2]);
   fprintf(dat,"Pred. %5.3f %5.3f %5.3f\n",pb[i][0],pb[i][1],pb[i][2]);
   fprintf(dat,"Resi. %5.3f %5.3f %5.3f\n",rb[i][0],rb[i][1],rb[i][2]);
   fprintf(dat,"A (row) by B (col):\n");
   for (j=0;j<3;j++) {
	  fprintf(dat,"Data  %5.3f %5.3f %5.3f\n",dab[i][j][0],dab[i][j][1],dab[i][j][2]);
	  fprintf(dat,"Pred. %5.3f %5.3f %5.3f\n",pab[i][j][0],pab[i][j][1],pab[i][j][2]);
	  fprintf(dat,"Resi. %5.3f %5.3f %5.3f\n",rab[i][j][0],rab[i][j][1],rab[i][j][2]); }
   } /* end of data, prediction, residual printing */

fprintf(dat,"Parameter values:\n");
fprintf(dat,"Initials w0: %5.1f s0(gain): %5.1f s0(loss): %5.1f\n",w0,s0[0],s0[1]);
fprintf(dat,"A scales (gain): %5.2f %5.2f %5.2f\n",sa[0][0],sa[0][1],sa[0][2]);
fprintf(dat,"A scales (loss): %5.2f %5.2f %5.2f\n",sa[1][0],sa[1][1],sa[1][2]);
fprintf(dat,"B scales (gain): %5.2f %5.2f %5.2f\n",sb[0][0],sb[0][1],sb[0][2]);
fprintf(dat,"B scales (loss): %5.2f %5.2f %5.2f\n",sb[1][0],sb[1][1],sb[1][2]);
fprintf(dat,"A Weights: gain=%5.3f loss=%5.3f\n",wa[0],wa[1]);
fprintf(dat,"B Weights: gain=%5.3f loss=%5.3f\n",wb[0],wb[1]);
fprintf(dat,"J function:\n");
fprintf(dat,"mult(gain)=%5.3f mult(loss)=%5.3f\n",a[0],a[1]);
fprintf(dat,"add(gain)= %5.3f add(loss)= %5.3f\n",b[0],b[1]);
fprintf(dat,"iterations=%d\n",icalls);
fprintf(dat,"chi(g)=%8.4f\tchi(l)=%8.4f\tss(g)=%8.4f\tss(l)=%8.4f\n",chi[0],
		chi[1],ss[0],ss[1]);
fprintf(dat,"Avg. Error = %8.6f\n",chisq/2.0);

fclose(dat);
} /* end of main */

int funk_()
{
int i,j,k,count;
double psi;

/* assign initial values */
count = 0;
for (i=0;i<2;i++)
   for (j=0;j<3;j++) {
      sa[i][j] = x[count];
      count+=1; }
for (i=0;i<2;i++)
   for (j=0;j<3;j++) {
      sb[i][j] = x[count];
      count+=1; }
wa[0] = x[12];
wa[1] = x[13];
wb[0] = x[14];
wb[1] = x[15];
w0 = x[16];
s0[0] = x[17];
s0[1] = x[18];
a[0] = x[19];
a[1] = x[20];
b[0] = x[21];
b[1] = x[22];
chisq = 0.0;
chi[0] = 0.0;
chi[1] = 0.0;

/* begin function computations */

for (i=0;i<2;i++)
   for (j=0;j<3;j++) {
      psi = (w0*s0[i] + wa[i]*sa[i][j]) / (w0 + wa[i]);
      pa[i][j] = b[i] + a[i]*psi;
      ra[i][j] = da[i][j] - pa[i][j];
      chi[i] = chi[i] + ra[i][j]*ra[i][j]; }

for (i=0;i<2;i++)
   for (j=0;j<3;j++) {
      psi = (w0*s0[i] + wb[i]*sb[i][j]) / (w0 + wb[i]);
      pb[i][j] = b[i] + a[i]*psi;
      rb[i][j] = db[i][j] - pb[i][j];
      chi[i] = chi[i] + rb[i][j]*rb[i][j]; }

for (i=0;i<2;i++)
   for (j=0;j<3;j++)
      for (k=0;k<3;k++) {
	 psi = (w0*s0[i] + wa[i]*sa[i][j] + wb[i]*sb[i][k]) /
					(w0 + wa[i] + wb[i]);
	 pab[i][j][k] = b[i] + a[i]*psi;
	 rab[i][j][k] = dab[i][j][k] - pab[i][j][k];
	 chi[i] = chi[i] + rab[i][j][k] * rab[i][j][k]; }

chisq = chi[0] / ss[0] + chi[1] / ss[1];
icalls++;
return 0;
} /* end of subroutine funk() */
