        SUBROUTINE STEPIT                                                 STE00010
C  COPYRIGHT 1965 -- J. P. CHANDLER, PHYSICS DEPT., INDIANA UNIVERSITY. STE00020
C                                                                       STE00030
C  STEPIT 5.2       AUGUST 1967                                         STE00040
C  AVAILABLE FROM....        QUANTUM CHEMISTRY PROGRAM EXCHANGE         STE00050
C                            I.U. CHEMISTRY DEPT., BLOOMINGTON, INDIANA.STE00060
C                                                                       STE00070
C MODIFIED FOR FORTRAN G OS/360 MVT                                     STE00080
C                                                                       STE00090
c
c include commons
c
	include 'stepit.inc'
c
c
      DIMENSION VEC(maxdim),TRIAL(maxdim),XSAVE(maxdim),CHI(maxdim),
     *DX(maxdim),SECOND(2,2)
      DIMENSION OLDVEC(maxdim),SALVO(maxdim),XOSC(maxdim,15),CHIOSC(15),
     *NFLAT(maxdim),DFLOAT(maxdim)
c
C                                                                       STE00190
      NVMAX=maxdim                                                         STE00200
      MOSQUE=15                                                         STE00210
      KW=61                                                             STE00220
      RATIO=10.0                                                        STE00230
      COLIN=0.99                                                        STE00240
      NCOMP=5                                                           STE00250
      ACK=2.0                                                           STE00260
      SIGNIF=2.E8                                                       STE00270
      HUGE=1.E65                                                        STE00280
C                                                                       STE00290
      JVARY=0                                                           STE00300
   40 IF(NV)290,290,50                                                  STE00310
   50 NACTIV=0                                                          STE00320
      DO 150 I=1,NV                                                     STE00330
      IF(MASK(I))150,60,150                                             STE00340
   60 IF(SIGNIF*DABS(DELTAX(I))-DABS(X(I))) 70,70,100                   STE00350
   70 IF(X(I))90,80,90                                                  STE00360
   80 DELTAX(I)=0.01                                                    STE00370
      GO TO 100                                                         STE00380
   90 DELTAX(I)=0.01*X(I)                                               STE00390
  100 IF(DELMIN(I))120,110,120                                          STE00400
  110 DELMIN(I)=DELTAX(I)/SIGNIF                                        STE00410
  120 IF(XMAX(I)-XMIN(I))130,130,140                                    STE00420
  130 XMAX(I)=HUGE                                                      STE00430
      XMIN(I)=-HUGE                                                     STE00440
  140 NACTIV=NACTIV+1                                                   STE00450
      VACD=DMIN1(XMAX(I),X(I))                                          STE00460
      X(I)=DMAX1(XMIN(I),VACD)                                          STE00470
  150 CONTINUE                                                          STE00480
      COMPAR=0.0                                                        STE00490
      IF(NACTIV-1)160,190,180                                           STE00500
  160 DO 170 J=1,NV                                                     STE00510
  170 MASK(J)=0                                                         STE00520
      GO TO 50                                                          STE00530
  180 A=NACTIV                                                          STE00540
      SUB=2.0/(A-1.0)                                                   STE00550
      P=2.0*(1.0/DSQRT(A)/(1.0-0.5**SUB)-1.0)                           STE00560
      COMPAR=DMIN1(9.99D-1,DABS((1.0-(1.0-COLIN)**SUB)*(1.0+P*(1.-COLIN)STE00570
     1)))                                                               STE00580
  190 IF(NTRACE)280,200,200                                             STE00590
200   WRITE (6,210)                                                     STE00600
  210 FORMAT(92H1ENTER SUBROUTINE STEPIT.  COPYRIGHT 1965 J. P. CHANDLERSTE00610
     1, PHYSICS DEPT., INDIANA UNIVERSITY.//19H INITIAL VALUES..../)    STE00620
      WRITE(6,220)(MASK(J),J=1,NV)                                      STE00630
  220 FORMAT(/' MASK   = ',10(I6,6X)/(4X,10I12))                         STE00640
      WRITE(6,230)(X(J),J=1,NV)                                         STE00650
  230 FORMAT(/10H X      = ,10E12.4/(10X,10E12.4))                        STE00660
      WRITE(6,240)(XMAX(J),J=1,NV)                                      STE00670
  240 FORMAT(/10H XMAX   = ,10E12.4/(10X,10E12.4))                        STE00680
      WRITE(6,250)(XMIN(J),J=1,NV)                                      STE00690
  250 FORMAT(/10H XMIN   = ,10E12.4/(10X,10E12.4))                        STE00700
      WRITE(6,260)(DELTAX(J),J=1,NV)                                    STE00710
  260 FORMAT(/10H DELTAX = ,10E12.4/(10X,10E12.4))                        STE00720
      WRITE(6,270)(DELMIN(J),J=1,NV)                                    STE00730
  270 FORMAT(/10H DELMIN = ,10E12.4/(10X,10E12.4))                        STE00740
  280 CALL FUNK                                                         STE00750
      NF=1                                                              STE00760
      JOCK=1                                                            STE00770
  290 IF(NTRACE)320,300,300                                             STE00780
  300 WRITE(6,310)NV,NACTIV,MATRIX,NCOMP,RATIO,ACK,COLIN,COMPAR,CHISQ   STE00790
  310 FORMAT(//' ',I3,' VARIABLES',I3,' ACTIVE.',10X,'MATRIX =',I4,10X,             
     1'NCOMP =',I2//' RATIO =',F5.1,10X,'ACK =',F5.1,10X,'COLIN =',F6.3,
     210X,'COMPAR =',F6.3///' CHISQ =',E15.8)                                         STE00820
  320 IF(NV)2150,2150,330                                               STE00830
  330 IF(NTRACE)360,360,340                                             STE00840
  340 WRITE(6,350)                                                      STE00850
  350 FORMAT(//60(1X,'*')//10X,'TRACE MAP OF MINIMIZATION PROCESS'//)
C                                                                       STE00870
  360 DO 370 I=1,NV                                                     STE00880
      DX(I)=DELTAX(I)                                                   STE00890
      VEC(I)=0.                                                         STE00900
      DO 370 J = 1,20                                                   STE00910
  370 ERR(I,J)=0.                                                       STE00920
      CHIOLD=CHISQ                                                      STE00930
      NOSC=0                                                            STE00940
C                                                                       STE00950
  380 NCIRC=0                                                           STE00960
      NZIP=0                                                            STE00970
C                                                                       STE00980
C  MAIN DO LOOP FOR CYCLING THROUGH THE VARIABLES.                      STE00990
C  FIRST TRIAL STEP WITH EACH VARIABLE IS SEPARATE.                     STE01000
  390 NACK=0                                                            STE01010
      DO 1350 I=1,NV                                                    STE01020
      OLDVEC(I)=VEC(I)                                                  STE01030
      VEC(I)=0.0                                                        STE01040
      TRIAL(I)=0.0                                                      STE01050
      IF(MASK(I))400,410,400                                            STE01060
  400 VEC(I)=-0.0                                                       STE01070
      NFLAT(I)=1                                                        STE01080
      GO TO 1350                                                        STE01090
  410 NACK=NACK+1                                                       STE01100
      SAVE=X(I)                                                         STE01110
      IF(SIGNIF*DABS(DX(I))-DABS(X(I))) 580,580,420                     STE01120
  420 X(I)=SAVE+DX(I)                                                   STE01130
      JVARY=0                                                           STE01140
      IF(JOCK)440,440,430                                               STE01150
  430 JOCK=0                                                            STE01160
      JVARY=I                                                           STE01170
  440 NFLAG=1                                                           STE01180
      IF(X(I)-XMIN(I))460,460,450                                       STE01190
  450 IF(X(I)-XMAX(I))470,460,460                                       STE01200
  460 NFLAG=NFLAG+3                                                     STE01210
      GO TO 490                                                         STE01220
  470 CALL FUNK                                                         STE01230
      IF(ICALLS.LE.IMAX)GO TO 10                                        STE01240
      RETURN                                                            STE01250
   10 CONTINUE                                                          STE01260
      NF=NF+1                                                           STE01270
      JVARY=I                                                           STE01280
      CHIME=CHISQ                                                       STE01290
      IF(CHISQ-CHIOLD)620,480,490                                       STE01300
  480 NFLAG=NFLAG+1                                                     STE01310
  490 X(I)=SAVE-DX(I)                                                   STE01320
      IF(X(I)-XMIN(I))590,590,500                                       STE01330
  500 IF(X(I)-XMAX(I))510,590,590                                       STE01340
  510 CALL FUNK                                                         STE01350
      NF=NF+1                                                           STE01360
      JVARY=I                                                           STE01370
      IF(CHISQ-CHIOLD)610,520,530                                       STE01380
  520 NFLAG=NFLAG+1                                                     STE01390
  530 IF(NFLAG-3)540,580,590                                            STE01400
  540 IF((CHISQ-CHIME)*(CHIME-2.*CHIOLD+CHISQ))550,590,550              STE01410
  550 TRIAL(I)=.5*DX(I)*(CHISQ-CHIME)/(CHIME-2.*CHIOLD+CHISQ)           STE01420
      VEC(I)=TRIAL(I)/DABS(DX(I))                                       STE01430
      NFLAT(I)=0                                                        STE01440
      X(I)=SAVE+TRIAL(I)                                                STE01450
      CALL FUNK                                                         STE01460
      NF=NF+1                                                           STE01470
      IF(CHISQ-CHIOLD)560,570,570                                       STE01480
  560 CHIOLD=CHISQ                                                      STE01490
      JOCK=1                                                            STE01500
      GO TO 600                                                         STE01510
  570 TRIAL(I)=0.0                                                      STE01520
      VEC(I)=0.0                                                        STE01530
      GO TO 590                                                         STE01540
  580 VEC(I)=-0.0                                                       STE01550
      NFLAT(I)=1                                                        STE01560
  590 X(I)=SAVE                                                         STE01570
  600 NCIRC=NCIRC+1                                                     STE01580
      IF(NCIRC-NACTIV)690,1430,1430                                     STE01590
  610 DX(I)=-DX(I)                                                      STE01600
C                                                                       STE01610
C  A LOWER VALUE HAS BEEN FOUND.  HENCE THIS VARIABLE WILL CHANGE.      STE01620
C                                                                       STE01630
  620 NCIRC=0                                                           STE01640
      DEL=DX(I)                                                         STE01650
  630 CHIME=CHIOLD                                                      STE01660
      CHIOLD=CHISQ                                                      STE01670
      VEC(I)=VEC(I)+DEL/DABS(DX(I))                                     STE01680
      NFLAT(I)=0                                                        STE01690
      TRIAL(I)=TRIAL(I)+DEL                                             STE01700
      DEL=ACK*DEL                                                       STE01710
      SAVE=X(I)                                                         STE01720
      X(I)=SAVE+DEL                                                     STE01730
      IF(X(I)-XMIN(I))680,680,640                                       STE01740
  640 IF(X(I)-XMAX(I))650,680,680                                       STE01750
  650 CALL FUNK                                                         STE01760
      NF=NF+1                                                           STE01770
      IF(CHISQ-CHIOLD)630,660,660                                       STE01780
660    ZZZ=ACK*CHIME-(ACK+1.0)*CHIOLD+CHISQ                             STE01790
      IF(ZZZ .EQ. 0.) GO TO 661                                         STE01800
      CINDER=(0.5/ACK)*(ACK**2*CHIME-(ACK**2-1.0)*CHIOLD-CHISQ)/ZZZ     STE01810
      GO TO 662                                                         STE01820
661   CINDER =0.0                                                       STE01830
662   X(I)=SAVE+CINDER*DEL                                              STE01840
      CALL FUNK                                                         STE01850
      NF=NF+1                                                           STE01860
      IF(CHISQ-CHIOLD)670,680,680                                       STE01870
  670 CHIOLD=CHISQ                                                      STE01880
      TRIAL(I)=TRIAL(I)+CINDER*DEL                                      STE01890
      VEC(I)=VEC(I)+CINDER*DEL/DABS(DX(I))                              STE01900
      GO TO 690                                                         STE01910
  680 X(I)=SAVE                                                         STE01920
  690 IF(NZIP-1)1340,700,700                                            STE01930
  700 IF(DABS(VEC(I))-ACK) 750,710,710                                  STE01940
  710 DX(I)=ACK*DABS(DX(I))                                             STE01950
      VEC(I)=VEC(I)/ACK                                                 STE01960
      OLDVEC(I)=OLDVEC(I)/ACK                                           STE01970
      DO 720 J=1,MOSQUE                                                 STE01980
  720 ERR(I,J)=ERR(I,J)/ACK                                             STE01990
      IF(NTRACE)750,750,730                                             STE02000
  730 WRITE(6,740)I,DX(I)                                               STE02010
  740 FORMAT(' STEP SIZE',I3,' INCREASED TO ',E12.5)                    STE02020
  750 SUMO=0.0                                                          STE02030
      SUMV=0.0                                                          STE02040
      DO 760 J=1,NV                                                     STE02050
      SUMO=SUMO+OLDVEC(J)**2                                            STE02060
  760 SUMV=SUMV+VEC(J)**2                                               STE02070
      IF(SUMO*SUMV)1340,1340,770                                        STE02080
  770 SUMO=DSQRT(SUMO)                                                  STE02090
      SUMV=DSQRT(SUMV)                                                  STE02100
      COSINE=0.0                                                        STE02110
      DO 780 J=1,NV                                                     STE02120
  780 COSINE=COSINE+(OLDVEC(J)/SUMO)*(VEC(J)/SUMV)                      STE02130
      IF(NZIP-1)1340,790,800                                            STE02140
  790 IF(NACK-NACTIV)1340,820,820                                       STE02150
  800 IF(NACK-NACTIV)820,810,810                                        STE02160
  810 IF(NZIP-NCOMP)820,830,830                                         STE02170
  820 IF(COSINE-COMPAR)1340,830,830                                     STE02180
C                                                                       STE02190
C  SIMON SAYS, TAKE AS MANY GIANT STEPS AS POSSIBLE...                  STE02200
C                                                                       STE02210
  830 IF(NTRACE)860,860,840                                             STE02220
  840 WRITE(6,850)CHIOLD,(VEC(J),J=1,I)                                 STE02230
  850 FORMAT(' CHISQ =',E15.8,5X,'NO. OF STEPS =10',F9.2/(42X,10F9.2))     STE02240
  860 NGIANT=0                                                          STE02250
      NTRY=0                                                            STE02260
      NRETRY=0                                                          STE02270
      KL=1                                                              STE02280
      NOSC=NOSC+1                                                       STE02290
      IF(NOSC-MOSQUE)890,890,870                                        STE02300
  870 NOSC=MOSQUE                                                       STE02310
      DO 880 K=2,MOSQUE                                                 STE02320
      CHIOSC(K-1)=CHIOSC(K)                                             STE02330
      DO 880 J=1,NV                                                     STE02340
      XOSC(J,K-1)=XOSC(J,K)                                             STE02350
  880 ERR(J,K-1)=ERR(J,K)                                               STE02360
  890 DO 900 J=1,NV                                                     STE02370
      XOSC(J,NOSC)=X(J)                                                 STE02380
  900 ERR(J,NOSC)=VEC(J)/SUMV                                           STE02390
      CHIOSC(NOSC)=CHIOLD                                               STE02400
      IF(NOSC-3)960,910,910                                             STE02410
C                                                                       STE02420
C  SEARCH FOR A PREVIOUS SUCCESSFUL GIANT STEP IN A DIRECTION MORE      STE02430
C  NEARLY PARALLEL TO THE DIRECTION OF THE PROPOSED STEP THAN WAS THE   STE02440
C  IMMEDIATELY PREVIOUS ONE.                                            STE02450
C                                                                       STE02460
  910 COXCOM=0.0                                                        STE02470
      DO 920 J=1,NV                                                     STE02480
  920 COXCOM=COXCOM+ERR(J,NOSC)*ERR(J,NOSC-1)                           STE02490
      NAH=NOSC-2                                                        STE02500
  930 NTRY=0                                                            STE02510
      DO 950 K=KL,NAH                                                   STE02520
      NRETRY=NAH-K                                                      STE02530
      COSINE=0.0                                                        STE02540
      DO 940 J=1,NV                                                     STE02550
  940 COSINE=COSINE+ERR(J,NOSC)*ERR(J,K)                                STE02560
      IF(COSINE-COXCOM)950,950,970                                      STE02570
  950 CONTINUE                                                          STE02580
  960 CHIBAK=CHI(I)                                                     STE02590
      GO TO 1020                                                        STE02600
  970 NTRY=1                                                            STE02610
      KL=K+1                                                            STE02620
      IF(NTRACE)1000,1000,980                                           STE02630
  980 NT=NOSC-K                                                         STE02640
      WRITE(6,990)NT                                                    STE02650
  990 FORMAT(/1X,'********',5X,' POSSIBLE OSCILLATION WITH PERIOD ',I2,    STE02660
     1   ' DETECTED.')  
 1000 DO 1010 J=1,NV                                                    STE02680
      SALVO(J)=TRIAL(J)                                                 STE02690
 1010 TRIAL(J)=(X(J)-XOSC(J,K))/ACK                                     STE02700
      CHIBAK=CHIOLD+(CHIOSC(K)-CHIOLD)/ACK                              STE02710
C                                                                       STE02720
 1020 DO 1040 J=1,NV                                                    STE02730
      XSAVE(J)=X(J)                                                     STE02740
      TRIAL(J)=ACK*TRIAL(J)                                             STE02750
      IF(MASK(J))1040,1030,1040                                         STE02760
 1030 TRAAL=X(J)+TRIAL(J)                                               STE02770
      TRAIL=DMIN1(TRAAL,XMAX(J))                                        STE02780
      X(J)=DMAX1(TRAIL,XMIN(J))                                         STE02790
 1040 CONTINUE                                                          STE02800
      JOCK=0                                                            STE02810
      JVARY=0                                                           STE02820
      CALL FUNK                                                         STE02830
      NF=NF+1                                                           STE02840
      IF(CHISQ-CHIOLD)1050,1080,1080                                    STE02850
 1050 CHIBAK=CHIOLD                                                     STE02860
      CHIOLD=CHISQ                                                      STE02870
      NGIANT=NGIANT+1                                                   STE02880
      IF(NTRACE)1020,1020,1060                                          STE02890
 1060 WRITE(6,1070)CHISQ,(X(J),J=1,NV)                                  STE02900
 1070 FORMAT(' CHISQ =',E15.8/' X(I)....'/(10(1X,E12.5)))                 STE02910
      GO TO 1020                                                        STE02920
C                                                                       STE02930
 1080 IF(NRETRY)1100,1100,1090                                          STE02940
 1090 IF(NGIANT)1150,1150,1100                                          STE02950
 1100 CINDER=(0.5/ACK)*(ACK**2*CHIBAK-(ACK**2-1.0)*CHIOLD-CHISQ)/       STE02960
     1   (ACK*CHIBAK-(ACK+1.0)*CHIOLD+CHISQ)                            STE02970
      DO 1120 J=1,NV                                                    STE02980
      IF(MASK(J))1120,1110,1120                                         STE02990
 1110 CANDER=XSAVE(J)+CINDER*TRIAL(J)                                   STE03000
      XIJ=DMIN1(CANDER,XMAX(J))                                         STE03010
      X(J)=DMAX1(XIJ,XMIN(J))                                           STE03020
 1120 CONTINUE                                                          STE03030
      JOCK=0                                                            STE03040
      JVARY=0                                                           STE03050
      CALL FUNK                                                         STE03060
      NF=NF+1                                                           STE03070
      IF(CHISQ-CHIOLD)1280,1130,1130                                    STE03080
 1130 IF(NGIANT)1170,1140,1170                                          STE03090
 1140 IF(NTRY)1150,1170,1150                                            STE03100
 1150 DO 1160 J=1,NV                                                    STE03110
      TRIAL(J)=SALVO(J)                                                 STE03120
 1160 X(J)=XSAVE(J)                                                     STE03130
      GO TO 1190                                                        STE03140
 1170 DO 1180 J=1,NV                                                    STE03150
      TRIAL(J)=TRIAL(J)/ACK                                             STE03160
 1180 X(J)=XSAVE(J)                                                     STE03170
 1190 IF(NTRACE)1240,1240,1200                                          STE03180
 1200 WRITE(6,1210)CHIOLD,NGIANT                                        STE03190
 1210 FORMAT(/' CHISQ =',E15.8,'  AFTER',I3,' GIANT STEPS.'  )           STE03200
      WRITE(6,1220)(X(J),J=1,NV)                                        STE03210
 1220 FORMAT(' X(I)....'/(10(1X,E12.5)))                                 STE03220
      WRITE(6,1230)                                                     STE03230
 1230 FORMAT(/)                                                         STE03240
 1240 IF(NGIANT)1250,1250,1310                                          STE03250
 1250 IF(NRETRY)1260,1260,930                                           STE03260
 1260 IF(NTRY)1270,1330,1270                                            STE03270
 1270 NTRY=0                                                            STE03280
      GO TO 960                                                         STE03290
C                                                                       STE03300
 1280 CHIOLD=CHISQ                                                      STE03310
      JOCK=1                                                            STE03320
      IF(NTRACE)1310,1310,1290                                          STE03330
 1290 STEPS=DFLOAT(NGIANT)+CINDER                                       STE03340
      WRITE(6,1300)CHIOLD,STEPS                                         STE03350
 1300 FORMAT(/' CHISQ =',E15.8,'  AFTER',F6.1,' GIANT STEPS.'   )        STE03360
      WRITE(6,1220)(X(J),J=1,NV)                                        STE03370
      WRITE(6,1230)                                                     STE03380
1310   IF (NTRY) 1320,380,1320                                          STE03390
 1320 NOSC=0                                                            STE03400
      GO TO 380                                                         STE03410
1330  NOSC=MAX0(NOSC-1,0)                                               STE03420
 1340 CHI(I)=CHIOLD                                                     STE03430
 1350 CONTINUE                                                          STE03440
C                                                                       STE03450
C  ANOTHER CYCLE THROUGH THE VARIABLES HAS BEEN COMPLETED.              STE03460
C  PRINT ANOTHER LINE OF TRACES.                                        STE03470
C                                                                       STE03480
      IF(NTRACE)1370,1370,1360                                          STE03490
 1360 WRITE(6,850)CHIOLD,(VEC(J),J=1,NV)                                STE03500
1370    CONTINUE                                                        STE03510
 1380 IF(NZIP)1420,1390,1420                                            STE03520
 1390 IF(NTRACE)1420,1420,1400                                          STE03530
 1400 WRITE(6,1220)(X(J),J=1,NV)                                        STE03540
      WRITE(6,1410)                                                     STE03550
 1410 FORMAT(1H )                                                       STE03560
 1420 NZIP=NZIP+1                                                       STE03570
      GO TO 390                                                         STE03580
C                                                                       STE03590
C  A MINIMUM HAS BEEN FOUND.  PRINT THE REMAINING TRACES.               STE03600
C                                                                       STE03610
 1430 IF(NTRACE)1450,1450,1440                                          STE03620
 1440 WRITE(6,850)CHIOLD,(VEC(J),J=1,I)                                 STE03630
 1450 IF(NTRACE)1470,1470,1460                                          STE03640
 1460 WRITE(6,1220)(X(J),J=1,NV)                                        STE03650
      WRITE(6,1230)                                                     STE03660
C                                                                       STE03670
C  DECREASE THE SIZE OF THE STEPS FOR ALL VARIABLES.                    STE03680
C                                                                       STE03690
1470   CONTINUE                                                         STE03700
 1480 NOSC=0                                                            STE03710
      NGATE=1                                                           STE03720
      DO 1520 J=1,NV                                                    STE03730
      IF(MASK(J))1520,1490,1520                                         STE03740
 1490 IF(NFLAT(J))1500,1500,1520                                        STE03750
 1500 IF(DABS(DX(J))-DABS(DELMIN(J))) 1520,1520,1510                    STE03760
 1510 NGATE=0                                                           STE03770
 1520 DX(J)=DX(J)/RATIO                                                 STE03780
      IF(NGATE)1530,1530,1600                                           STE03790
 1530 IF(NTRACE)1570,1570,1540                                          STE03800
 1540 WRITE(6,1550)(DX(J),J=1,NV)                                       STE03810
 1550 FORMAT(60(1X,'*')//' STEP SIZES REDUCED TO....'//(10(1X,E12.5)))   STE03820
      WRITE(6,1560)                                                     STE03830
 1560 FORMAT(//)                                                        STE03840
 1570   GO TO 380                                                       STE03850
 1580 WRITE(6,1590)(DX(J),J=1,NV)                                       STE03860
 1590 FORMAT ('  OPERAT. TERM.'//10(1X,E12.5))                          STE03870
C                                                                       STE03880
 1600 CHISQ=CHIOLD                                                      STE03890
      IF(NTRACE)1630,1610,1610                                          STE03900
 1610 WRITE(6,1620)NF                                                   STE03910
 1620 FORMAT(// 1X,I5,23H FUNCTION COMPUTATIONS     )                   STE03920
1630   CONTINUE                                                         STE03930
1640  IF (IABS(MATRIX-100)-50) 1650,1650,2160                           STE03940
 1650 IF(NACTIV-NV)2160,1660,2160                                       STE03950
C                                                                       STE03960
C  COMPUTE THE STANDARD ERRORS AND THE CORRELATIONS.                    STE03970
C                                                                       STE03980
 1660 FAC=RATIO**(MATRIX-100)                                           STE03990
      DO 1680 I=1,NV                                                    STE04000
      DX(I)=DABS(FAC*DX(I))                                             STE04010
      XSAVE(I)=X(I)                                                     STE04020
      JVARY=0                                                           STE04030
      DO 1670 J=1,2                                                     STE04040
      X(I)=XSAVE(I)+DX(I)                                               STE04050
      CALL FUNK                                                         STE04060
      NF=NF+1                                                           STE04070
      JVARY=I                                                           STE04080
      SECOND(1,J)=CHISQ                                                 STE04090
 1670 DX(I)=-DX(I)                                                      STE04100
      X(I)=XSAVE(I)                                                     STE04110
 1680 ERR(I,I)=(SECOND(1,1)-2.0*CHIOLD+SECOND(1,2))/DX(I)**2            STE04120
      DO 1710 I=2,NV                                                    STE04130
      IM=I-1                                                            STE04140
      DO 1710 J=1,IM                                                    STE04150
      DO 1700 K=1,2                                                     STE04160
      X(I)=XSAVE(I)+DX(I)                                               STE04170
      JVARY=0                                                           STE04180
      DO 1690 L=1,2                                                     STE04190
      X(J)=XSAVE(J)+DX(J)                                               STE04200
      CALL FUNK                                                         STE04210
      NF=NF+1                                                           STE04220
      JVARY=J                                                           STE04230
      SECOND(K,L)=CHISQ                                                 STE04240
      X(J)=XSAVE(J)                                                     STE04250
 1690 DX(J)=-DX(J)                                                      STE04260
      X(I)=XSAVE(I)                                                     STE04270
 1700 DX(I)=-DX(I)                                                      STE04280
      ERR(I,J)=0.25*(SECOND(1,1)-SECOND(1,2)-SECOND(2,1)+SECOND(2,2))   STE04290
     1/DABS(DX(I)*DX(J))                                                STE04300
 1710 ERR(J,I)=ERR(I,J)                                                 STE04310
      IF(NTRACE)1770,1720,1720                                          STE04320
 1720 WRITE(6,1730)                                                     STE04330
 1730 FORMAT(41H1SIZES OF INCREMENTS TO BE USED BELOW....)              STE04340
      WRITE(6,1740)(DX(J),J=1,NV)                                       STE04350
 1740 FORMAT(/(10(1X,E12.5)))                                            STE04360
      WRITE(6,1750)                                                     STE04370
 1750 FORMAT(/////' MATRIX OF THE SECOND PARTIAL DERIVATIVES.... '/)   
      DO 1760 I=1,NV                                                    STE04390
 1760 WRITE(6,1740)(ERR(I,J),J=1,I)                                     STE04400
 1770 DO 1780 I=1,NV                                                    STE04410
      DO 1780 J=1,I                                                     STE04420
      IF(ERR(I,J))1780,1790,1780                                        STE04430
 1780 CONTINUE                                                          STE04440
      GO TO 1810                                                        STE04450
 1790 WRITE(6,1800)                                                     STE04460
 1800 FORMAT(////123H THE ABOVE MATRIX CONTAINS ONE OR MORE ZEROES.  A LSTE04470
     1ARGER VALUE OF 'MATRIX' SHOULD BE TRIED, TO SEE IF THEY ARE LEGITISTE04480
     2MATE.       )                                                     STE04490
C                                                                       STE04500
C  INVERT THE MATRIX USING SYMINV2 (COMM. OF THE A.C.M. 6, P. 67).      STE04510
C                                                                       STE04520
 1810 DET=1.0                                                           STE04530
      DETLOG=0.                                                         STE04540
      DO 1820 J=1,NV                                                    STE04550
 1820 SALVO(J)=1.0                                                      STE04560
      DO 1970 I=1,NV                                                    STE04570
      BIGAJJ=0.0                                                        STE04580
      DO 1850 J=1,NV                                                    STE04590
      IF(SALVO(J))1830,1850,1830                                        STE04600
 1830 IF(DABS(ERR(J,J))-BIGAJJ) 1850,1850,1840                          STE04610
 1840 BIGAJJ=DABS(ERR(J,J))                                             STE04620
      K=J                                                               STE04630
 1850 CONTINUE                                                          STE04640
      IF(BIGAJJ)1870,1860,1870                                          STE04650
 1860 DET=0.0                                                           STE04660
      GO TO 1980                                                        STE04670
 1870 SALVO(K)=0.0                                                      STE04680
       IF (DET .GT. 1.E48 .OR. DET .LT.1.E-48) GO TO 1871               STE04690
      GO TO 1875                                                        STE04700
1871   WRITE (6,1872)                                                   STE04710
1872   FORMAT (///,'DETERMINANT COMPUTATION WILL CAUSE OVERFLOW.')      STE04720
      GO TO 2160                                                        STE04730
1875  DET=DET*ERR(K,K)                                                  STE04740
      DETLOG=DETLOG+DLOG(DABS(ERR(K,K)))/2.303                          STE04750
      TRIAL(K)=1.0/ERR(K,K)                                             STE04760
      ERR(K,K)=0.0                                                      STE04770
      XSAVE(K)=1.0                                                      STE04780
      M=K-1                                                             STE04790
      IF(M)1910,1910,1880                                               STE04800
 1880 DO 1900 J=1,M                                                     STE04810
      XSAVE(J)=ERR(K,J)                                                 STE04820
      TRIAL(J)=ERR(K,J)*TRIAL(K)                                        STE04830
      IF(SALVO(J))1860,1900,1890                                        STE04840
 1890 TRIAL(J)=-TRIAL(J)                                                STE04850
 1900 ERR(K,J)=0.0                                                      STE04860
 1910 M=K+1                                                             STE04870
      IF(M-NV)1920,1920,1960                                            STE04880
 1920 DO 1950 J=M,NV                                                    STE04890
      XSAVE(J)=ERR(J,K)                                                 STE04900
      IF(SALVO(J))1860,1930,1940                                        STE04910
 1930 XSAVE(J)=-XSAVE(J)                                                STE04920
 1940 TRIAL(J)=-ERR(J,K)*TRIAL(K)                                       STE04930
 1950 ERR(J,K)=0.0                                                      STE04940
 1960 DO 1970 J=1,NV                                                    STE04950
      DO 1970 K=J,NV                                                    STE04960
 1970 ERR(K,J)=ERR(K,J)+XSAVE(J)*TRIAL(K)                               STE04970
      IF(DET)2000,1980,2020                                             STE04980
 1980 WRITE(6,1990)                                                     STE04990
 1990 FORMAT(////67H ERROR MATRIX IS SINGULAR.  'MATRIX' SHOULD PROBABLYSTE05000
     1 BE INCREASED.              /////)                                STE05010
      GO TO 2150                                                        STE05020
 2000 WRITE(6,2010)                                                     STE05030
 2010 FORMAT(////75H ERROR MATRIX IS NEGATIVE DEFINITE.  'MATRIX' SHOULDSTE05040
     1 PROBABLY BE DECREASED.   )                                       STE05050
 2020 IF(NTRACE)2050,2030,2030                                          STE05060
 2030 WRITE(6,2040)DET,DETLOG                                           STE05070
 2040 FORMAT(////' DETERMINANT OF ABOVE MATRIX = ',E12.5,10X,            STE05080
     1   'LOG10F(DET) = ',E12.5)                                        STE05090
 2050 DO 2090 I=1,NV                                                    STE05100
      DO 2060 J=1,I                                                     STE05110
      ERR(I,J)=ERR(I,J)*2.0                                             STE05120
 2060 ERR(J,I)=ERR(I,J)                                                 STE05130
      IF(ERR(I,I))2070,2070,2090                                        STE05140
 2070 WRITE(6,2080)ERR(I,I)                                             STE05150
 2080 FORMAT(///50H NEGATIVE OR ZERO MEAN SQUARE ERROR ENCOUNTERED...,  STE05160
     13X,E15.8/39H 'MATRIX' SHOULD PROBABLY BE DECREASED. ///)          STE05170
 2090 XSAVE(I)=DSIGN(DSQRT(DABS(ERR(I,I))),ERR(I,I))                    STE05180
      IF(NTRACE)2160,2100,2100                                          STE05190
 2100 WRITE(6,2110)                                                     STE05200
 2110 FORMAT(/////20H STANDARD ERRORS.... )                             STE05210
      WRITE(6,1740)(XSAVE(J),J=1,NV)                                    STE05220
      WRITE(6,2120)                                                     STE05230
 2120 FORMAT(/////45H LOWER TRIANGLE OF THE CORRELATION MATRIX.... /)   STE05240
      DO 2140 I=2,NV                                                    STE05250
      IM=I-1                                                            STE05260
      DO 2130 J=1,IM                                                    STE05270
 2130 TRIAL(J)=ERR(I,J)/DABS(XSAVE(I)*XSAVE(J))                         STE05280
 2140 WRITE(6,1740)(TRIAL(J),J=1,IM)                                    STE05290
 2150 WRITE(6,1620)NF                                                   STE05300
C                                                                       STE05310
2160  CONTINUE                                                          STE05320
 2190 JVARY=0                                                           STE05330
      CALL FUNK                                                         STE05340
      IF(NTRACE)2230,2200,2200                                          STE05350
 2200 WRITE(6,2210)(X(J),J=1,NV)                                        STE05360
 2210 FORMAT(///10X,'FINAL VALUES OF X(I)....'//(7(1X,E16.9)))           STE05370
      WRITE(6,2220)CHISQ                                                STE05380
 2220 FORMAT(// ' FINAL VALUE OF CHISQ =  ',E15.8//)                    STE05390
 2230 RETURN                                                            STE05400
      END                                                               STE05410
