MODULE pes_h2c2o1s
!..use and access
use pes, wp=>pes_wp
private
public :: h2c2o1s_init, h2c2o1s_pot, h2c2o1s_vinit, h2c2o1s_vfun
!..data
save
integer, parameter :: &
  nki(0:2)=(/2,2,1/), nk=5, iord(0:nk-1)=(/0,1,2,3,4/)
real (kind=wp) :: x1_cf, y1_cf, z1_cf
type (cx_t) :: &
  x2_pc = cx_null, x2_vpc = cx_null, &
  x1y1_pc = cx_null, x1y1_vpc = cx_null, &
  y2_pc = cx_null, y2_vpc = cx_null, &
  x1z1_pc = cx_null, x1z1_vpc = cx_null, &
  y1z1_pc = cx_null, y1z1_vpc = cx_null, &
  x2y1_pc = cx_null, x2y1_vpc = cx_null, &
  x1y2_pc = cx_null, x1y2_vpc = cx_null, &
  x2z1_pc = cx_null, x2z1_vpc = cx_null, &
  x1y1z1_pc = cx_null, x1y1z1_vpc = cx_null, &
  y2z1_pc = cx_null, y2z1_vpc = cx_null, &
  x2y2_pc = cx_null, x2y2_vpc = cx_null, &
  x2y1z1_pc = cx_null, x2y1z1_vpc = cx_null, &
  x1y2z1_pc = cx_null, x1y2z1_vpc = cx_null, &
  x2y2z1_pc = cx_null, x2y2z1_vpc = cx_null
real (kind=wp) :: x1_vcf(0:0), y1_vcf(0:0), z1_vcf(0:0)
real (kind=wp), allocatable :: &
  x2_cf(:), x2_vcf(:), &
  x1y1_cf(:), x1y1_vcf(:), &
  y2_cf(:), y2_vcf(:), &
  x1z1_cf(:), x1z1_vcf(:), &
  y1z1_cf(:), y1z1_vcf(:), &
  x2y1_cf(:), x2y1_vcf(:), &
  x1y2_cf(:), x1y2_vcf(:), &
  x2z1_cf(:), x2z1_vcf(:), &
  x1y1z1_cf(:), x1y1z1_vcf(:), &
  y2z1_cf(:), y2z1_vcf(:), &
  x2y2_cf(:), x2y2_vcf(:), &
  x2y1z1_cf(:), x2y1z1_vcf(:), &
  x1y2z1_cf(:), x1y2z1_vcf(:), &
  x2y2z1_cf(:), x2y2z1_vcf(:)
!..procedures
CONTAINS
SUBROUTINE h2c2o1s_init (dirname)
character (len=*), intent (in) :: dirname
!------------------------------------------------------------------------
integer :: iun, nb
logical :: b0
character (len=255) :: chd
call pes_getiun (iun)
b0 = dirname(len_trim(dirname):len_trim(dirname)).eq.'/'
if (b0) then
 chd = dirname
else
 chd = trim(dirname)//'/'
endif
write (*,*) 'Principal data directory: ', chd(1:len_trim(chd))
write (*,*) ' reading pcf-x1.dat'
open (iun, status='old', file=trim(chd)//'pcf-x1.dat')
read (iun,*) x1_cf
close (iun)
write (*,*) ' reading pcf-y1.dat'
open (iun, status='old', file=trim(chd)//'pcf-y1.dat')
read (iun,*) y1_cf
close (iun)
write (*,*) ' reading pcf-z1.dat'
open (iun, status='old', file=trim(chd)//'pcf-z1.dat')
read (iun,*) z1_cf
close (iun)
write (*,*) ' reading pcf-x2.dat'
open (iun, status='old', file=trim(chd)//'pcf-x2.dat')
read (iun,*) x2_pc
read (iun,*) nb
if (nb.ne.pes_x2_nb(x2_pc%dg)) then
 stop 'h2c2o1s_init: x2 dimension error'
endif
allocate (x2_cf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x2_cf
endif
close (iun)
write (*,*) ' reading pcf-x1y1.dat'
open (iun, status='old', file=trim(chd)//'pcf-x1y1.dat')
read (iun,*) x1y1_pc
read (iun,*) nb
if (nb.ne.pes_x1y1_nb(x1y1_pc%dg)) then
 stop 'h2c2o1s_init: x1y1 dimension error'
endif
allocate (x1y1_cf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x1y1_cf
endif
close (iun)
write (*,*) ' reading pcf-y2.dat'
open (iun, status='old', file=trim(chd)//'pcf-y2.dat')
read (iun,*) y2_pc
read (iun,*) nb
if (nb.ne.pes_y2_nb(y2_pc%dg)) then
 stop 'h2c2o1s_init: y2 dimension error'
endif
allocate (y2_cf(0:nb-1))
if (1.le.nb) then
 read (iun,*) y2_cf
endif
close (iun)
write (*,*) ' reading pcf-x1z1.dat'
open (iun, status='old', file=trim(chd)//'pcf-x1z1.dat')
read (iun,*) x1z1_pc
read (iun,*) nb
if (nb.ne.pes_x1z1_nb(x1z1_pc%dg)) then
 stop 'h2c2o1s_init: x1z1 dimension error'
endif
allocate (x1z1_cf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x1z1_cf
endif
close (iun)
write (*,*) ' reading pcf-y1z1.dat'
open (iun, status='old', file=trim(chd)//'pcf-y1z1.dat')
read (iun,*) y1z1_pc
read (iun,*) nb
if (nb.ne.pes_y1z1_nb(y1z1_pc%dg)) then
 stop 'h2c2o1s_init: y1z1 dimension error'
endif
allocate (y1z1_cf(0:nb-1))
if (1.le.nb) then
 read (iun,*) y1z1_cf
endif
close (iun)
write (*,*) ' reading pcf-x2y1.dat'
open (iun, status='old', file=trim(chd)//'pcf-x2y1.dat')
read (iun,*) x2y1_pc
read (iun,*) nb
if (nb.ne.pes_x2y1_nb(x2y1_pc%dg)) then
 stop 'h2c2o1s_init: x2y1 dimension error'
endif
allocate (x2y1_cf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x2y1_cf
endif
close (iun)
write (*,*) ' reading pcf-x1y2.dat'
open (iun, status='old', file=trim(chd)//'pcf-x1y2.dat')
read (iun,*) x1y2_pc
read (iun,*) nb
if (nb.ne.pes_x1y2_nb(x1y2_pc%dg)) then
 stop 'h2c2o1s_init: x1y2 dimension error'
endif
allocate (x1y2_cf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x1y2_cf
endif
close (iun)
write (*,*) ' reading pcf-x2z1.dat'
open (iun, status='old', file=trim(chd)//'pcf-x2z1.dat')
read (iun,*) x2z1_pc
read (iun,*) nb
if (nb.ne.pes_x2z1_nb(x2z1_pc%dg)) then
 stop 'h2c2o1s_init: x2z1 dimension error'
endif
allocate (x2z1_cf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x2z1_cf
endif
close (iun)
write (*,*) ' reading pcf-x1y1z1.dat'
open (iun, status='old', file=trim(chd)//'pcf-x1y1z1.dat')
read (iun,*) x1y1z1_pc
read (iun,*) nb
if (nb.ne.pes_x1y1z1_nb(x1y1z1_pc%dg)) then
 stop 'h2c2o1s_init: x1y1z1 dimension error'
endif
allocate (x1y1z1_cf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x1y1z1_cf
endif
close (iun)
write (*,*) ' reading pcf-y2z1.dat'
open (iun, status='old', file=trim(chd)//'pcf-y2z1.dat')
read (iun,*) y2z1_pc
read (iun,*) nb
if (nb.ne.pes_y2z1_nb(y2z1_pc%dg)) then
 stop 'h2c2o1s_init: y2z1 dimension error'
endif
allocate (y2z1_cf(0:nb-1))
if (1.le.nb) then
 read (iun,*) y2z1_cf
endif
close (iun)
write (*,*) ' reading pcf-x2y2.dat'
open (iun, status='old', file=trim(chd)//'pcf-x2y2.dat')
read (iun,*) x2y2_pc
read (iun,*) nb
if (nb.ne.pes_x2y2_nb(x2y2_pc%dg)) then
 stop 'h2c2o1s_init: x2y2 dimension error'
endif
allocate (x2y2_cf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x2y2_cf
endif
close (iun)
write (*,*) ' reading pcf-x2y1z1.dat'
open (iun, status='old', file=trim(chd)//'pcf-x2y1z1.dat')
read (iun,*) x2y1z1_pc
read (iun,*) nb
if (nb.ne.pes_x2y1z1_nb(x2y1z1_pc%dg)) then
 stop 'h2c2o1s_init: x2y1z1 dimension error'
endif
allocate (x2y1z1_cf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x2y1z1_cf
endif
close (iun)
write (*,*) ' reading pcf-x1y2z1.dat'
open (iun, status='old', file=trim(chd)//'pcf-x1y2z1.dat')
read (iun,*) x1y2z1_pc
read (iun,*) nb
if (nb.ne.pes_x1y2z1_nb(x1y2z1_pc%dg)) then
 stop 'h2c2o1s_init: x1y2z1 dimension error'
endif
allocate (x1y2z1_cf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x1y2z1_cf
endif
close (iun)
write (*,*) ' reading pcf-x2y2z1.dat'
open (iun, status='old', file=trim(chd)//'pcf-x2y2z1.dat')
read (iun,*) x2y2z1_pc
read (iun,*) nb
if (nb.ne.pes_x2y2z1_nb(x2y2z1_pc%dg)) then
 stop 'h2c2o1s_init: x2y2z1 dimension error'
endif
allocate (x2y2z1_cf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x2y2z1_cf
endif
close (iun)
return
END SUBROUTINE h2c2o1s_init
SUBROUTINE h2c2o1s_vinit (dirname)
character (len=*), intent (in) :: dirname
!------------------------------------------------------------------------
integer :: iun, nb
logical :: b0
character (len=255) :: chd
call pes_getiun (iun)
b0 = dirname(len_trim(dirname):len_trim(dirname)).eq.'/'
if (b0) then
 chd = dirname
else
 chd = trim(dirname)//'/'
endif
write (*,*) 'Principal data directory: ', chd(1:len_trim(chd))
write (*,*) ' reading vpcf-x1.dat'
open (iun, status='old', file=trim(chd)//'vpcf-x1.dat')
read (iun,*) x1_vcf
close (iun)
write (*,*) ' reading vpcf-y1.dat'
open (iun, status='old', file=trim(chd)//'vpcf-y1.dat')
read (iun,*) y1_vcf
close (iun)
write (*,*) ' reading vpcf-z1.dat'
open (iun, status='old', file=trim(chd)//'vpcf-z1.dat')
read (iun,*) z1_vcf
close (iun)
write (*,*) ' reading vpcf-x2.dat'
open (iun, status='old', file=trim(chd)//'vpcf-x2.dat')
read (iun,*) x2_vpc
read (iun,*) nb
if (nb.ne.pes_x2_nvb(x2_vpc%dg)) then
 stop 'h2c2o1s_vinit: x2 dimension error'
endif
allocate (x2_vcf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x2_vcf
endif
close (iun)
write (*,*) ' reading vpcf-x1y1.dat'
open (iun, status='old', file=trim(chd)//'vpcf-x1y1.dat')
read (iun,*) x1y1_vpc
read (iun,*) nb
if (nb.ne.pes_x1y1_nvb(x1y1_vpc%dg)) then
 stop 'h2c2o1s_vinit: x1y1 dimension error'
endif
allocate (x1y1_vcf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x1y1_vcf
endif
close (iun)
write (*,*) ' reading vpcf-y2.dat'
open (iun, status='old', file=trim(chd)//'vpcf-y2.dat')
read (iun,*) y2_vpc
read (iun,*) nb
if (nb.ne.pes_y2_nvb(y2_vpc%dg)) then
 stop 'h2c2o1s_vinit: y2 dimension error'
endif
allocate (y2_vcf(0:nb-1))
if (1.le.nb) then
 read (iun,*) y2_vcf
endif
close (iun)
write (*,*) ' reading vpcf-x1z1.dat'
open (iun, status='old', file=trim(chd)//'vpcf-x1z1.dat')
read (iun,*) x1z1_vpc
read (iun,*) nb
if (nb.ne.pes_x1z1_nvb(x1z1_vpc%dg)) then
 stop 'h2c2o1s_vinit: x1z1 dimension error'
endif
allocate (x1z1_vcf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x1z1_vcf
endif
close (iun)
write (*,*) ' reading vpcf-y1z1.dat'
open (iun, status='old', file=trim(chd)//'vpcf-y1z1.dat')
read (iun,*) y1z1_vpc
read (iun,*) nb
if (nb.ne.pes_y1z1_nvb(y1z1_vpc%dg)) then
 stop 'h2c2o1s_vinit: y1z1 dimension error'
endif
allocate (y1z1_vcf(0:nb-1))
if (1.le.nb) then
 read (iun,*) y1z1_vcf
endif
close (iun)
write (*,*) ' reading vpcf-x2y1.dat'
open (iun, status='old', file=trim(chd)//'vpcf-x2y1.dat')
read (iun,*) x2y1_vpc
read (iun,*) nb
if (nb.ne.pes_x2y1_nvb(x2y1_vpc%dg)) then
 stop 'h2c2o1s_vinit: x2y1 dimension error'
endif
allocate (x2y1_vcf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x2y1_vcf
endif
close (iun)
write (*,*) ' reading vpcf-x1y2.dat'
open (iun, status='old', file=trim(chd)//'vpcf-x1y2.dat')
read (iun,*) x1y2_vpc
read (iun,*) nb
if (nb.ne.pes_x1y2_nvb(x1y2_vpc%dg)) then
 stop 'h2c2o1s_vinit: x1y2 dimension error'
endif
allocate (x1y2_vcf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x1y2_vcf
endif
close (iun)
write (*,*) ' reading vpcf-x2z1.dat'
open (iun, status='old', file=trim(chd)//'vpcf-x2z1.dat')
read (iun,*) x2z1_vpc
read (iun,*) nb
if (nb.ne.pes_x2z1_nvb(x2z1_vpc%dg)) then
 stop 'h2c2o1s_vinit: x2z1 dimension error'
endif
allocate (x2z1_vcf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x2z1_vcf
endif
close (iun)
write (*,*) ' reading vpcf-x1y1z1.dat'
open (iun, status='old', file=trim(chd)//'vpcf-x1y1z1.dat')
read (iun,*) x1y1z1_vpc
read (iun,*) nb
if (nb.ne.pes_x1y1z1_nvb(x1y1z1_vpc%dg)) then
 stop 'h2c2o1s_vinit: x1y1z1 dimension error'
endif
allocate (x1y1z1_vcf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x1y1z1_vcf
endif
close (iun)
write (*,*) ' reading vpcf-y2z1.dat'
open (iun, status='old', file=trim(chd)//'vpcf-y2z1.dat')
read (iun,*) y2z1_vpc
read (iun,*) nb
if (nb.ne.pes_y2z1_nvb(y2z1_vpc%dg)) then
 stop 'h2c2o1s_vinit: y2z1 dimension error'
endif
allocate (y2z1_vcf(0:nb-1))
if (1.le.nb) then
 read (iun,*) y2z1_vcf
endif
close (iun)
write (*,*) ' reading vpcf-x2y2.dat'
open (iun, status='old', file=trim(chd)//'vpcf-x2y2.dat')
read (iun,*) x2y2_vpc
read (iun,*) nb
if (nb.ne.pes_x2y2_nvb(x2y2_vpc%dg)) then
 stop 'h2c2o1s_vinit: x2y2 dimension error'
endif
allocate (x2y2_vcf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x2y2_vcf
endif
close (iun)
write (*,*) ' reading vpcf-x2y1z1.dat'
open (iun, status='old', file=trim(chd)//'vpcf-x2y1z1.dat')
read (iun,*) x2y1z1_vpc
read (iun,*) nb
if (nb.ne.pes_x2y1z1_nvb(x2y1z1_vpc%dg)) then
 stop 'h2c2o1s_vinit: x2y1z1 dimension error'
endif
allocate (x2y1z1_vcf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x2y1z1_vcf
endif
close (iun)
write (*,*) ' reading vpcf-x1y2z1.dat'
open (iun, status='old', file=trim(chd)//'vpcf-x1y2z1.dat')
read (iun,*) x1y2z1_vpc
read (iun,*) nb
if (nb.ne.pes_x1y2z1_nvb(x1y2z1_vpc%dg)) then
 stop 'h2c2o1s_vinit: x1y2z1 dimension error'
endif
allocate (x1y2z1_vcf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x1y2z1_vcf
endif
close (iun)
write (*,*) ' reading vpcf-x2y2z1.dat'
open (iun, status='old', file=trim(chd)//'vpcf-x2y2z1.dat')
read (iun,*) x2y2z1_vpc
read (iun,*) nb
if (nb.ne.pes_x2y2z1_nvb(x2y2z1_vpc%dg)) then
 stop 'h2c2o1s_vinit: x2y2z1 dimension error'
endif
allocate (x2y2z1_vcf(0:nb-1))
if (1.le.nb) then
 read (iun,*) x2y2z1_vcf
endif
close (iun)
return
END SUBROUTINE h2c2o1s_vinit
FUNCTION h2c2o1s_pot (xn) RESULT (f0)
! Potential for generic X2Y2Z1
real (kind=wp), intent (in) :: xn(0:,0:)
real (kind=wp) :: f0
!-----------------------------------------------------------------------
real (kind=wp) :: xn0(0:2,0:nk-1), r(0:nk-1,0:nk-1)
xn0(:,iord) = xn
call pes_dists (xn0, r)
f0 = x1_cf*nki(0)+y1_cf*nki(1)+z1_cf*nki(2)+ &
  cx_f2(nki,r,x2_pc,x2_cf)+ &
  cx_f11(nki,r,x1y1_pc,x1y1_cf)+ &
  cx_f02(nki,r,y2_pc,y2_cf)+ &
  cx_f101(nki,r,x1z1_pc,x1z1_cf)+ &
  cx_f011(nki,r,y1z1_pc,y1z1_cf)+ &
  cx_f21(nki,r,x2y1_pc,x2y1_cf)+ &
  cx_f12(nki,r,x1y2_pc,x1y2_cf)+ &
  cx_f201(nki,r,x2z1_pc,x2z1_cf)+ &
  cx_f111(nki,r,x1y1z1_pc,x1y1z1_cf)+ &
  cx_f021(nki,r,y2z1_pc,y2z1_cf)+ &
  cx_f22(nki,r,x2y2_pc,x2y2_cf)+ &
  cx_f211(nki,r,x2y1z1_pc,x2y1z1_cf)+ &
  cx_f121(nki,r,x1y2z1_pc,x1y2z1_cf)+ &
  cx_f221(nki,r,x2y2z1_pc,x2y2z1_cf)
return
END FUNCTION h2c2o1s_pot
FUNCTION h2c2o1s_vfun (xn) RESULT (f)
! Vector function for generic X2Y2Z1
real (kind=wp), intent (in) :: xn(0:,0:)
real (kind=wp) :: f(0:size(xn,2)-1)
!-----------------------------------------------------------------------
real (kind=wp) :: xn0(0:2,0:nk-1), r(0:nk-1,0:nk-1)
xn0(:,iord) = xn
call pes_dists (xn0, r)
f = cxv_f1(nki,x1_vcf)+ &
  cxv_f01(nki,y1_vcf)+ &
  cxv_f001(nki,z1_vcf)+ &
  cxv_f2(nki,r,x2_vpc,x2_vcf)+ &
  cxv_f11(nki,r,x1y1_vpc,x1y1_vcf)+ &
  cxv_f02(nki,r,y2_vpc,y2_vcf)+ &
  cxv_f101(nki,r,x1z1_vpc,x1z1_vcf)+ &
  cxv_f011(nki,r,y1z1_vpc,y1z1_vcf)+ &
  cxv_f21(nki,r,x2y1_vpc,x2y1_vcf)+ &
  cxv_f12(nki,r,x1y2_vpc,x1y2_vcf)+ &
  cxv_f201(nki,r,x2z1_vpc,x2z1_vcf)+ &
  cxv_f111(nki,r,x1y1z1_vpc,x1y1z1_vcf)+ &
  cxv_f021(nki,r,y2z1_vpc,y2z1_vcf)+ &
  cxv_f22(nki,r,x2y2_vpc,x2y2_vcf)+ &
  cxv_f211(nki,r,x2y1z1_vpc,x2y1z1_vcf)+ &
  cxv_f121(nki,r,x1y2z1_vpc,x1y2z1_vcf)+ &
  cxv_f221(nki,r,x2y2z1_vpc,x2y2z1_vcf)
return
END FUNCTION h2c2o1s_vfun
END MODULE pes_h2c2o1s
