include 'pes_h2c2o1s.f90'
include 'pes_h2c2o1t.f90'
PROGRAM test_h2c2o1_st
use pes_h2c2o1s
use pes_h2c2o1t
implicit none
integer, parameter :: wp=selected_real_kind(12,300)
real (kind=wp), parameter :: u_angstrom=1/0.529177249_wp
character (len=2), parameter :: &
  chnuc(0:4)=(/'H','H','C','C','O'/)
integer :: i, k, idum
real (kind=wp) :: f0, f1, f2, xn(0:2,0:4), tv0(0:2)
character (len=255) :: dname0, dname1, fname
character (len=2) :: chdum
call getarg (1, dname0)
call getarg (2, dname1)
call getarg (3, fname)
call h2c2o1s_init (dname0)
call h2c2o1t_init (dname1)
open (50, status='old', file=fname)
i = 0
do while (.true.)
 read (50,*,end=1) idum
 if (idum.ne.5) then
  stop 'test_h2c2o1_st: bad atom count nk'
 endif
 read (50,*) f0
 do k = 0, 4
  read (50,*) chdum, tv0(0:2)
  if (chdum.ne.chnuc(k)) then
   stop 'test_h2c2o1_st: bad element symbol'
  endif
  xn(:,k) = tv0(:)*u_angstrom
 enddo
 f1 = h2c2o1s_pot(xn)
 f2 = h2c2o1t_pot(xn)
 write (*,'(i6,2x,3(f16.6,2x))') &
   i, f0, f1, f2
 i = i+1
enddo
1 continue
stop
END PROGRAM test_h2c2o1_st
