
/**
 * BabelConfigPanel.java
 * 
 *
 * Created: Sat May  1 19:33:48 1999
 *
 * @author Nathan Stevens
 * @version 0.1
 */
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;

public class BabelConfigPanel extends JPanel implements  ActionListener
{
  private ServerConfigPanel Sp;
  private static File cfile = new File("Config/babel.cfg");
  private ChemMessage m = new ChemMessage(this);
  private String APP_BIN = "babel";
  private Vector  ServerList;
  private JTextField tf1;
  private JButton bt1, bt2;

  public BabelConfigPanel()
    {
      setLayout(new BorderLayout());
      ServerList = new Vector();
      TitledBorder border;

      // add the text field
      JPanel pan1 = new JPanel();
      pan1.setLayout(new FlowLayout(FlowLayout.LEFT));
      border = new TitledBorder("Babel Location");
      border.setTitlePosition(TitledBorder.TOP);
      border.setTitleJustification(TitledBorder.LEFT);
      pan1.setBorder(border);

      JLabel lb1 = new JLabel("Babel File : ");
      pan1.add(lb1);
     
      tf1 = new JTextField(20);
      pan1.add(tf1);
      
      bt1 = new JButton("Browse");
      bt1.addActionListener(this);
      pan1.add(bt1);
      
      add(pan1, "North");     
     
      // Add the Server panel to south position

      Sp = new ServerConfigPanel();
      border = new TitledBorder("Babel Server(s)");
      border.setTitlePosition(TitledBorder.TOP);
      border.setTitleJustification(TitledBorder.LEFT);
      Sp.setBorder(border);

      add(Sp, "Center");

      JPanel pan2 = new JPanel();
      pan2.setLayout(new FlowLayout());
     
      bt2 = new JButton("Save");
      bt2.addActionListener(this);
      pan2.add(bt2);
      
      add(pan2, "South");

      ReadCfg();
      upDate();          // Method to the display 
    }
  
  // Method to read the config file if it exist or creat it if 
  // the file, "Config/babel.cfg" doesn't exist.
  private void ReadCfg()
    {
      if(cfile.isFile())
	{
          TextInputFile f = new TextInputFile(cfile);
          APP_BIN = f.readString();
        
	  // now had the list of servers
          while(!f.eof())
	    {
              ServerList.addElement(f.readString());
	    }
          f.close();
	}
       else
	 {
           SaveCfg();
	 }
    }

  // Method to save the file
  private void SaveCfg()
    {
      Enumeration theServer = ServerList.elements();

      // write the values to the file
      TextOutputFile f = new TextOutputFile(cfile);
      f.println(APP_BIN);

      while(theServer.hasMoreElements())
	{
          f.println((String)theServer.nextElement());
	}
      f.close();
    }
 
  private void upDate()
    {
      tf1.setText(APP_BIN);
      Sp.setServer(ServerList);
    } 

  public void actionPerformed(ActionEvent e)
    {
      if(e.getSource() == bt1)
	{
          getBabel();
	}
      else if(e.getSource() == bt2)
	{
          SaveCfg();
	}
    }

  // Method to open file dialog and find
  private void getBabel()
    {
      String dir;
      String name;

      Frame tmpf = new Frame();
      FileDialog fd = new FileDialog(tmpf,"Babel File");
      fd.setBackground(getPanelColor());
      fd.show();
      
      dir = fd.getDirectory();
      name = fd.getFile();
      
      if(name !=null)
	{
          File f = new File(dir + name);

          if(f.isFile())
	    {
              APP_BIN = dir + name;
              tf1.setText(APP_BIN);
	    }
          else
	    {
              m.errPrint("The file " + name + " doesn't exist", "File Error");
	    }
	}       
    }

  private Color getPanelColor()
    {
      return getBackground();
    } 
}
  



