
/**
 * BabelPanel.java
 *
 *
 * Created: Thu Apr 22 13:53:20 1999
 *
 * @author Nathan Stevens
 * @version 0.1;
 */
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import com.sun.java.swing.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.event.*;

public class BabelPanel extends JPanel implements ActionListener,
                        ListSelectionListener
{
  private String Mode;            
  private JTextField tf1, tf2, tf3, tf4, tf5, tf6, tf7;
  private JList listi, listo;
  private JButton bt1, bt2, bt3;
  private ChemMessage m = new ChemMessage(this);
  private static File cfile = new File("Config/babel.cfg");
  private String intype;
  private String infile;
  private String keyw1;
  private String outtype;
  private String outfile;
  private String keyw2;
  private String rn;          
  private String adh;
  private String command = "babel";
  private String fdir;
  private Vector ServerList;
  private NetworkPanel np;
  private AbstractButton chk1, rb1, rb2;

  // default constructor. this set the mode to local
  public BabelPanel()
    {
      this("local");   // change back to local
    }
  
  public BabelPanel(String mode)
    {
      Mode = mode;
       
      // set the Layout
      setLayout(new BorderLayout());
          
      
      // set the border for main panel and inner panels
      SoftBevelBorder mainb = new SoftBevelBorder(SoftBevelBorder.RAISED);
      setBorder(mainb);

      // Line and titled borders
      TitledBorder border;

      // Check to see what mode we are in. If local do nothing else if
      // networked then put the server info panel in center position
      if(Mode.equals("network"))
	{
          np  = new NetworkPanel();
          add(np,"Center");
	}
      else
	{
           // put a nice picture in center grear
	}
      // add title in north potion of panel
      Font font = new Font("Times-Roman", Font.ITALIC, 14);
      JLabel name = new JLabel("Babel v1.6", JLabel.CENTER);
      name.setFont(font);
      add(name, "North");
    
      /** add the input file selector panel which consist of a 
       * text field and Jlist
       **/
      JPanel pan1  = new JPanel();
      pan1.setLayout(new BorderLayout());
      border = new TitledBorder("Input File Type");
      border.setTitlePosition(TitledBorder.TOP);
      border.setTitleJustification(TitledBorder.LEFT);
      pan1.setBorder(border);

      // add the text field with title to pan1a with flowlayout
      JPanel pan1a = new JPanel();
      pan1a.setLayout(new FlowLayout(FlowLayout.LEFT));

      JLabel lb1 = new JLabel("Choice : ");
      pan1a.add(lb1);

      tf1 = new JTextField(6);
      tf1.addActionListener(this);
      pan1a.add(tf1);

      pan1.add(pan1a, "North");

      // add the list to center of of pan1 
      listi = new JList();
      listi.setListData(inputFiles());
      listi.addListSelectionListener(this);      

      pan1.add(new JScrollPane(listi), "Center");
     
      
      // add pan1 to main panel
      add(pan1, "West");

      /** add the output file panel basically the same as out file format
       *
       */
      JPanel pan2  = new JPanel();
      pan2.setLayout(new BorderLayout());

      border = new TitledBorder("Output File Type");
      border.setTitlePosition(TitledBorder.TOP);
      border.setTitleJustification(TitledBorder.LEFT);
      pan2.setBorder(border);

      // add the text field with title to pan1a with flowlayout
      JPanel pan2a = new JPanel();
      pan2a.setLayout(new FlowLayout(FlowLayout.LEFT));

      JLabel lb2 = new JLabel("Choice : ");
      pan2a.add(lb2);

      tf2 = new JTextField(6);
      tf2.addActionListener(this);

      pan2a.add(tf2);
      pan2.add(pan2a, "North");

      // add the list to center of of pan1 
      listo = new JList();
      listo.setListData(outputFiles());
      listo.addListSelectionListener(this);

      pan2.add(new JScrollPane(listo), "Center");
     
      
      // add pan2 to main panel
      add(pan2, "East");
     
      /** The file input  panel. this is were the name of the file is entered
       * it will consist of Jlabels and JText and Jbuttons
       **/
      JPanel pan3  = new JPanel();
      pan3.setLayout(new GridLayout(2,1));
      
      // add the panel that holds JTextFieled and label with Browse button
      JPanel pan3A = new JPanel();
      pan3A.setLayout(new GridLayout(2,1));
     
      border = new TitledBorder("Input/Output File name");
      border.setTitlePosition(TitledBorder.TOP);
      border.setTitleJustification(TitledBorder.LEFT);
      pan3A.setBorder(border);
       
      JPanel pan3Aa = new JPanel();
      pan3Aa.setLayout(new FlowLayout(FlowLayout.LEFT));
      
      JLabel lb3 = new JLabel("Input Name    : ");
      pan3Aa.add(lb3);
      
      tf3 = new JTextField(20);
      tf3.addActionListener(this);
      pan3Aa.add(tf3);
      
      bt1 = new JButton("Browse");
      bt1.addActionListener(this);
      pan3Aa.add(bt1);
   
      pan3A.add(pan3Aa);

      // add the file output name textfield tp pan3A

      JPanel pan3Ab = new JPanel();
      pan3Ab.setLayout(new FlowLayout(FlowLayout.LEFT));
   
      JLabel lb4 = new JLabel("Output Name : ");
      pan3Ab.add(lb4);
      
      tf4 = new JTextField(20);
      tf4.addActionListener(this);
      pan3Ab.add(tf4);
      
      pan3A.add(pan3Ab);

      // add pan3A to pan3
      pan3.add(pan3A);
      
      /*add the panel that holds the keywords textfields*/     
      
      JPanel pan3B = new JPanel();
      pan3B.setLayout(new GridLayout(2,1));
     
      border = new TitledBorder("KeyWords");
      border.setTitlePosition(TitledBorder.TOP);
      border.setTitleJustification(TitledBorder.LEFT);
      pan3B.setBorder(border);

      //input keywords
      JPanel pan3Ba = new JPanel();
      pan3Ba.setLayout(new FlowLayout(FlowLayout.LEFT));
 
      JLabel lb5 = new JLabel("Input Keywords    : ");
      pan3Ba.add(lb5); 
    
      tf5 = new JTextField(35);
      tf5.addActionListener(this);
      pan3Ba.add(tf5);
           
      pan3B.add(pan3Ba);
      
      // output keywords text field
      JPanel pan3Bb = new JPanel();
      pan3Bb.setLayout(new FlowLayout(FlowLayout.LEFT));
      
      JLabel lb6 = new JLabel("Output Keywords : ");
      pan3Bb.add(lb6);  
    
      tf6 = new JTextField(35);
      tf6.addActionListener(this);
      pan3Bb.add(tf6);  
       
      pan3B.add(pan3Bb);
       
      pan3.add(pan3B);
      
      JPanel pan4 = new JPanel();
      pan4.setLayout(new BorderLayout());
      
      pan4.add(pan3, "North");  

      /* add the Optional flags panel pan3C. this is were other stuff goes*/
      JPanel pan4A = new JPanel();
      pan4A.setLayout(new FlowLayout(FlowLayout.LEFT));
      
      border = new TitledBorder("Optional Flags");
      border.setTitlePosition(TitledBorder.TOP);
      border.setTitleJustification(TitledBorder.LEFT);
      pan4A.setBorder(border);
      
      // add the renumber and check box along with field to enter number
      chk1 = new JCheckBox("Re-number :");
      chk1.addActionListener(this);
      pan4A.add(chk1);
      
      tf7 = new JTextField(5);
      tf7.addActionListener(this);
      pan4A.add(tf7);

      // add spaces
      JLabel space  = new JLabel("                    ");
      pan4A.add(space); 

      // add the "hydrogens" add "remove" radio buttons
      
      rb1 = new JCheckBox("Add H");
      rb1.addActionListener(this);
      pan4A.add(rb1);
     
      rb2 = new JCheckBox("Del H");
      rb2.addActionListener(this);
      pan4A.add(rb2);      

      pan4.add(pan4A, "Center");       
      
      /* add the OK an Cancel button in the south of pan3*/
      JPanel pan4B = new JPanel();
      pan4B.setLayout(new FlowLayout(FlowLayout.CENTER, 40 , 5));
 
      bt2 = new JButton("  OK  ");
      bt2.addActionListener(this);
      pan4B.add(bt2);
    
      bt3 = new JButton("Clear ");
      bt3.addActionListener(this);
      pan4B.add(bt3);
      
      pan4.add(pan4B,"South");
        
      add(pan4, "South");

      // Read in the config file
      ReadCfg();
      upDate();
    }

  // Method to read the configuration file babel.cfg in dir Config
  private void ReadCfg()
    {
      if(cfile.isFile())
	{
          TextInputFile f = new TextInputFile(cfile);
          command = f.readString();
 
          // If mode is equal to network then read servers and set the servers
          if(Mode.equals("network"))
	    {
              ServerList = new Vector();
              while(!f.eof())
		{
                  ServerList.addElement(f.readString());
		}
	      // add code to set the list of servers in the networkpanel
              
	    }
          f.close(); 
	} 
      
      else
	{
          String[] emsg = {"The Config file \"babel.cfg\" was found.",
                           "Please Run the Config Utility.",
			   "Using Defaults."}; 
          m.errPrint(emsg, "File Error");
	}    
    }
  // Method to load netpanel in north potion of panel
  private void upDate()
    {
      if(Mode.equals("network"))
	{
          np.setBoxData(ServerList);
	}
    }
   
  // the types of input files
  private Vector inputFiles()
    {
      Vector idata = new Vector();
      idata.addElement("[1]  Alchemy");
      idata.addElement("[2]  AMBER PREP");
      idata.addElement("[3]  Ball and Stick");
      idata.addElement("[4]  MSI BGF");
      idata.addElement("[5]  Biosym .CAR");
      idata.addElement("[6]  Boogie");
      idata.addElement("[7]  Cacao Cartesian");
      idata.addElement("[8]  Cambridge CADPAC");
      idata.addElement("[9]  CHARMm");
      idata.addElement("[10]  Chem3D Cartesian 1");
      idata.addElement("[11] Chem3D Cartesian 2");
      idata.addElement("[12] CSD CSSR");
      idata.addElement("[13] CSD FDAT");
      idata.addElement("[14] CSD GSTAT");
      idata.addElement("[15] Dock Database");
      idata.addElement("[16] Dock PDB");
      idata.addElement("[17] Feature");
      idata.addElement("[18] Free Form Fractional");
      idata.addElement("[19] GAMESS Output");
      idata.addElement("[20] Gaussain Z-Matrix");
      idata.addElement("[21] Gaussian 92 Output");
      idata.addElement("[22] Gaussian 94 Output");
      idata.addElement("[23] GROMOS96 (A)");
      idata.addElement("[24] GROMOS96 (nm)");
      idata.addElement("[25] Hyperchem HIN");
      idata.addElement("[26] MDL Isis SDF");
      idata.addElement("[27] M3D");
      idata.addElement("[28] Mac Molecule");
      idata.addElement("[29] Macromodel");
      idata.addElement("[30] Micro World");
      idata.addElement("[31] MM2 Input");
      idata.addElement("[32] MM2 Output");
      idata.addElement("[33] MM3");
      idata.addElement("[34] MMADS");
      idata.addElement("[35] MDL MOLfile");
      idata.addElement("[36] MOLIN");
      idata.addElement("[37] Mopac Cartesian");
      idata.addElement("[38] Mopac Internal");
      idata.addElement("[39] Mopac Output");
      idata.addElement("[40] PC Model");
      idata.addElement("[41] PDB");
      idata.addElement("[42] PS-GVB Input");
      idata.addElement("[43] PS-GVB Output"); 
      idata.addElement("[44] Quanta MSF");
      idata.addElement("[45] Schakal");
      idata.addElement("[46] ShelX");
      idata.addElement("[47] SMILES");
      idata.addElement("[48] Spartan");
      idata.addElement("[49] Spartan Semi-Empirical");
      idata.addElement("[50] Spartan Mol. Mechanics");
      idata.addElement("[51] Sybyl Mol");
      idata.addElement("[52] Sybyl Mol2");
      idata.addElement("[53] Conjure");
      idata.addElement("[54] UniChem XYZ");
      idata.addElement("[55] XYZ");
      idata.addElement("[56] XED");
      return idata;
    } 
  
  private Vector outputFiles()
    {
      Vector odata  = new Vector();
      odata.addElement("[1]  DIAGNOTICS");
      odata.addElement("[2]  Alchemy");
      odata.addElement("[3]  Ball and Stick");
      odata.addElement("[4]  BGF");
      odata.addElement("[5]  Batchmin Command");
      odata.addElement("[6]  Dock 3.5 box");
      odata.addElement("[7]  Cacoa Cartesian");
      odata.addElement("[8]  Cacoa Internal");
      odata.addElement("[9]  CAChe MolStruct");
      odata.addElement("[10] Chem3D Cartesian 1");
      odata.addElement("[11] Chem3D Cartesian 2");
      odata.addElement("[12] ChemDraw Conn. Table");
      odata.addElement("[13] Dock Database");
      odata.addElement("[14] Wizard");
      odata.addElement("[15] Conjure Template");
      odata.addElement("[16] CSD CSSR");
      odata.addElement("[17] Dock PDB");
      odata.addElement("[18] Feature");
      odata.addElement("[19] Fenske-Hall ZMatrix");
      odata.addElement("[20] Gamess Input");
      odata.addElement("[21] Gaussian Cartesian");
      odata.addElement("[22] Gaussian Z-matrix");
      odata.addElement("[23] Gaussian Z-matrix tmplt");
      odata.addElement("[24] GROMOS96 (A)");
      odata.addElement("[25] GROMOS96 (nm)");
      odata.addElement("[26] Hyperchem HIN");
      odata.addElement("[27] Icon 8");
      odata.addElement("[28] IDATM");
      odata.addElement("[29] MDL Isis SDF");
      odata.addElement("[30] M3D");
      odata.addElement("[31] Mac Molecule");
      odata.addElement("[32] Macromodel");
      odata.addElement("[33] Micro World");
      odata.addElement("[34] MM2 Input");
      odata.addElement("[35] MM2 Output");
      odata.addElement("[36] MM3");
      odata.addElement("[37] MMADS");
      odata.addElement("[38] MDL Molfile");
      odata.addElement("[39] MolInventor");
      odata.addElement("[40] Mopac Cartesian");
      odata.addElement("[41] Mopac Internal");
      odata.addElement("[42] MSI Quanta CSR");
      odata.addElement("[43] PC Model");
      odata.addElement("[44] PDB");
      odata.addElement("[45] PS-GVB Z-Matrix");
      odata.addElement("[46] PS-GVB Cartesian");
      odata.addElement("[47] Report");
      odata.addElement("[48] SMILES");
      odata.addElement("[49] Spartan");
      odata.addElement("[50] Sybyl Mol");
      odata.addElement("[51] Sybyl Mol2");
      odata.addElement("[52] MDL Maccs");
      odata.addElement("[53] Torsion List");
      odata.addElement("[54] Tinker XYZ");
      odata.addElement("[55] UniChem XYZ");
      odata.addElement("[56] XYZ");
      odata.addElement("[57] XED");
      
      return odata;
    }
 
  // handel events
  public void actionPerformed(ActionEvent e)
    {
      if(e.getSource() == bt1)
	{
          // call method that opens browse method
          Button1();
	}
      else if(e.getSource() == bt2)
	{
          // call the method that handels th Ok button
          Button2();
	}
      else if(e.getSource() == bt3)
	{
	  //call method that handels cancel button
          Button3();
	}
      else if(e.getSource() == chk1) 
        {
          rNum(); 
        }
      else if(e.getSource() == rb1)
	{
           addHydrogen();
	}
      else if(e.getSource() == rb2)
	{
           delHydrogen();
	} 
      // add code
    }
  
  public void valueChanged(ListSelectionEvent e)
    {
      if(e.getSource() == listi)
	{
          // call the method that hadels list input model
          int choice1 =  e.getFirstIndex() + 1;
          listInput(choice1);
	}
      else if(e.getSource() == listo)
	{
          // call method that handels listi stuff
          int choice2 = e.getFirstIndex() + 1;
          listOutput(choice2);
	}
    }

  /**
   * All methods below this point handle events generated
   * by components of in the BabelPanel. mess with it at your own risk.
   **/

  // method to handel button 1
  private void Button1()
    {
      // For this we have to open a FileDialog and get the String 
      // representation of the file and place it in to the file input
      // text field(tf3)
      Frame tmpf  = new Frame("");
      String ifname;      

      FileDialog fd  = new FileDialog(tmpf, "Input File name");
      fd.setBackground(getPanelColor());
      fd.show();
 
      ifname = fd.getFile();
      fdir = fd.getDirectory();
      tf3.setText(ifname);       
    }
  
  // method to handel button 2
  private void Button2()
    {
      //this method will get all the text data in textField and pass in onto
      //the App Interface for the application, in this case babel, along with
      //the current mode(local/network)
      
      intype  = tf1.getText();
      infile  = tf3.getText();
      keyw1   =  tf5.getText();
      outtype = tf2.getText();
      outfile = tf4.getText();
      keyw2   = tf6.getText();      
      
      if(intype.length() != 0 && infile.length() != 0 && outtype.length() != 0  && outfile.length() != 0)
	      {
                ChemAppThread app = new BabelApp(this);
                app.start();
	      }
            else
	      { 
                String[] emsg = {"An Error Occured while reading values " + 
                                 "from program. ",
		                 "Please check the  values that you entered.",
                         "and make sure that none of the required values",
                         "are missing."};
  
                m.errPrint(emsg, "Input Error");             
	      }     
    }
  
  // Method to handel button 3
  private void Button3()
    {
      // Just clear the TextFields
      tf1.setText(null);
      tf2.setText(null);
      tf3.setText(null);
      tf4.setText(null);
      tf5.setText(null); 
      tf6.setText(null);
      tf7.setText(null);

      // now reset the buttons and String components 
      if(chk1.isSelected())
	{
          chk1.setSelected(false);
          rn = null;
	}

      if(rb1.isSelected())
	{
          rb1.setSelected(false);  
          adh = null;
	}

      if(rb2.isSelected())
	{
          rb2.setSelected(false);
          adh = null;
	}
   
    } 
  
  // Method for renumber button
  private void rNum()
    {
      // set the rn String to -renum + int
     if(chk1.isSelected())
       {
         String value = tf7.getText();
         rn  = "-renum " + value;
         //System.out.println(rn);
       } 
     else
       {
         rn = null;
       }   
    }

  // Method for radio button number one
  private void addHydrogen()
    {
      if(rb1.isSelected())
	{
          // set rb2 selected false if it is selected
          if(rb2.isSelected())
	    {
              rb2.setSelected(false); 
	    }
          adh = "-h ";
	} 
      else
	{
          adh = null;
	}
    }
  
  // Method for radio button number two
  private void delHydrogen()
    {
      if(rb2.isSelected())
	{
          // set rb2 selected false if it is selected
          if(rb1.isSelected())
	    {
              rb1.setSelected(false); 
	    }
          adh = "-d ";
	} 
      else
	{
          adh = null;
	}
    }

  // Method to handel input list event
  private void listInput(int index)
    {
      // get the index of the point and put the number in the textField
      String number = String.valueOf(index);
      tf1.setText(number);
    }
 
  private void listOutput(int index)
    {
      // code
      String number = String.valueOf(index);
      tf2.setText(number);
    }

  // method to get the color of JPanel and return it
  private Color getPanelColor()
    {
      return getBackground();
    }
  
  /**
   * This methods are to provide access to the private variable of the this
   * Class. This was done so that I can eventually turn this app into a 
   * Java Bean.
   **/
  public String getMode()
    {
      return Mode;
    }
  public String getIntype()
    {
      return intype;
    }
  public String getInfile()
    {
      if(fdir != null)
	{
          return fdir + infile;
	}
      else
	{
          return infile;
	}
    }
  public String getKeyw1()
    {
      return keyw1;
    }
  public String getOuttype()
    {
      return outtype;
    }
  public String getOutfile()
    {
      return outfile;
    }
  public String getKeyw2()
    {
     return keyw2;
    }
  public String getRn()
    {
      return rn;
    }
  public String getAdh()
    {
      return adh;
    }
  public String getCommand()
    {
      return command;
    }
  public String getServer()
    {
      String selServer = np.getServer();

      return selServer;
    }
  public boolean isRetrieve()
    {
      return np.isRetrieve();
    }  
}















