
/**
 * ChemToolFrame.java
 * This is used as the wrapper for tool Panels
 *
 * Created: Thu Apr 22 14:13:31 1999
 *
 * @author Nathan Stevens
 * @version 0.1
 */
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;

public class ChemToolFrame extends JFrame 
{  

  public ChemToolFrame(String title, BabelPanel bp)
    {
      super(title);             // call the base contructor
      addAppPanel(bp);
    }
  
  public ChemToolFrame(String title, MopacPanel mp)
    {
      super(title);
      addAppPanel(mp);
    }      

  public ChemToolFrame(String title, DataFileEditorPanel dfe)
    {
     super(title);
     addAppPanel(dfe);
    }
  
  public ChemToolFrame(String title, ConfigPanel cfp)
    {
      super(title);
      addAppPanel(cfp);
    }
 
  private void addAppPanel(JPanel panel)
    {  
      // set the layout manager
      getContentPane().setLayout(new BorderLayout());
     
      // add the panel to frame
      getContentPane().add(panel,"Center");
      
      // add the window listener
      addWindowListener(new wCloser());

      //Pack and display
      pack();
      setVisible(true);
    }
}

class wCloser extends WindowAdapter
{
  public void wCloser(WindowEvent e)
    {
      Window win = e.getWindow();
      win.setVisible(false);
      win.dispose();
    }
}
      

