
/**
 * ChemConsole.java
 *
 *
 * Created: Thu Apr 22 11:37:10 1999
 *
 * @author Nathan Stevens
 * @version 0.1
 */

import java.awt.*;
import java.awt.event.*;
import java.io.*;

public class ChemConsole 
{
  static ChemConsoleFrame window;
  static String dirname = "Config";
  static String filename = "main.cfg";  
  
  public static void main(String[] args)
    {
      // this controls how the frame looks
      window = new ChemConsoleFrame("Chemistry Console");   // set name
      window.getContentPane().setLayout(new BorderLayout());       

      // Set the default tool and display it in main window
      setTool();

      window.addWindowListener(new WindowCloser());
      window.setVisible(true);
      
    }

 public static void setTool()
    {
      // read the config file "Config/main.cfg"
      File cdir = new File(dirname);
      File cf = new File(cdir, filename);
      
      if(cf.isFile())
	{ 
          TextInputFile Infile = new TextInputFile(cf);

          String DEFAULT_TOOL = Infile.readString();
          String DEFAULT_MODE = Infile.readString();
                   
         // add the babel panel to window
         if(DEFAULT_TOOL.equals("babel"))
	   {
             BabelPanel pan  = new BabelPanel(DEFAULT_MODE); 
             window.getContentPane().add(pan, "Center");
             window.pack();
	   }
         else if(DEFAULT_TOOL.equals("mopac"))
	   {
             MopacPanel pan  = new MopacPanel(DEFAULT_MODE); 
             window.getContentPane().add(pan, "Center");
             window.pack();
	   }
         else if(DEFAULT_TOOL.equals("gaussian"))
	   {
          //GaussPanel pan  = new GaussPanel(DEFAULT_MODE); 
          //window.getContentPane().add(pan, "Center");
          //window.pack(); 
	   }         
         else                         //Default operation
	  { 
             BabelPanel pan  = new BabelPanel(); 
             window.getContentPane().add(pan, "Center");
             window.pack();          
	  }
	}
      else
	{
          System.out.println("Can't find main config file " + 
                             "\"main.cfg\" in directory \"Config\" "   
                              + "Exiting!");
          System.exit(1);
	}                  	       
    }
}

class WindowCloser extends WindowAdapter
{
  public void windowClosing(WindowEvent e)
    {
      Window win  = e.getWindow();
      win.setVisible(false);
      win.dispose();
      System.exit(0);
    }
} 
