
/**
 * ChemMessage.java
 * This class is used to display messages from errors to status
 *
 * Created: Fri Apr 23 10:27:49 1999
 *
 * @author Nathan Stevens
 * @version
 */
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.border.*;

public class ChemMessage implements ActionListener 
{
  private JPanel parent;
  private JFrame frame;  
  private JTextArea nterm;
  private boolean visible = false;

  // this constructor is used when newTerm method 
  public ChemMessage()
    {
      this(new JPanel());
    }

  public ChemMessage(JPanel p)
    {
      parent = p;
    }

  // method to print error in dialog window
  public void errPrint(String m, String title)
    {
      String[] msg = {m};
      errPrint(msg,title);
    }
 
  public void errPrint(String[] msg1, String title1)
    {
      JOptionPane.showMessageDialog(parent, msg1, title1, 
                                    JOptionPane.ERROR_MESSAGE);
    }

  // Method to print simple message
  public void msgPrint(String m, String title)
    {
      String[] msg = {m};
      msgPrint(msg, title);
    }
  public void msgPrint(String[] msg2, String title2)
    {
      JOptionPane.showMessageDialog(parent, msg2, title2, 
                                    JOptionPane.PLAIN_MESSAGE);
    }  

  // Method to display network status this is simple a text error with
  // at dismiss button at the right button.
  // might want to put this in 

  // note this method can only be called  after the newTerm method is called 
  public void netPrint(String s)
    {
      if(visible == true)
	{
           nterm.append(s);
	}
    }
  
  // Construct the terminal window for stuff like statistics
  public void newTerm(String title)
    {
      //contruct the textArea
      nterm = new JTextArea(15, 60);
      nterm.setLineWrap(true);
      nterm.setWrapStyleWord(true);

      // add the textarea to scroll pane
      JScrollPane areaScrollPane = new JScrollPane(nterm);
      areaScrollPane.setVerticalScrollBarPolicy(
                        JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);

      // add border to scroll pane
      Border border;
      border = new BevelBorder(BevelBorder.LOWERED);
      areaScrollPane.setBorder(border);
 
      // Now constuct the panel to hold button and text area
      JPanel panel = new JPanel();
      panel.setLayout(new BorderLayout());

      // add the scroll pane to panel then add panel to frame
      panel.add(areaScrollPane, "Center");

      // add a button to panel at south position
      JPanel bp = new JPanel();
      bp.setLayout(new FlowLayout(FlowLayout.RIGHT, 5, 5));
     
      JButton button = new JButton("Dismiss");
      button.addActionListener(this);
      button.setActionCommand("dismiss");
      bp.add(button);
      
      panel.add(bp, "South");
     
      // contruct the frame and set it visisble
      frame = new JFrame(title);
      frame.addWindowListener(new wCloser());
      frame.getContentPane().add(panel, "Center");
      frame.pack();
      frame.setVisible(true);
      
      // set the visible boolean to true so that we can call the netPrint
      // method
      visible = true;

    }
  
  public void actionPerformed(ActionEvent e)
    {
      String cmd = e.getActionCommand();
      if(cmd.equals("dismiss"))
	 {
          frame.setVisible(false);
          frame.dispose();
          visible = false;
	 } 
    }
}










