
/**
 * NetworkPanel.java this panel is called when the Tool are set to network
 * Mode.
 *
 * Created: Wed May  5 10:06:26 1999
 *
 * @author Nathan Stevens
 * @version 0.1
 */
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;

public class NetworkPanel extends JPanel implements ActionListener,
                                                    ItemListener
{
  private JComboBox sBox;
  private AbstractButton ab1;
  private String ServerChoice;
  private boolean Retrieve = false;
  private TitledBorder border;

  public NetworkPanel()
    {
      setLayout(new BorderLayout());
      
      // set the border
      border = new TitledBorder("Server Choice");
      border.setTitlePosition(TitledBorder.TOP);
      border.setTitleJustification(TitledBorder.LEFT);
      setBorder(border);
      
      // Add the JcheckBox
      JPanel pan1 = new JPanel();
      pan1.setLayout(new FlowLayout(FlowLayout.LEFT));

      sBox  = new JComboBox();
      sBox.addItemListener(this);
      pan1.add(sBox);
      add(pan1, "North");
      
      //add the JCheckBox button
      JPanel pan2 = new JPanel();
      pan2.setLayout(new FlowLayout(FlowLayout.LEFT));

      ab1 = new JCheckBox("Get Result(s)"); 
      ab1.addActionListener(this);
      pan2.add(ab1);
      
      add(pan2, "Center");
    }
   
  // Method to set JCheckbox data
  public void setBoxData(Vector v)
    {
      Enumeration theData = v.elements();
     
      while(theData.hasMoreElements())
	{
          sBox.addItem((String)theData.nextElement());
	}
    }
  
  public void setBoxData(String[] s)
    {
      for(int i = 0; i < s.length; i++)
	{
          sBox.addItem(s[i]);
	}
    }
  
  // Method to return the selected server
  public String getServer()
    {
      return ServerChoice;
    }
   
  // Method to return the boolean gr, which determines weather the get the 
  // results from the server,after the job has completed.
  public boolean isRetrieve()
    {
      return Retrieve;
    }
 
  //Handel the events
  public void actionPerformed(ActionEvent e)
    {
      if(e.getSource() == ab1 && ab1.isSelected())
	{
          //code
          Retrieve = true;
	}
                                         
    }
  public void itemStateChanged(ItemEvent e)
    {
      Object value;

      if(e.getSource() == sBox)
	{
          value  = sBox.getSelectedItem();
          ServerChoice = value.toString();
	}
    }          
}


