
/**
 * ConfigPanel.java 
 * This is the main Config panel for the Chemconsole program. all the other
 * Config panel is loaded into this one. 
 * Created: Sat May  1 19:05:48 1999
 *
 * @author Nathan Stevens
 * @version 0.2 
 */
import java.awt.*;
import java.io.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.text.*;
//import javax.swing.*;
//import javax.swing.border.*;
//import javax.swing.text.*;

public class ConfigPanel extends JPanel implements ActionListener
{
  private String DEFAULT_APP = "babel";
  private String DEFAULT_MODE = "local";
  private static File CONFIG_FILE = new File("Config/main.cfg"); 
  private TitledBorder border;
  private AbstractButton rd1, rd2, rd3, rd1b, rd2b;
  private JButton bt1;
  private JTextField tf1; 
  private TextInputFile Infile;
  private TextOutputFile Outfile; 

  //main constructor
  public ConfigPanel()
    {  
      //set the layout
      setLayout(new GridLayout(1, 1));

      //Read in the Config file
      ReadCfg();

      //Create the main tabs
      JTabbedPane tPane = new JTabbedPane();
            
      //add the main config panel to pane
    
      JPanel mainp = new JPanel();
      mainp.setLayout(new GridLayout(3,1));

      JPanel mainp1 = new JPanel();
      mainp1.setLayout(new FlowLayout(FlowLayout.LEFT, 30, 5));

      border = new TitledBorder("Default Tool");
      border.setTitlePosition(TitledBorder.TOP);
      border.setTitleJustification(TitledBorder.LEFT);
      mainp1.setBorder(border);

      // add radio buttons
      ButtonGroup group = new ButtonGroup();
     
      rd1 = new JRadioButton("Babel");
      rd1.addActionListener(this);
      group.add(rd1);
      mainp1.add(rd1);
     
      rd2 = new JRadioButton("Mopac");
      rd2.addActionListener(this);
      group.add(rd2);
      mainp1.add(rd2);  

      rd3 = new JRadioButton("Gaussian");
      rd3.addActionListener(this);
      group.add(rd3);
      mainp1.add(rd3);  
  
      mainp.add(mainp1);
    
      //add the  local or network mode selector panel
      JPanel mainp2 = new JPanel();
      mainp2.setLayout(new FlowLayout(FlowLayout.LEFT, 30, 5));

      border = new TitledBorder("Default Tool Mode");
      border.setTitlePosition(TitledBorder.TOP);
      border.setTitleJustification(TitledBorder.LEFT);
      mainp2.setBorder(border);

      // add radio buttons
      ButtonGroup group2 = new ButtonGroup();
     
      rd1b = new JRadioButton("Local");
      rd1b.addActionListener(this);
      group2.add(rd1b);
      mainp2.add(rd1b);
     
      rd2b = new JRadioButton("Network");
      rd2b.addActionListener(this);
      group2.add(rd2b);
      mainp2.add(rd2b); 
 
      mainp.add(mainp2);
     
      // add the text textfield to select the home dir
      JPanel mainp3 = new JPanel();
      mainp3.setLayout(new FlowLayout(FlowLayout.CENTER)); 
      
      bt1 = new JButton("   Save   ");
      bt1.addActionListener(this);
      mainp3.add(bt1);
 
      mainp.add(mainp3); 
                                
      tPane.addTab("Main", mainp);
      
      upDate();  

      /**
       * Add the babel config panel and rest of panels
       **/

      BabelConfigPanel babelp = new BabelConfigPanel();
      tPane.addTab("Babel", babelp);
     
      //add the mopac config Panel
      MopacConfigPanel mopacp = new MopacConfigPanel();
      tPane.addTab("Mopac", mopacp);
   
      //add the gaussian config panel
      GaussConfigPanel gaussp = new GaussConfigPanel();
      tPane.addTab("Gaussian", gaussp);
     
      tPane.setSelectedIndex(0);

      add(tPane);
             
    }
     
  private void ReadCfg()
    {
      if(CONFIG_FILE.isFile())
	{
          // this reads in the main config file "Config/main.cfg" if it exist
          Infile = new TextInputFile(CONFIG_FILE);
          
          // set the default modes and
          DEFAULT_APP = Infile.readString();
          DEFAULT_MODE = Infile.readString();
	}	
    }

  private void upDate()
    {
      // now set the buttons appropriatly
      if(DEFAULT_APP.equals("babel"))
	 {
           rd1.setSelected(true);
	 } 
      else if(DEFAULT_APP.equals("mopac"))
	{
           rd2.setSelected(true);
	}
      else if(DEFAULT_APP.equals("gaussian"))
	{	            
           rd3.setSelected(true);
	}

      if(DEFAULT_MODE.equals("local"))
	 {
           rd1b.setSelected(true);
	 }
      else if(DEFAULT_MODE.equals("network"))
	{
           rd2b.setSelected(true);
	}	          
    }    
  
  //method to save config file
  private void SaveCfg()
    {
      Outfile = new TextOutputFile(CONFIG_FILE);
     
      Outfile.println(DEFAULT_APP);
      Outfile.println(DEFAULT_MODE);    
    }
  public void actionPerformed(ActionEvent e)
    {
      if(e.getSource() == rd1 && rd1.isSelected() == true)
	{
          DEFAULT_APP = "babel";
	}
      else if(e.getSource() == rd2 && rd2.isSelected() == true)
	{
          DEFAULT_APP = "mopac";
	}
      else if(e.getSource() == rd3 && rd3.isSelected() == true)
	{
        DEFAULT_APP = "gaussian";
	}
      else if(e.getSource() == rd1b && rd1b.isSelected() == true)
	{
          DEFAULT_MODE = "local";
	}
      else if(e.getSource() == rd2b && rd2b.isSelected() == true)
	{
          DEFAULT_MODE = "network";
	}
      else if(e.getSource() == bt1)
	{
          SaveCfg();
	}   
    }

  // Method to handel events goes here
}     



