
/**
 * Class Dedit is a class that allow the user of the program Phem so that 
 * They can edit the input files using the build in editor
 *@author Nathan Stevens
 *@version 0.2
 */

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import com.sun.java.swing.*;
import com.sun.java.swing.text.*; 
import com.sun.java.swing.border.*; 
//import javax.swing.*;
//import javax.swing.text.*;
//import javax.swing.border.*;

public class DataFileEditorPanel extends JPanel implements ActionListener
{
  private JTextArea textArea;      // The text area object
  private int N_ROW = 20;
  private int N_COL = 80;
  private String data;
  private Font f;
  private File file;
  private ChemToolFrame win;

  // Constructors
  public DataFileEditorPanel(File file)
    {
      this("Date File", file);
    }

  public DataFileEditorPanel(String title, File file)
    { 
      // create the file object
      this.file = file;
      
      // use a Border layout
      setLayout(new BorderLayout());
      setLocation(50, 70);

      // Construct the textArea
      f = new Font("Monospaced", Font.PLAIN, 12);
      
      textArea = new JTextArea("" ,N_ROW, N_COL);
      textArea.setEditable(true);
      textArea.setLineWrap(true);
      textArea.setWrapStyleWord(true);
      textArea.setFont(f);
      
      // Add it to the Frame
      JScrollPane areaScrollPane = new JScrollPane(textArea);
      areaScrollPane.setVerticalScrollBarPolicy(
                        JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
      Border border;
      border = new BevelBorder(BevelBorder.LOWERED);
      areaScrollPane.setBorder(border);        

      add(areaScrollPane, "Center");
      
      // Call the method that reads the text from the "file" object
      ReadText();

      // create a button panel and add the Panel to the frame
      JPanel bp  = new JPanel();
      FlowLayout ly = new FlowLayout(FlowLayout.CENTER, 100, 5);      
      bp.setLayout(ly); 

      // Create the button and add it to panel
      JButton button; 
      
      button = new JButton("Save");
      button.addActionListener(this);
      button.setActionCommand("Save");
      bp.add(button);
     
      button = new JButton("Clear");
      button.addActionListener(this);
      button.setActionCommand("Clear");
      bp.add(button);
     
      button = new JButton("Close");
      button.addActionListener(this);
      button.setActionCommand("close");
      bp.add(button);
     
      // Add the buttons to panel
      add(bp, "South");
      
      win = new ChemToolFrame(title + " File " + "(" + file + ")", this);
    }
    
  // Handle the events
  public void actionPerformed(ActionEvent e)
    {
      String cmd;
      cmd = e.getActionCommand();
      
      if(cmd.equals("Save"))
	{
          SaveText();
	}
      else if(cmd.equals("close"))
	{
          win.setVisible(false);
          win.dispose();
	}
      else if(cmd.equals("Clear"))
	{
          textArea.setText("");
	}
    }

  // Method to read text from file
  private void ReadText()
    {
      String dtext = "";
      TextInputFile f = new TextInputFile(file);
      while(!f.eof())
	{
          dtext += f.readLine() + "\n";
	}
      f.close();
      textArea.setText(dtext);
      // add code here
    }
  // Method to save the text from  display to a specific file
  private void SaveText()
    {
      String dtext = textArea.getText();
      TextOutputFile f = new TextOutputFile(file);
      f.print(dtext);   
      f.close();   
    } 
}      

      
           



