 
/**
 * MopacApp.java
 * This class is the class that actually runs the program 
 *
 * Created: Thu Apr 29 15:20:17 1999
 *
 * @author Nathan Stevens
 * @version 0.1
 */
import java.io.*;

public class MopacApp extends ChemAppThread
{
  private String[] Jobs;
  private Process process;
  private MopacPanel mp;
  private String command;
  private String Mode;
  private String[] com;    
  private Timer tm1, tm2;

  public MopacApp(MopacPanel mp)
    {
      this.mp = mp;
      command = mp.getCommand();
      Mode = mp.getMode();
      Jobs = mp.getJobs();             
    }
   
  public void run()
    {
      // call the startjob method
      startJob();
    }

  synchronized private void startJob()
    {
      if(Mode.equals("local"))
	{
          tm1 = new Timer();
          // Disable the start button
          mp.setActive(false);
      
          com = new String[2];
          com[0] = command;
      
	  //start primary timer
          tm1.start();
	  
	  // start pr
          for(int i = 0; i < Jobs.length; i++)
	    {
              com[1] = Jobs[i];
              tm2 = new Timer();
              
	      // Now execute the command and wait for it to finish
              try
	        {
                  process =  Runtime.getRuntime().exec(com);
                  tm2.start();
                  process.waitFor();
                  tm2.stop();
	        }
              catch(IOException e)
	        {
	          // code
	        }
              catch(InterruptedException e)
	        {
	          // code
	        }    
	    }
	  //stop the primary timer
          tm1.stop();

          //Enable the start button
          mp.setActive(true);
	}
    }  

  // Controller method used by BabelPanel
  public void stopJob()
    {
      // kill the current process
      process.destroy();
    }

  public void stopAllJobs()
    {
      // Kill the entire thread
      stopJob();
      this.stop();
    }

  // Method to get the status of things
  public String[] getStatus()
    {
      int[] time1 = tm1.getMinSec();
      int[] time2 = tm2.getMinSec();
      
      String t1 = time1[0] + ":" + time1[1];
      String t2 = time2[0] + ":" + time2[1];     

      String[] status = {"The Current Job is " + com[1],
                         "It has been runing for " + t2,
                         "The Total time  is " + t1};

      return status;
    } 
}




