
/**
 * ChemConsoleFrame.java
 * This is the main frame  class in the Chemconsole program
 *
 * Created: Thu Apr 22 10:01:48 1999
 *
 * @author Nathan Stevens
 * @version 0.2
 */

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
//import javax.swing.*;
//import javax.swing.event.*;
 
public class ChemConsoleFrame extends JFrame implements ActionListener
{  
  private ChemMessage m = new ChemMessage();
  
  public ChemConsoleFrame (String title)
    {
      super(title);            // call the base constructor

      // Construct the menu bar
      JMenuBar mbar = new JMenuBar();
      JMenu menu  = new JMenu("File");
      JMenuItem item;
     
      item = new JMenuItem("Exit");
      item.addActionListener(this);
      item.setActionCommand("exit");
      item.setMnemonic('e'); 
      menu.add(item);
      mbar.add(menu);
      
      menu  = new JMenu("Tools");
     
      item = new JMenuItem("BABEL");
      item.addActionListener(this);
      item.setActionCommand("babel");
      item.setMnemonic('b'); 
      menu.add(item);
     
      item = new JMenuItem("MOPAC");
      item.addActionListener(this);
      item.setActionCommand("mopac");
      item.setMnemonic('m');  
      menu.add(item);
     
      item = new JMenuItem("Guassian");
      item.addActionListener(this);
      item.setActionCommand("guassian");
      item.setMnemonic('g');
      menu.add(item);
     
      /*item = new JMenuItem("Calculator");
      item.addActionListener(this);
      item.setActionCommand("calculator");
      item.setMnemonic('c'); 
      menu.add(item);*/
      
      menu.addSeparator();
      
      JMenu Net = new JMenu("NetWork");       // Network apps section
 
      item = new JMenuItem("BABEL");          // code will write a method
      item.addActionListener(this);
      item.setActionCommand("nbabel");
      item.setMnemonic('a');
      Net.add(item);
      
      item = new JMenuItem("MOPAC");
      item.addActionListener(this);
      item.setActionCommand("nmopac");
      item.setMnemonic('o');
      Net.add(item);

      item = new JMenuItem("Gaussian");
      item.addActionListener(this);
      item.setActionCommand("ngaussian");
      item.setMnemonic('g');
      Net.add(item);
      menu.add(Net);
            
      menu.addSeparator();
      
      item = new JMenuItem("Configure");
      item.addActionListener(this);
      item.setActionCommand("config");
      item.setMnemonic('n');
      menu.add(item);  

      mbar.add(menu);
   
      mbar.add(Box.createHorizontalGlue());
        
      menu  = new JMenu("Help");
      
      item = new JMenuItem("Contents");
      item.addActionListener(this);
      item.setActionCommand("content");
      item.setMnemonic('c');
      menu.add(item);
      
      menu.addSeparator();

      item = new JMenuItem("About");
      item.addActionListener(this);
      item.setActionCommand("about");
      item.setMnemonic('a');
      menu.add(item);

      mbar.add(menu);
      
      // set the menu bar
      setJMenuBar(mbar);  
     
    }
          
  public void actionPerformed(ActionEvent e)
    {
      String cmd = e.getActionCommand();
      
      if(cmd.equals("exit"))
      {
        close();
      }
      else if(cmd.equals("babel"))
	{
          BabelPanel bp = new BabelPanel();
          ChemToolFrame bf = new ChemToolFrame("Babel Tool", bp  );
	}     
      else if(cmd.equals("mopac"))
	{
          MopacPanel mp  = new MopacPanel();
          ChemToolFrame mf = new ChemToolFrame("Mopac Tool", mp);
	}
      else if(cmd.equals("guassian"))
	{
	  //code
	}
      else if(cmd.equals("config"))
	{
          ConfigPanel cfg = new ConfigPanel();
          ChemToolFrame cf = new ChemToolFrame("Configure", cfg);
	}
      else if(cmd.equals("nbabel"))
	{
          BabelPanel nbp = new BabelPanel("network");
          ChemToolFrame nbf = new ChemToolFrame("Network Babel Tool", nbp);
	}
      else if(cmd.equals("nmopac"))
	{
          MopacPanel nmp  = new MopacPanel("network");
          ChemToolFrame nmf = new ChemToolFrame("Network Mopac Tool", nmp);
	}
      else if(cmd.equals("content"))
	{
          Help hp = new Help();
	}
      else if(cmd.equals("about"))
	{
          getAbout();
	}      
    }

  // Method to print the about message
  private void getAbout()
    {
      String[] msg = {"ChemConsole v0.2",
                     " ",
                     "Author: Nathan Stevens",
                     "Email : nat250@cyberwar.com",
                     " ",
                     "Sends Bugs to above email"};

     m.msgPrint(msg, "About");
    }
   
  // metohd to close the exit the program
  private void close()
    {
      setVisible(false);
      dispose();
      System.exit(0);
    }
} 
         
 



