
/**
 * ServerConfigPanel.java
 * This Class is called by other Config Classes to set the servers 
 *
 * Created: Mon May  3 11:12:59 1999
 *
 * @author Nathan Stevens
 * @version 0.2
 */
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.text.*;
//import javax.swing.*;
//import javax.swing.event.*;
//import javax.swing.text.*;

public class ServerConfigPanel extends JPanel implements ActionListener,
                               ListSelectionListener
{
  private JList list;
  private Vector Server;
  private int last;
  private Object[] selValues;
  private JButton  bt1 , bt2;
  private JTextField tf1;
  private ChemMessage m;

  public ServerConfigPanel()
    {
      setLayout(new BorderLayout());
     
      // intialize the Message object 
      m = new ChemMessage();
      
      // add the buttons to the East position
      JPanel pan = new JPanel();
      pan.setLayout(new GridLayout(3,1));
      
      JPanel pan1 = new JPanel();
      pan1.setLayout(new FlowLayout(FlowLayout.LEFT));
      
      JLabel lb1  = new JLabel("Add Server :");
      pan1.add(lb1);
      
      tf1 = new JTextField(20);
      tf1.addActionListener(this);
      pan1.add(tf1);
      pan.add(pan1);
      
      JPanel pan2 = new JPanel();
      pan2.setLayout(new FlowLayout(FlowLayout.LEFT));
      
      bt1 = new JButton("Remove     ");
      bt1.addActionListener(this);
      pan2.add(bt1);
      pan.add(pan2);
     
      JPanel pan3 = new JPanel();
      pan3.setLayout(new FlowLayout(FlowLayout.LEFT));
                                      
      bt2 = new JButton("Remove All");
      bt2.addActionListener(this);
      pan3.add(bt2);
      pan.add(pan3);
      
      add(pan, "West");

      // add the Dynamic  JList to Center
      final DefaultListModel model = new DefaultListModel();
      list = new JList(model);
      list.addListSelectionListener(this);
      JScrollPane sp = new JScrollPane(list);
      add(sp, "Center");
    }
 
  public void setServer(Vector v)
    {
      Server = v;
      addServer(); 
    }
  public Vector getServer()
    {
      return Server;
    }     

  // Handels the events 
  public void actionPerformed(ActionEvent e)
    {
      if(e.getSource() == tf1)
	{
          if(tf1.getText().length() != 0)
	    {
              addServer(tf1.getText());
	    }
          else
	    {
              m.errPrint("Not a valid Server name!", "Error");
	    }
	}
      else if(e.getSource() == bt1) 
	{  
          remServer();
	}
      else if(e.getSource() == bt2)
	{	
          remAllServer();
	} 
    }

  public void valueChanged(ListSelectionEvent e)
    {
      selValues = list.getSelectedValues();
      last = selValues.length;
    }

  /**
   * Methods below this point are to handel the events.
   *
   **/ 

  // Method to add  data
  private void addServer(String name)
    {
      //put the file String into a vector the main vector
      Server.addElement(name);
      addServer(); 
    }

  private void addServer()
    {
      // all the addData methods eventually calls this method
      list.setListData(Server);
      list.revalidate();
      
      //Bug work arounds
      revalidate();
      if(Server.size() != 0)
        {           
          list.setSelectedIndex(0);
        }
      tf1.setText("");
    }
  
  // Method to remove the selected Servers from list
  private void remServer()
    {
      //remove the the selected values from vector
      for(int i = 0; i < last; i++)
        {
          Server.removeElement(selValues[i]);
        }
      // now reset the data.
      addServer();
    }

  private void remAllServer()
    {
      selectAll();
      Server.removeAllElements();
      addServer();
    }

  // Method to select all the value in the list
  private void selectAll()
    { 
      if(Server.size() != 0)
	{
          int[] Indices = new int[Server.size()];
          int listSize  = Server.size();
          for(int i = 0; i < listSize; i++)
           {
             Indices[i] = i;
           }
          list.setSelectedIndices(Indices);
	} 
    }
}




