
/**
 * Timer.java
 * This class is used as a timer to track of os something 
 *
 * Created: Wed May 12 14:13:07 1999
 *
 * @author Nathan Stevens
 * @version 0.1;
 */

public class Timer extends Thread
{
  private int sec;            // Seconds 
  private int min;            // minutes
  private int hr;             // hour 

  // Constructor
  public Timer()
    {
      sec = 0;
      min = 0;
      hr = 0;
    }
  
  public void run()
    {
      try
	{
          while(true)
	   {
             Thread.sleep(1000);       // sleep for one second
             sec++;                    // now increment the sec
	   }
	}
      catch(InterruptedException e)
	{
	  System.out.println(e);
	}
    }
  
  // gets the time in seconds
  public int getSeconds()
    {
      return sec;
    }

  // get the time in minutes
  public int getMinutes()
    { 
      if(sec >= 60)
	{
           return sec/60;
	}
      else
	{
           return 0;
	}
    }

  // get the time in hours
  public int getHours()
    {
      if(sec >= 3600)
	{
          return sec/3600;
	}
      else
	{
          return 0;
	}

    }

  // get the min and seconds
  public int[] getMinSec()
    {
      int[] tmp = new int[2];
      
      if(sec >= 60)
        {
          tmp[0] = sec / 60;
          tmp[1] = sec % 60;
	}
      else
	{
          tmp[0] = 0;
          tmp[1] = sec;
	}
     
      return tmp;
    }
  
  // get the hour and min and seconds
  public int [] getHrMinSec()
    {
      int[] tmp  = new int[3];
      
      if(sec >= 3600)
	{
          tmp[0]  = sec / 3600;
          if(sec % 3600 >= 60)
	    {
              tmp[1] = (sec % 3600) / 60;
              tmp[2] = (sec % 3600) % 60;
	    }
          else
	    {
              tmp[1] = 0;
              tmp[2] = sec % 3600;
	    }
             
	}
      else
	{
          tmp[0] = 0;
          if(sec >= 60)
	    {
              tmp[1] = sec / 60;
              tmp[2] = sec % 60;
	    }
          else
	    {
             tmp[1] = 0;
             tmp[2] = sec;
	    } 
	}
      return tmp;
    }
}

