#!/bin/bash
#This shell is used to compile the whole program
#I will eventually write a real make file
#
INSTALL_DIR=/home/nath/Jfc/Chemc-0.2

#clear the screen
clear
if [ $1 = all ]
then
     echo Starting compilation of ChemConsole!
     echo
     javac -verbose ChemConsoleFrame.java
     javac -verbose ChemToolFrame.java
     javac -verbose TextInputFile.java
     javac -verbose TextOutputFile.java
     javac -verbose fDialog.java
     javac -verbose ChemMessage.java
     javac -verbose StatusPanel.java
     javac -verbose TextFileViewer.java
     javac -verbose Help.java
     javac -verbose FileListFilter.java
     javac -verbose DataFileEditorPanel.java
     javac -verbose Timer.java
     javac -verbose ConfigPanel.java
     javac -verbose ServerConfigPanel.java
     javac -verbose BabelConfigPanel.java 
     javac -verbose MopacConfigPanel.java
     javac -verbose GaussConfigPanel.java
     javac -verbose ChemAppThread.java
     javac -verbose NetworkPanel.java 
     javac -verbose BabelPanel.java 
     javac -verbose BabelApp.java
     javac -verbose MopacPanel.java
     javac -verbose MopacApp.java  
     javac -verbose GuassianPanel.java
     javac -verbose ChemConsole.java
     echo Compilation done!
     echo
elif [ $1 = install ]
then
     echo Making "ChemConsole.jar"
     jar cvf ChemConsole.jar *.class

     #
     # Now move the files to version directory
     #
     echo Copying Jar file to build directory
     cp --verbose ChemConsole.jar $INSTALL_DIR
     echo Copying source files to src directory 
     cp --verbose *.java $INSTALL_DIR/src
     cp --verbose mk.sh $INSTALL_DIR/src
     
elif [ $1 = doc ]
then
     echo Coping help files and Readme.txt  to doc directory
     cp --verbose doc/*.txt $INSTALL_DIR/doc
     cp --verbose README.txt $INSTALL_DIR/
else
     echo Not a valid option. The valid options are:
     echo mk.sh all
     echo mk.sh install
     echo mk.sh doc
fi
      
   

  
