/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class CCServerManager
extends UnicastRemoteObject
implements CCServer {
    private int MAX_GAUSS;
    private int MAX_MOPAC;
    private int MAX_BABEL;
    private int MAXTHREADS;
    private int bc;
    private int mc;
    private int gc;
    private CCServerImpl[] threads;
    String JobType;
    private int id;
    private int[] fa;
    private static String mdir = "Mwork";
    private File mdf;
    private static File conf = new File("Config/main.cfg");
    private static boolean verbose;

    public CCServerManager() throws RemoteException {
        if (conf.isFile()) {
            TextInputFile textInputFile = new TextInputFile(conf);
            this.MAX_BABEL = textInputFile.readInt();
            this.MAX_MOPAC = textInputFile.readInt();
            this.MAX_GAUSS = textInputFile.readInt();
            textInputFile.close();
            this.MAXTHREADS = this.MAX_GAUSS + this.MAX_MOPAC + this.MAX_BABEL;
        } else {
            System.out.println("Unable to read Config file " + conf + "\nProgram Terminated.");
            System.exit(1);
        }
        this.threads = new CCServerImpl[this.MAXTHREADS];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int startAppServer(String string) throws RemoteException {
        this.JobType = string;
        CCServerImpl[] cCServerImplArray = this.threads;
        synchronized (cCServerImplArray) {
            if (string.equals("babel")) {
                this.id = 0;
                while (this.id < this.MAX_BABEL) {
                    if (this.threads[this.id] == null) break;
                    ++this.id;
                }
                if (this.id >= this.MAX_BABEL) {
                    return -1;
                }
                this.threads[this.id] = new BabelServer(this.id);
                this.threads[this.id].setDaemon(true);
                this.threads[this.id].start();
                this.threads[this.id].setSM(this);
                if (!verbose) return this.id;
                this.printStats();
            } else if (string.equals("mopac")) {
                this.id = this.MAX_BABEL;
                while (this.id < this.MAX_BABEL + this.MAX_MOPAC) {
                    if (this.threads[this.id] == null) {
                        this.mdf = new File(String.valueOf(mdir) + this.id);
                        if (this.mdf.isDirectory()) break;
                        this.mdf.mkdir();
                        break;
                    }
                    ++this.id;
                }
                if (this.id >= this.MAX_BABEL + this.MAX_MOPAC) {
                    return -1;
                }
                this.threads[this.id] = new MopacServer(this.id, String.valueOf(this.mdf.toString()) + "/");
                this.threads[this.id].setDaemon(true);
                this.threads[this.id].start();
                this.threads[this.id].setSM(this);
                if (!verbose) return this.id;
                this.printStats();
            } else {
                if (!string.equals("gaussain")) return this.id;
                this.id = this.MAX_BABEL + this.MAX_MOPAC;
                while (this.id < this.MAXTHREADS) {
                    if (this.threads[this.id] == null) break;
                    ++this.id;
                }
                if (this.id >= this.MAXTHREADS) {
                    return -1;
                }
                this.threads[this.id] = new GaussianServer(this.id);
                this.threads[this.id].setDaemon(true);
                this.threads[this.id].start();
                this.threads[this.id].setSM(this);
                if (!verbose) return this.id;
                this.printStats();
            }
            return this.id;
        }
    }

    public String[] getStatus(int n) throws RemoteException {
        return this.threads[n].getStatus();
    }

    public int[] getFile(int n, String string) throws RemoteException {
        return this.threads[this.id].getFile(string);
    }

    public boolean putFile(int n, int[] nArray, String string) throws RemoteException {
        return this.threads[n].putFile(nArray, string);
    }

    public boolean delFile(int n, String string) throws RemoteException {
        return this.threads[n].delFile(string);
    }

    public void Stop(int n) throws RemoteException {
        this.threads[n].stop();
        this.threads[n] = null;
    }

    public void StopJob(int n) throws RemoteException {
        this.threads[n].StopJob();
    }

    public boolean isActive(int n) throws RemoteException {
        return this.threads[n].isActive();
    }

    public boolean runApp(int n, String[] stringArray) throws RemoteException {
        return this.threads[n].runApp(stringArray);
    }

    public String getAppBin(int n) throws RemoteException {
        return this.threads[n].getAppBin();
    }

    public int[] getServerStats() throws RemoteException {
        this.bc = 0;
        this.mc = 0;
        this.gc = 0;
        int n = 0;
        while (n < this.MAX_BABEL) {
            if (this.threads[n] != null) {
                ++this.bc;
            }
            ++n;
        }
        int n2 = this.MAX_BABEL;
        while (n2 < this.MAX_BABEL + this.MAX_MOPAC) {
            if (this.threads[n2] != null) {
                ++this.mc;
            }
            ++n2;
        }
        int n3 = this.MAX_BABEL + this.MAX_MOPAC;
        while (n3 < this.MAXTHREADS) {
            if (this.threads[n3] != null) {
                ++this.gc;
            }
            ++n3;
        }
        int n4 = this.bc + this.mc + this.gc;
        int n5 = this.MAXTHREADS;
        int[] nArray = new int[]{n5, n4, this.bc, this.mc, this.gc};
        return nArray;
    }

    private void printStats() {
        try {
            int[] nArray = this.getServerStats();
            System.out.println("\nThe maximum number of clients allowed  : " + nArray[0]);
            System.out.println("The number of clients currently connected : " + nArray[1]);
            System.out.println("The number of Babel clients : " + nArray[2]);
            System.out.println("The number of Mopac clients : " + nArray[3]);
            System.out.println("The number of Gaussian clients : " + nArray[4]);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public String getWorkDir(int n) {
        return this.threads[n].getWorkDir();
    }

    public String[] getFileList(int n, String string, String string2) {
        String string3 = this.threads[n].getWorkDir();
        return this.threads[n].getFileList(string3, string, string2);
    }

    public void setRetrieve(int n, boolean bl) {
        this.threads[n].setRetrieve(bl);
    }

    public static void main(String[] stringArray) {
        verbose = stringArray.length != 0 && stringArray[0].equals("-v");
        System.out.println("Starting ChemConsole Server......");
        System.setSecurityManager(new RMISecurityManager());
        try {
            CCServerManager cCServerManager = new CCServerManager();
            Naming.rebind("ccserver", cCServerManager);
            System.out.println("ChemConsole Server is running.");
            if (verbose) {
                cCServerManager.printStats();
                return;
            }
        }
        catch (Exception exception) {
            System.out.println("CCServerManager.main: an exception occurred: " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

