/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;

public class MopacServer
extends CCServerImpl {
    private String[] status;
    private String wdir;
    private static File conf = new File("Config/mopac.cfg");
    private boolean Active = true;
    private String Mopac_Bin = "mopac";
    private boolean REM_EXT = true;
    private Timer tm1;
    private Timer tm2;
    private String[] com;
    private Process process;
    private boolean retrieve = true;
    private int id;

    public MopacServer(int n, String string) {
        this.id = n;
        this.wdir = string;
        if (conf.isFile()) {
            TextInputFile textInputFile = new TextInputFile(conf);
            this.Active = textInputFile.readBoolean();
            this.Mopac_Bin = textInputFile.readString();
            this.REM_EXT = textInputFile.readBoolean();
            textInputFile.close();
            return;
        }
        System.out.println("Unable to read config file, Mopac Server exiting.");
        this.setNull(n);
    }

    public boolean runApp(String[] stringArray) {
        this.tm1 = new Timer();
        this.com = new String[3];
        this.com[0] = this.Mopac_Bin;
        this.com[2] = this.wdir;
        this.tm1.start();
        int n = 0;
        while (n < stringArray.length) {
            if (this.REM_EXT) {
                int n2 = stringArray[n].length() - 4;
                this.com[1] = stringArray[n].substring(0, n2);
            } else {
                this.com[1] = stringArray[n];
            }
            this.tm2 = new Timer();
            try {
                this.process = Runtime.getRuntime().exec(this.com);
                this.tm2.start();
                this.process.waitFor();
                this.tm2.stop();
            }
            catch (IOException iOException) {
                System.out.println("Mopac Error : " + iOException);
                this.setNull(this.id);
                return false;
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Mopac Error : " + interruptedException);
                this.setNull(this.id);
                return false;
            }
            ++n;
        }
        this.tm1.stop();
        if (!this.retrieve) {
            this.setNull(this.id);
        }
        return true;
    }

    public String[] getStatus() {
        int[] nArray = this.tm1.getMinSec();
        int[] nArray2 = this.tm2.getMinSec();
        String string = String.valueOf(nArray[0]) + "." + nArray[1] + " Min";
        String string2 = String.valueOf(nArray2[0]) + "." + nArray2[1] + " Min";
        String[] stringArray = new String[]{"Mopac Server\n", "The Current Job is " + this.com[1], "It has been runing for " + string2, "The Total time  is " + string};
        return stringArray;
    }

    public boolean isActive() {
        return this.Active;
    }

    public boolean putFile(int[] nArray, String string) {
        return super.putFile(nArray, String.valueOf(this.wdir) + string);
    }

    public int[] getFile(String string) {
        return super.getFile(String.valueOf(this.wdir) + string);
    }

    public void StopJob() {
        this.process.destroy();
    }

    public void setRetrieve(boolean bl) {
        this.retrieve = bl;
    }

    public String getWorkDir() {
        return this.wdir;
    }
}

