
/**
 * CCServerManager.java
 * This class manages the CCServerImpl 
 *
 * Created: Tue May 25 12:00:22 1999
 *
 * @author Nathan Stevens
 * @version 0.1
 */
import java.rmi.*;
import java.rmi.server.UnicastRemoteObject;
import java.io.*;

public class CCServerManager extends UnicastRemoteObject implements
                                     CCServer
{
  private int MAX_GAUSS;
  private int MAX_MOPAC;
  private int MAX_BABEL;
  private int MAXTHREADS;            //The defualt max connection
  private int bc, mc, gc;
  private CCServerImpl[] threads;
  String JobType = null;
  private int id;
  private int[] fa;
  private static String mdir = "Mwork";
  private File mdf;
  private static File conf = new File("Config/main.cfg");
  private static boolean verbose;  
  
  public CCServerManager() throws RemoteException
    {
      // read in config file and set job type
      if(conf.isFile())
	{
          TextInputFile f = new TextInputFile(conf);

          MAX_BABEL = f.readInt();
          MAX_MOPAC = f.readInt();      
          MAX_GAUSS = f.readInt();
          
          f.close();
          
          MAXTHREADS = MAX_GAUSS + MAX_MOPAC + MAX_BABEL;
	}
      else
	{
          System.out.println("Unable to read Config file " + conf + 
                             "\nProgram Terminated.");
          System.exit(1);
	} 

      // now create an array of all the threads
      threads = new CCServerImpl[MAXTHREADS];

    }

  // set the job type
  public int startAppServer(String s) throws RemoteException
    {
      JobType = s;
      // Synchronize this logic tp provent collisions
      synchronized (threads)
	{
          if(s.equals("babel"))
	     {
               for(id = 0; id < MAX_BABEL; id++)
		 {
                   if(threads[id] == null)          
                       break;
		 }    
	       // if no emty slots found alert client
               if(id >= MAX_BABEL)
		 {
                   return -1;
		 }
	       //create the new thread
               threads[id] = new BabelServer(id);
                   
	       // start the thread
               threads[id].setDaemon(true);
               threads[id].start();
               threads[id].setSM(this);

	       //print stats
               if(verbose)
                 printStats();
		   
	     }

           else if(s.equals("mopac"))
	     {
                for(id = MAX_BABEL; id < MAX_BABEL + MAX_MOPAC; id++)
		 {
                   if(threads[id] == null)
		     {
                       // create a working directory for mopac to run in.
                       mdf = new File(mdir + id);
                       if(!mdf.isDirectory())
			 {
                           mdf.mkdir();
                           break;
			 }
                       break;                       
		     }
		 }                   
		// if no emty slots found alert client
                if(id >= MAX_BABEL + MAX_MOPAC)
		  {
                    return -1; 
		  }
		// create the new thread
                threads[id] = new MopacServer(id, mdf.toString() + "/");
                   
		// start the thread
                threads[id].setDaemon(true);
                threads[id].start();
                threads[id].setSM(this);

	        //print stats
                if(verbose)
                  printStats();
	    
	     }
           else if(s.equals("gaussain"))
	     {
               for(id = MAX_BABEL + MAX_MOPAC; id < MAXTHREADS; id++)
		 {
                   if(threads[id] == null)
                     break;
		 }
                   
	       // if no emty slots found alert client
               if(id >= MAXTHREADS)
		 {
                   return -1;
		 }
	       // create the new thread
               threads[id] = new GaussianServer(id);
                   
	       // start the thread
               threads[id].setDaemon(true);
               threads[id].start();
               threads[id].setSM(this);

	       // get the stats
               if(verbose)
                 printStats();
              
	     }
	}
       
      //System.out.println("OK OK " + id);      
      return id;
    }

  // method to return the status to clients
  public String[] getStatus(int nid) throws RemoteException
    {
      return threads[nid].getStatus();
    }
  
  // Method to return a file
  public int[] getFile(int nid, String filename) throws RemoteException
    {
      return threads[id].getFile(filename);
    }

  // Method to put files
  public boolean putFile(int nid, int[] fileArray, String filename) throws RemoteException
    {
      return threads[nid].putFile(fileArray, filename);
    }

  // Method to remove a file
  public boolean delFile(int nid, String filename) throws RemoteException
    {
      return threads[nid].delFile(filename);
    }

  //Method to stop the current thread and reset it
  public void Stop(int nid) throws RemoteException
    {
      //Shut down the thread
      threads[nid].stop();
      threads[nid] = null;
    }

  // Method to stop a current job
  public void StopJob(int nid) throws RemoteException
    {
      threads[nid].StopJob();
    }

  // Method to see if server is active or not
  public boolean isActive(int nid) throws RemoteException
    {
      return threads[nid].isActive();
    }      

  // Method to run the application
  public boolean runApp(int nid, String[] command) throws RemoteException
    {
      return threads[nid].runApp(command);
    }

  // Method to return the location of App binary to client
  public String getAppBin(int nid) throws RemoteException
    {
      return threads[nid].getAppBin();
    }

  // Method to get the Server Stats
  public int[] getServerStats() throws RemoteException
    {
      bc = 0;                 // number of babel clients
      mc = 0;                 // number of mopac client
      gc = 0;                 // number of gaussin clients connected
      int tc;                 // The total number of clients
      int maxc;                 // The maximum number of clients

      //get the number of babel clients connected
      for(int i = 0; i < MAX_BABEL; i++)
	{
          if(threads[i] != null)
             bc++;
	}

      // get the number of mopac clients connected
      for(int i = MAX_BABEL; i < MAX_BABEL + MAX_MOPAC; i++)
	{
          if(threads[i] != null)
            mc++;
	}
         
      // get the number of gaussian clients
      for(int i = MAX_BABEL + MAX_MOPAC; i < MAXTHREADS; i++)
	{
          if(threads[i] != null)
            gc++;
	}
  
      // Now get the total number of client
      tc = bc + mc + gc;
      maxc = MAXTHREADS;
      
      int[] sStats = {maxc, tc, bc, mc, gc};
      
      return sStats;
    }

  //Method to print out the Stats of server
  private void printStats()
    {
      try
	{
          int[] ss = getServerStats();
      
          System.out.println("\nThe maximum number of clients allowed  : " + 
                          ss[0]);
          System.out.println("The number of clients currently connected : " +
                          ss[1]);
          System.out.println("The number of Babel clients : " + ss[2]);
          System.out.println("The number of Mopac clients : " + ss[3]);
          System.out.println("The number of Gaussian clients : " + ss[4]);
	}
      catch(RemoteException re){}
    }

  // Method to get the working directory of application
  public String getWorkDir(int nid)
    {
      return threads[nid].getWorkDir();
    }

  public String[] getFileList(int nid, String name, String extension)
    {
      String wdir = threads[nid].getWorkDir();
      return threads[nid].getFileList(wdir, name, extension);
    }

  // Method to set the retrieve boolean 
  public void setRetrieve(int nid, boolean r) 
    {
     threads[nid].setRetrieve(r);
    }

  // The main method to start the object as a background process and
  // bind itself to the registry
  public static void main(String[] args)
    {
      if(args.length != 0 && args[0].equals("-v"))
        verbose = true;
      else
        verbose = false;
        
      System.out.println("Starting ChemConsole Server......");
      
      // Install the security manager
      System.setSecurityManager(new RMISecurityManager());
      
      try
	{
          // Instantiate and register the remote object
          CCServerManager ccm = new CCServerManager();
          Naming.rebind("ccserver", ccm);
          System.out.println("ChemConsole Server is running.");

          if(verbose)
            ccm.printStats();
	}
      catch(Exception e)
	{
         System.out.println("CCServerManager.main: an exception " +
                             "occurred: " + e.getMessage());
         e.printStackTrace();
	}
    }    
}  
  











