#!/bin/bash
#This shell script is used to compile the whole program under Linux.
#I will eventually write a real make file.
#modify to fit your platform
#

INSTALL_DIR=/home/nath/Jfc/CCS-0.3

#clear the screen
clear
if [ $1 = all ]
then
     echo Starting compilation of ChemConsoleServer!
     echo
     javac -verbose CCServer.java
     javac -verbose CCServerManager.java
     javac -verbose TextInputFile.java
     javac -verbose TextOutputFile.java
     javac -verbose CCServerImpl.java
     javac -verbose BabelServer.java
     javac -verbose MopacServer.java
     javac -verbose GaussianServer.java
     javac -verbose FileListFilter.java
     javac -verbose Timer.java
     javac -verbose FileListFilter.java

     #now make the stubs and skelleton
     rmic -verbose CCServerManager

     echo Compilation done!
     echo
elif [ $1 = install ]
then
     # firt thing to do is move skel stub to different names to prevent from
     # being placed in the jar

     mv CCServerManager_Skel.class skel.bak
     mv CCServerManager_Stub.class stub.bak

     echo Making "CCServer.jar"
     jar cvf CCServer.jar *.class
    
     #move them back
     mv skel.bak CCServerManager_Skel.class
     mv stub.bak CCServerManager_Stub.class
     
     #
     # Now move the files to the version directory
     #
     echo Copying Jar file to build directory
     cp --verbose CCServer.jar $INSTALL_DIR
     echo Copying the Skel class
     cp --verbose CCServerManager_Skel.class $INSTALL_DIR/rmic
     cp --verbose CCServerManager_Stub.class $INSTALL_DIR/rmic
 
     echo Copying source files to src directory 
     cp --verbose *.java $INSTALL_DIR/src
     cp --verbose mk.sh $INSTALL_DIR/src
     
     echo Cpoying the default config files to Config directory
     cp --verbose Config/*.cfg $INSTALL_DIR/Config
     
elif [ $1 = doc ]
then
     echo Coping help files and Readme.txt  to doc directory
     cp --verbose doc/*.html $INSTALL_DIR/doc
     cp --verbose README.txt $INSTALL_DIR/
     cp --verbose mREADME.txt $INSTALL_DIR/
else
     echo Not a valid option. The valid options are:
     echo mk.sh all
     echo mk.sh install
     echo mk.sh doc
fi
      
   

  
