/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;

public class ChemConsoleClient
extends ChemAppThread {
    private String JobType;
    private String hostname;
    public CCServer server;
    private int[] fa;

    public ChemConsoleClient(String string, String string2) throws RemoteException {
        this.JobType = string;
        this.hostname = string2;
        String string3 = "rmi://" + string2 + ":1099/ccserver";
        try {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            this.server = (CCServer)Naming.lookup(string3);
            return;
        }
        catch (Exception exception) {
            System.err.println("Cannot connect to RMI registry for " + string3);
            System.out.println(exception.toString());
            this.stop();
            return;
        }
    }

    public int startAppServer() throws RemoteException {
        return this.server.startAppServer(this.JobType);
    }

    public String[] getStatus(int n) throws RemoteException {
        return this.server.getStatus(n);
    }

    public boolean getFile(int n, String string) throws RemoteException {
        block4: {
            this.fa = this.server.getFile(n, string);
            try {
                File file = new File(string);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                if (this.fa != null) {
                    int n2 = 0;
                    while (n2 < this.fa.length) {
                        bufferedOutputStream.write(this.fa[n2]);
                        ++n2;
                    }
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                    break block4;
                }
                return false;
            }
            catch (IOException iOException) {
                System.out.println(iOException.toString());
                return false;
            }
        }
        return true;
    }

    public boolean putFile(int n, String string, String string2) throws RemoteException {
        File file = new File(string);
        try {
            if (file.isFile()) {
                int[] nArray = new int[(int)file.length()];
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                int n2 = 0;
                while (n2 < nArray.length) {
                    nArray[n2] = bufferedInputStream.read();
                    ++n2;
                }
                return this.server.putFile(n, nArray, string2);
            }
            System.out.println("Could not find the file " + file);
            return false;
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
            return false;
        }
    }

    public boolean delFile(int n, String string) throws RemoteException {
        return this.server.delFile(n, string);
    }

    public boolean isActive(int n) throws RemoteException {
        return this.server.isActive(n);
    }

    public String getAppBin(int n) throws RemoteException {
        return this.server.getAppBin(n);
    }

    public String getWorkDir(int n) throws RemoteException {
        return this.server.getWorkDir(n);
    }

    public boolean runApp(int n, String[] stringArray) throws RemoteException {
        return this.server.runApp(n, stringArray);
    }

    public void Stop(int n) throws RemoteException {
        this.server.Stop(n);
    }

    public void StopJob(int n) throws RemoteException {
        this.server.StopJob(n);
    }

    public String[] getFileList(int n, String string, String string2) throws RemoteException {
        return this.server.getFileList(n, string, string2);
    }

    public void setRetrieve(int n, boolean bl) throws RemoteException {
        this.server.setRetrieve(n, bl);
    }
}

