/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.swing.DefaultListModel;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JList;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.ListModel;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.SoftBevelBorder;
import com.sun.java.swing.border.TitledBorder;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class MopacPanel
extends JPanel
implements ActionListener,
Serializable,
ListSelectionListener {
    private String Mode;
    private String command;
    private File Pool = new File("JobPool/mpool");
    private static File cfile = new File("Config/mopac.cfg");
    private File datafile;
    private JList list;
    private int last;
    private Object[] selValues;
    private Vector listdata = new Vector();
    private String[] jobs;
    private Vector ServerList;
    private JButton addb;
    private JButton remb;
    private JButton remab;
    private JButton startb;
    private JButton stopb;
    private JButton statb;
    private JButton stopab;
    private JButton edit;
    private JButton loadj;
    private JButton savej;
    private JButton selb;
    private fDialog fd;
    private ChemMessage m = new ChemMessage(this);
    private MopacApp ma;
    private NetworkPanel np;
    private DataFileEditorPanel ed;
    public boolean REM_EXT = true;

    public MopacPanel() {
        this("local");
    }

    public MopacPanel(String string) {
        this.Mode = string;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        SoftBevelBorder softBevelBorder = new SoftBevelBorder(0);
        this.setBorder((Border)softBevelBorder);
        if (this.Mode.equals("network")) {
            this.np = new NetworkPanel();
            ((Container)((Object)this)).add((Component)((Object)this.np), "South");
        }
        Font font = new Font("Times-Roman", 2, 14);
        JLabel jLabel = new JLabel("Mopac", 0);
        jLabel.setFont(font);
        ((Container)((Object)this)).add((Component)jLabel, "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        TitledBorder titledBorder = new TitledBorder("Mopac Job Pool");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(2);
        jPanel.setBorder((Border)titledBorder);
        DefaultListModel defaultListModel = new DefaultListModel();
        this.list = new JList((ListModel)defaultListModel);
        this.list.addListSelectionListener((ListSelectionListener)this);
        JScrollPane jScrollPane = new JScrollPane((Component)this.list);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 5, 10));
        this.selb = new JButton("Select All");
        this.selb.addActionListener((ActionListener)this);
        jPanel2.add((Component)this.selb);
        this.statb = new JButton("  Status  ");
        this.statb.addActionListener((ActionListener)this);
        jPanel2.add((Component)this.statb);
        jPanel.add((Component)jPanel2, "South");
        ((Container)((Object)this)).add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(5, 1));
        titledBorder = new TitledBorder("Job Control");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(2);
        jPanel3.setBorder((Border)titledBorder);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1, 5, 0));
        this.addb = new JButton("   Add    ");
        this.addb.addActionListener((ActionListener)this);
        jPanel4.add((Component)this.addb);
        this.remb = new JButton("  Remove  ");
        this.remb.addActionListener((ActionListener)this);
        jPanel4.add((Component)this.remb);
        this.remab = new JButton("Remove All");
        this.remab.addActionListener((ActionListener)this);
        jPanel4.add((Component)this.remab);
        jPanel3.add((Component)jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1, 5, 0));
        this.startb = new JButton(" Start  ");
        this.startb.addActionListener((ActionListener)this);
        jPanel5.add((Component)this.startb);
        this.stopb = new JButton("  Stop  ");
        this.stopb.addActionListener((ActionListener)this);
        jPanel5.add((Component)this.stopb);
        this.stopab = new JButton("Stop All");
        this.stopab.addActionListener((ActionListener)this);
        jPanel5.add((Component)this.stopab);
        jPanel3.add((Component)jPanel5);
        this.edit = new JButton("Edit");
        this.edit.addActionListener((ActionListener)this);
        jPanel3.add((Component)this.edit);
        this.loadj = new JButton("Load Job Pool");
        this.loadj.addActionListener((ActionListener)this);
        jPanel3.add((Component)this.loadj);
        this.savej = new JButton("Save Job Pool");
        this.savej.addActionListener((ActionListener)this);
        jPanel3.add((Component)this.savej);
        ((Container)((Object)this)).add((Component)jPanel3, "East");
        this.ReadCfg();
        this.upDate();
    }

    private void ReadCfg() {
        if (cfile.isFile()) {
            TextInputFile textInputFile = new TextInputFile(cfile);
            this.command = textInputFile.readString();
            this.REM_EXT = textInputFile.readBoolean();
            if (this.Mode.equals("network")) {
                this.ServerList = new Vector();
                while (!textInputFile.eof()) {
                    this.ServerList.addElement(textInputFile.readString());
                }
            }
            textInputFile.close();
            return;
        }
        String[] stringArray = new String[]{"The Config file \"babel.cfg\" was found.", "Please Run the Config Utility.", "Using Defaults."};
        this.m.errPrint(stringArray, "File Error");
    }

    private void upDate() {
        if (this.Mode.equals("network")) {
            this.np.setBoxData(this.ServerList);
        }
        this.mJobPool();
    }

    private void mJobPool() {
        try {
            if (!this.Pool.exists()) {
                this.Pool.mkdir();
                return;
            }
        }
        catch (Exception exception) {
            this.m.errPrint("Exeception thrown: " + exception, "Excetion");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addb) {
            this.addJob();
            return;
        }
        if (actionEvent.getSource() == this.remb) {
            this.remJob();
            return;
        }
        if (actionEvent.getSource() == this.remab) {
            this.remAllJob();
            return;
        }
        if (actionEvent.getSource() == this.startb && this.selValues != null) {
            this.startJob();
            return;
        }
        if (actionEvent.getSource() == this.stopb && this.ma != null) {
            this.stopJob();
            return;
        }
        if (actionEvent.getSource() == this.stopab && this.ma != null) {
            this.stopAllJobs();
            return;
        }
        if (actionEvent.getSource() == this.edit && this.selValues != null) {
            this.editFile();
            return;
        }
        if (actionEvent.getSource() == this.loadj) {
            this.loadJobPool();
            return;
        }
        if (actionEvent.getSource() == this.savej) {
            this.saveJobPool();
            return;
        }
        if (actionEvent.getSource() == this.selb) {
            this.selectAll();
            return;
        }
        if (actionEvent.getSource() == this.statb) {
            this.getStatus();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.selValues = this.list.getSelectedValues();
        this.last = this.selValues.length;
    }

    private void addJob() {
        this.fd = new fDialog((Component)((Object)this), "Data File Input");
        this.fd.setBackground(this.getPanelColor());
        FileListFilter fileListFilter = new FileListFilter(null, "dat");
        this.fd.setFilenameFilter(fileListFilter);
        this.fd.show();
        String string = this.fd.getFile();
        try {
            if (string != null) {
                File file = new File(string);
                if (file.isFile()) {
                    if (this.REM_EXT && this.Mode.equals("local")) {
                        int n = string.length() - 4;
                        String string2 = string.substring(0, n);
                        this.addData(string2);
                        return;
                    }
                    this.addData(string);
                    return;
                }
                this.m.errPrint("The file " + string + " doesn't exist", "Data File Input Error");
                return;
            }
        }
        catch (Exception exception) {
            System.out.println("An error occured " + exception);
        }
    }

    private void remJob() {
        int n = 0;
        while (n < this.last) {
            this.listdata.removeElement(this.selValues[n]);
            ++n;
        }
        this.addData();
    }

    private void remAllJob() {
        this.selectAll();
        this.listdata.removeAllElements();
        this.addData();
    }

    private void startJob() {
        if (this.selValues.length != 0) {
            this.ma = new MopacApp(this);
            this.ma.start();
            return;
        }
        this.m.errPrint("No Input File(s) selected", "Input Error");
    }

    private void stopJob() {
        this.ma.stopJob();
    }

    private void stopAllJobs() {
        this.ma.stopAllJobs();
    }

    private void editFile() {
        int n = 0;
        while (n < this.last) {
            this.datafile = this.REM_EXT ? new File(String.valueOf((String)this.selValues[n]) + ".dat") : new File((String)this.selValues[n]);
            if (this.datafile.isFile()) {
                this.ed = new DataFileEditorPanel("Mopac Data", this.datafile);
            }
            ++n;
        }
    }

    private void loadJobPool() {
        this.fd = new fDialog((Component)((Object)this), "Load Job Pool");
        this.fd.setBackground(this.getPanelColor());
        this.fd.show();
        String string = this.fd.getFile();
        try {
            if (string != null) {
                File file = new File(this.Pool, string);
                if (file.exists()) {
                    ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                    this.listdata = (Vector)objectInputStream.readObject();
                    this.addData();
                    return;
                }
                this.m.errPrint("The file you specified doesn't exist", "Pool File Error");
                return;
            }
        }
        catch (IOException iOException) {
            this.m.errPrint("The following error ocurred " + iOException, "IO Error");
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.m.errPrint("The following error occured " + classNotFoundException, "ClassNotFound Error");
        }
    }

    private void saveJobPool() {
        this.fd = new fDialog((Component)((Object)this), "Save Job Pool");
        this.fd.setBackground(this.getPanelColor());
        this.fd.show();
        String string = this.fd.getFile();
        try {
            if (string != null) {
                File file = new File(this.Pool, String.valueOf(string) + ".mjp");
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                objectOutputStream.writeObject(this.listdata);
                objectOutputStream.close();
                return;
            }
        }
        catch (IOException iOException) {
            this.m.errPrint("IO exception " + iOException, "IO Exception");
        }
    }

    private void selectAll() {
        int[] nArray = new int[this.listdata.size()];
        int n = this.listdata.size();
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        this.list.setSelectedIndices(nArray);
    }

    private void getStatus() {
        if (this.ma != null) {
            this.m.msgPrint(this.ma.getStatus(), "Status");
            return;
        }
        this.m.msgPrint("There are no Mopac Jobs Runing", "Status");
    }

    private void addData(String string) {
        this.listdata.addElement(string);
        this.addData();
    }

    private void addData() {
        this.list.setListData(this.listdata);
        this.list.revalidate();
        this.revalidate();
        if (this.listdata.size() != 0) {
            this.list.setSelectedIndex(0);
        }
    }

    private Color getPanelColor() {
        return ((Component)((Object)this)).getBackground();
    }

    public String getMode() {
        return this.Mode;
    }

    public String getCommand() {
        return this.command;
    }

    public String[] getJobs() {
        this.jobs = new String[this.last];
        int n = 0;
        while (n < this.last) {
            this.jobs[n] = (String)this.selValues[n];
            ++n;
        }
        return this.jobs;
    }

    public String getServer() {
        return this.np.getServer();
    }

    public boolean isRetrieve() {
        return this.np.isRetrieve();
    }

    public void setActive(boolean bl) {
        if (bl) {
            this.startb.setEnabled(bl);
            return;
        }
        this.startb.setEnabled(bl);
    }
}

