/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.swing.JButton;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.border.BevelBorder;
import com.sun.java.swing.border.Border;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class TextFileViewer
extends JPanel
implements ActionListener {
    private ChemToolFrame frame;
    private JTextArea textArea;
    private JTextField tf;
    private File[] files;
    private String text;
    private String title;
    private int cPage;
    private int N_Cols;
    private int N_Rows;
    private int val;

    public TextFileViewer(File[] fileArray) {
        this(fileArray, "Text File Viewer", 20, 80);
    }

    public TextFileViewer(File[] fileArray, String string, int n, int n2) {
        this.files = fileArray;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Component)((Object)this)).setLocation(50, 70);
        this.N_Rows = n;
        this.N_Cols = n2;
        this.textArea = new JTextArea("", this.N_Rows, this.N_Cols);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this.textArea);
        BevelBorder bevelBorder = new BevelBorder(1);
        jScrollPane.setBorder((Border)bevelBorder);
        ((Container)((Object)this)).add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        FlowLayout flowLayout = new FlowLayout(1, 2, 5);
        jPanel.setLayout(flowLayout);
        JButton jButton = new JButton("  <  ");
        jButton.addActionListener((ActionListener)this);
        jButton.setActionCommand("down");
        jPanel.add((Component)jButton);
        jButton = new JButton("  >  ");
        jButton.addActionListener((ActionListener)this);
        jButton.setActionCommand("up");
        jPanel.add((Component)jButton);
        JLabel jLabel = new JLabel(" Go to: ");
        jPanel.add((Component)jLabel);
        this.tf = new JTextField(4);
        this.tf.addActionListener((ActionListener)this);
        jPanel.add((Component)this.tf);
        jLabel = new JLabel(" of " + (fileArray.length - 1) + " ");
        jPanel.add((Component)jLabel);
        jButton = new JButton("Print ");
        jButton.addActionListener((ActionListener)this);
        jButton.setActionCommand("print");
        jPanel.add((Component)jButton);
        jButton = new JButton("Close ");
        jButton.addActionListener((ActionListener)this);
        jButton.setActionCommand("close");
        jPanel.add((Component)jButton);
        ((Container)((Object)this)).add((Component)jPanel, "South");
        this.frame = new ChemToolFrame(string, this);
        this.getPage(1);
    }

    private void getPage(int n) {
        this.cPage = n;
        this.text = "";
        this.tf.setText(String.valueOf(this.cPage));
        TextInputFile textInputFile = new TextInputFile(this.files[n]);
        while (!textInputFile.eof()) {
            this.text = String.valueOf(this.text) + textInputFile.readLine() + "\n";
        }
        textInputFile.close();
        this.textArea.setText(this.text);
    }

    private void ReadField() {
        String string = this.tf.getText();
        try {
            this.val = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Number format exception thrown");
            System.out.println(numberFormatException);
            this.tf.setText(String.valueOf(this.cPage));
        }
        if (this.val > 0 & this.val < this.files.length) {
            this.getPage(this.val);
            return;
        }
        this.tf.setText(String.valueOf(this.cPage));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("down") && this.cPage > 1) {
            this.getPage(this.cPage - 1);
            return;
        }
        if (string.equals("up") && this.cPage < this.files.length - 1) {
            this.getPage(this.cPage + 1);
            return;
        }
        if (!string.equals("print")) {
            if (string.equals("close")) {
                this.frame.Close();
                return;
            }
            this.ReadField();
        }
    }
}

