/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;

public class TextOutputFile {
    private String fileName;
    private PrintWriter f;
    private RandomAccessFile r;
    private ByteArrayOutputStream b;
    private OutputStreamWriter o;
    private boolean closed = false;
    private boolean useStandardIO = false;
    private String lineSeparator = System.getProperty("line.separator");

    public TextOutputFile() {
        this("Standard output");
    }

    public TextOutputFile(File file) {
        this(file, false);
    }

    public TextOutputFile(File file, boolean bl) {
        try {
            if (bl) {
                this.r = new RandomAccessFile(file, "rw");
                this.b = new ByteArrayOutputStream();
                this.o = new OutputStreamWriter(this.b);
                this.r.seek(this.r.length());
            } else {
                this.f = new PrintWriter(new FileWriter(file));
            }
        }
        catch (IOException iOException) {
            this.errPrint("Unable to open file \"" + this.fileName + "\"");
        }
        this.fileName = file.getName();
    }

    public TextOutputFile(String string) {
        this(string, false);
    }

    public TextOutputFile(String string, boolean bl) {
        if (string.equalsIgnoreCase("standard output") || string.equalsIgnoreCase("screen") || string.equalsIgnoreCase("stdout")) {
            this.fileName = "Standard output";
            this.useStandardIO = true;
            return;
        }
        try {
            if (bl) {
                this.r = new RandomAccessFile(string, "rw");
                this.b = new ByteArrayOutputStream();
                this.o = new OutputStreamWriter(this.b);
                this.r.seek(this.r.length());
            } else {
                this.f = new PrintWriter(new FileWriter(new File(string)));
            }
        }
        catch (IOException iOException) {
            this.errPrint("Unable to open file \"" + string + "\"");
        }
        this.fileName = string;
    }

    public void close() {
        if (this.closed) {
            this.errPrint("\"" + this.fileName + "\" is already closed.");
        }
        if (this.useStandardIO) {
            this.useStandardIO = false;
        } else if (this.f == null) {
            try {
                this.r.close();
                this.o.close();
                ((OutputStream)this.b).close();
            }
            catch (IOException iOException) {
                this.errPrint("Close failed: Unable to close \"" + this.fileName + "\"");
            }
            this.r = null;
            this.o = null;
            this.b = null;
        } else {
            this.f.close();
            if (this.f.checkError()) {
                this.errPrint("Close failed: Unable to close \"" + this.fileName + "\"");
            }
            this.f = null;
        }
        this.closed = true;
    }

    public boolean isStandardOut() {
        return this.useStandardIO;
    }

    public void print(byte by) {
        this.print((int)by);
    }

    public void print(byte by, int n) {
        this.print((int)by, n);
    }

    public void print(char c) {
        this.print(String.valueOf(c));
    }

    public void print(char c, int n) {
        String string = String.valueOf(c);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n - string.length()) {
            stringBuffer.append(' ');
            ++n2;
        }
        this.print(String.valueOf(string) + stringBuffer);
    }

    public void print(double d) {
        this.print(String.valueOf(d));
    }

    public void print(double d, int n) {
        int n2;
        String string;
        double d2 = Math.abs(d);
        int n3 = n;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (d < 0.0) {
            --n3;
        }
        if (d2 < 10.0) {
            string2 = "0";
        } else if (d2 < 100.0) {
            string2 = "00";
        } else if (d2 < 1000.0) {
            string2 = "000";
        } else if (d2 < 10000.0) {
            string2 = "0000";
        } else if (d2 < 100000.0) {
            string2 = "00000";
        } else if (d2 < 1000000.0) {
            string2 = "000000";
        } else if (d2 < 1.0E7) {
            string2 = "0000000";
        } else if (d2 < 1.0E8) {
            string2 = "00000000";
        }
        if (string2 == null) {
            string = String.valueOf(d);
        } else {
            if ((n3 -= string2.length()) > 0) {
                string2 = String.valueOf(string2) + ".";
                --n3;
            }
            n2 = 0;
            while (n2 < n3) {
                string2 = String.valueOf(string2) + "#";
                ++n2;
            }
            DecimalFormat decimalFormat = new DecimalFormat(string2);
            string = decimalFormat.format(d);
        }
        n2 = 0;
        while (n2 < n - string.length()) {
            stringBuffer.append(' ');
            ++n2;
        }
        this.print(String.valueOf(stringBuffer) + string);
    }

    public void print(double d, int n, int n2) {
        int n3;
        String string;
        double d2 = Math.abs(d);
        int n4 = n;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (d < 0.0) {
            --n4;
        }
        if (d2 < 10.0) {
            string2 = "0";
        } else if (d2 < 100.0) {
            string2 = "00";
        } else if (d2 < 1000.0) {
            string2 = "000";
        } else if (d2 < 10000.0) {
            string2 = "0000";
        } else if (d2 < 100000.0) {
            string2 = "00000";
        } else if (d2 < 1000000.0) {
            string2 = "000000";
        } else if (d2 < 1.0E7) {
            string2 = "0000000";
        } else if (d2 < 1.0E8) {
            string2 = "00000000";
        }
        if (Math.abs(d) >= 1.0E8) {
            string = String.valueOf(d);
        } else {
            string2 = "0.";
            n3 = 0;
            while (n3 < n2) {
                string2 = String.valueOf(string2) + "0";
                ++n3;
            }
            DecimalFormat decimalFormat = new DecimalFormat(string2);
            string = decimalFormat.format(d);
        }
        n3 = 0;
        while (n3 < n - string.length()) {
            stringBuffer.append(' ');
            ++n3;
        }
        this.print(String.valueOf(stringBuffer) + string);
    }

    public void print(float f) {
        this.print(String.valueOf(f));
    }

    public void print(float f, int n) {
        this.print((double)f, n);
    }

    public void print(float f, int n, int n2) {
        this.print((double)f, n, n2);
    }

    public void print(int n) {
        this.print(String.valueOf(n));
    }

    public void print(int n, int n2) {
        String string = String.valueOf(n);
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2 - string.length()) {
            stringBuffer.append(' ');
            ++n3;
        }
        this.print(String.valueOf(stringBuffer) + string);
    }

    public void print(long l) {
        this.print(String.valueOf(l));
    }

    public void print(long l, int n) {
        String string = String.valueOf(l);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n - string.length()) {
            stringBuffer.append(' ');
            ++n2;
        }
        this.print(String.valueOf(stringBuffer) + string);
    }

    public void print(String string) {
        if (!this.useStandardIO) {
            int n = 0;
            while (string.indexOf(10, n) != -1) {
                n = string.indexOf(10, n);
                string = String.valueOf(string.substring(0, n)) + this.lineSeparator + string.substring(n + 1);
                n += this.lineSeparator.length();
            }
        }
        if (this.closed) {
            this.errPrint("Write failed: \"" + this.fileName + "\" is already closed.");
        }
        if (this.useStandardIO) {
            System.out.print(string);
            System.out.flush();
            if (System.out.checkError()) {
                this.errPrint("Write failed: Unable to write to \"" + this.fileName + "\"");
                return;
            }
        } else {
            if (this.f == null) {
                try {
                    this.o.write(string, 0, string.length());
                    this.o.flush();
                    this.b.toByteArray();
                    this.r.write(this.b.toByteArray());
                }
                catch (IOException iOException) {
                    this.errPrint("Write failed: Unable to write to \"" + this.fileName + "\"");
                }
                this.b.reset();
                return;
            }
            this.f.print(string);
            if (this.f.checkError()) {
                this.errPrint("Write failed: Unable to write to \"" + this.fileName + "\"");
            }
        }
    }

    public void print(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n - string.length()) {
            stringBuffer.append(' ');
            ++n2;
        }
        this.print(String.valueOf(string) + stringBuffer);
    }

    public void print(short s) {
        this.print((int)s);
    }

    public void print(short s, int n) {
        this.print((int)s, n);
    }

    public void print(boolean bl) {
        this.print(String.valueOf(bl));
    }

    public void print(boolean bl, int n) {
        String string = String.valueOf(bl);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n - string.length()) {
            stringBuffer.append(' ');
            ++n2;
        }
        this.print(String.valueOf(string) + stringBuffer);
    }

    public void println() {
        this.print("\n");
    }

    public void println(byte by) {
        this.print(by);
        this.print("\n");
    }

    public void println(byte by, int n) {
        this.print(by, n);
        this.print("\n");
    }

    public void println(char c) {
        this.print(c);
        this.print("\n");
    }

    public void println(char c, int n) {
        this.print(c, n);
        this.print("\n");
    }

    public void println(double d) {
        this.print(d);
        this.print("\n");
    }

    public void println(double d, int n) {
        this.print(d, n);
        this.print("\n");
    }

    public void println(double d, int n, int n2) {
        this.print(d, n, n2);
        this.print("\n");
    }

    public void println(float f) {
        this.print(f);
        this.print("\n");
    }

    public void println(float f, int n) {
        this.print(f, n);
        this.print("\n");
    }

    public void println(float f, int n, int n2) {
        this.print(f, n, n2);
        this.print("\n");
    }

    public void println(int n) {
        this.print(n);
        this.print("\n");
    }

    public void println(int n, int n2) {
        this.print(n, n2);
        this.print("\n");
    }

    public void println(long l) {
        this.print(l);
        this.print("\n");
    }

    public void println(long l, int n) {
        this.print(l, n);
        this.print("\n");
    }

    public void println(String string) {
        this.print(string);
        this.print("\n");
    }

    public void println(String string, int n) {
        this.print(string, n);
        this.print("\n");
    }

    public void println(short s) {
        this.print(s);
        this.print("\n");
    }

    public void println(short s, int n) {
        this.print(s, n);
        this.print("\n");
    }

    public void println(boolean bl) {
        this.print(bl);
        this.print("\n");
    }

    public void println(boolean bl, int n) {
        this.print(bl, n);
        this.print("\n");
    }

    private void errPrint(String string) {
        System.out.println(string);
    }
}

