
/**
 * CCServer.java
 * This is the interface to ChemConsole Server
 *
 * Created: Tue May 25 11:32:03 1999
 *
 * @author Nathan Stevens
 * @version
 */
import java.rmi.*;

public interface CCServer extends Remote
{
  // Method to get set the job type
  public int startAppServer(String s) throws RemoteException;

  // Method that returns the message to client
  public String getStatus(int nid) throws RemoteException;

  // Method to see weather or not status message has changed
  public boolean isDifferent(int nid) throws RemoteException;

  // Methods to get files
  public int[] getFile(int nid, String filename) throws RemoteException;

  //Method to send files
  public boolean putFile(int nid, int[] fileArray, String filename) throws RemoteException;

  // Method to delete
  public boolean delFile(int nid, String filename) throws RemoteException;

  // Method to stop the App Server
  public void Stop(int nid) throws RemoteException;
 
  // Method to a current process 
  public void StopJob(int nid) throws RemoteException;
 
  // get the prgram binary location
  public String getAppBin(int nid) throws RemoteException;

  // Get the working directory
  public String getWorkDir(int nid) throws RemoteException;

  //Method to see if server is active
  public boolean isActive(int nid) throws RemoteException;
 
  // Metohd to run app
  public boolean runApp(int sid, String[] c) throws RemoteException;
}  





