
/**
 * CCClient.java (ChemConsoleClient.java)
 * This Connects to the ChemConsole Server using RMI
 *
 * Created: Tue May 25 17:00:28 1999
 *
 * @author Nathan Stevens
 * @version 0.3
 */
import java.rmi.*;
import java.rmi.registry.*;
import java.io.*;

public class ChemConsoleClient extends ChemAppThread
{
  private String JobType;
  private String hostname;
  public CCServer server;
  private int[] fa;
 
  public ChemConsoleClient(String JobType, String hostname) throws RemoteException
    {
      this.JobType  = JobType ;
      this.hostname = hostname;
    
      // Create the remote object  
      
      String registryName = "rmi://" + hostname + ":1099/ccserver";

      try
	{
          // install the rmi security manager
          if(System.getSecurityManager() == null)
            System.setSecurityManager(new RMISecurityManager());

	  // Obtain a referance to remote object
          server = (CCServer)Naming.lookup(registryName);

	  // print to status window
   
	}
      catch( Exception e)
	{
          System.err.println("Cannot connect to RMI registry for " + 
                             registryName);
          System.out.println(e.toString());
          this.stop();
          return;
	}     
    }

  // Method to start the application server
  public int startAppServer() throws RemoteException
    {
      return server.startAppServer(JobType);
    }
               
  // This method updates the status window in real time
  public String[] getStatus(int sid) throws RemoteException
    {
       return server.getStatus(sid);
    }
  
  // Method to get Files
  public boolean getFile(int sid, String filename) throws RemoteException
    { 
      fa = server.getFile(sid, filename);
      try
        {
          File nf = new File(filename);
          BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(nf));
        
          if(fa != null)
	    {
              for(int i = 0; i < fa.length; i++)
                out.write(fa[i]);

              out.flush();
              out.close();
	    }
          else
	    {
              return false;
	    }
	}
      catch(IOException e)
	{
          System.out.println(e.toString());
          return false;
	} 
      
      return true;
    }

  // Method to putfile
  public boolean putFile(int sid, String filename, String remotefile) throws RemoteException
    {
      File file = new File(filename);
      // create the integer array
      try
	{
          if(file.isFile())
	    {
              int[] fileArray = new int[(int)file.length()];
              BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
              for(int i = 0; i < fileArray.length; i++)
                fileArray[i] = in.read();
              
              return server.putFile(sid, fileArray, remotefile); 
	    }
         else
	   {
             System.out.println("Could not find the file " + file);
             return false;
	   }
	}
      catch(IOException e)
	{
          System.out.println(e.toString());
          return false;
	}
	
    }   
  
  // Method to delet a file
  public boolean delFile(int sid, String filename) throws RemoteException
    { 
      return server.delFile(sid, filename);
    }

  // Check to see if that servis is available
  public boolean isActive(int sid) throws RemoteException
    {
      return server.isActive(sid);
    }

  // Method to get the location of binary file on server
  public String getAppBin(int sid) throws RemoteException
    {
      return server.getAppBin(sid);
    }

  // Method to get Working directory
  public String getWorkDir(int sid) throws RemoteException
    {
      return server.getWorkDir(sid);
    }

  // Method to run the application on server
  public boolean runApp(int sid, String[] command) throws RemoteException
    {
      return server.runApp(sid, command);
    }

  public void Stop(int sid) throws RemoteException
    {
      server.Stop(sid);
    }
  
  // Method to stop a specific job on a the server
  public void StopJob(int sid) throws RemoteException
    {
      server.StopJob(sid);
    }

  // Method to return a list of files
  public String[] getFileList(int sid, String n, String ext) throws RemoteException
    {
      return server.getFileList(sid, n, ext);
    }

  public void setRetrieve(int sid, boolean r) throws RemoteException
    {
      server.setRetrieve(sid, r);
    } 
}             











