
/**
 * ChemToolFrame.java
 * This is used as the frame for tool Panels such as BabelPanel etc. 
 *
 * Created: Thu Apr 22 14:13:31 1999
 *
 * @author Nathan Stevens
 * @version 0.2 
 */
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
//import javax.swing.*;

public class ChemToolFrame extends JFrame 
{  
  public ChemToolFrame(String title, JPanel panel)
    {
      super(title);
      addAppPanel(panel);
    }
  
  // Method to add JPanels to frame
  private void addAppPanel(JPanel panel)
    {  
      // set the layout manager
      getContentPane().setLayout(new BorderLayout());
     
      // add the panel to frame
      getContentPane().add(panel,"Center");
      
      // add the window listener
      addWindowListener(new wCloser());

      //Pack and display
      pack();
      setVisible(true);
    }

  // Method to close the frame
  public void Close()
    {
      setVisible(false);
      dispose();
    }
}

// This class just closes the window, but doesn't kill the JVM.
class wCloser extends WindowAdapter
{
  public void wCloser(WindowEvent e)
    {
      Window win = e.getWindow();
      win.setVisible(false);
      win.dispose();
    }
}
      

