
/**
 * FileListFilter.java
 *
 *
 * Created: Thu Apr 29 19:38:51 1999
 *
 * @author Nathan Stevens
 * @version 0.1
 */
import java.io.*;

public class FileListFilter implements FilenameFilter
{
  private String name;
  private String extension;
  
  //Constructor
  public FileListFilter(String name, String extension)
    {
      this.name = name;
      this.extension = extension;
    }
  
  public boolean accept(File directory, String filename)
    {
      boolean fileOK = true;
      
      // If there is a name filter specfied, check the file name
      if(name != null)
         fileOK &= filename.startsWith(name);

      // if there is an extension filter, check the file extension
      if(extension != null)
        fileOK &= filename.endsWith('.' + extension);

      return fileOK;
    }
}  
