
/**
 * MopacConfigPanel.java
 *
 *
 * Created: Sat May  1 19:39:22 1999
 *
 * @author Nathan Stevens
 * @version 0.2
 */
import java.awt.*;
import java.util.*;
import java.io.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
//import javax.swing.*;
//import javax.swing.border.*;

public class MopacConfigPanel extends JPanel implements  ActionListener
{
  private String APP_BIN = "mopac";
  private boolean REM_EXT = true;
  private Vector ServerList;
  private ServerConfigPanel Sp;
  private ChemMessage m = new ChemMessage(this);
  private static File cfile = new File("Config/mopac.cfg");
  private JTextField tf1;
  private JButton bt1, bt2;
  private AbstractButton ab1;

  public MopacConfigPanel()
    {
      //set the layout
      setLayout(new BorderLayout());
      ServerList = new Vector();
      TitledBorder border;

      JPanel pan1 = new JPanel();
      pan1.setLayout(new GridLayout(2,1));
      border = new TitledBorder("Mopac Properties");
      border.setTitlePosition(TitledBorder.TOP);
      border.setTitleJustification(TitledBorder.LEFT);
      pan1.setBorder(border);      
      
      // add the TextField and Browse button
      JPanel pan1A = new JPanel();
      pan1A.setLayout(new FlowLayout(FlowLayout.LEFT));
     
      JLabel lb1 = new JLabel("Mopac File : ");
      pan1A.add(lb1);
     
      tf1 = new JTextField(20);
      pan1A.add(tf1);
      
      bt1 = new JButton("Browse");
      bt1.addActionListener(this);
      pan1A.add(bt1);
      
      pan1.add(pan1A);
     
      // Add the check box button
      JPanel pan1B = new JPanel();
      pan1B.setLayout(new FlowLayout(FlowLayout.LEFT));

      ab1 = new JCheckBox("Remove Ext");
      ab1.addActionListener(this);
      pan1B.add(ab1);
      
      pan1.add(pan1B);
     
      add(pan1, "North");
   
      // Add the Server config panel
      Sp = new ServerConfigPanel();
      border = new TitledBorder("Mopac Server(s)");
      border.setTitlePosition(TitledBorder.TOP);
      border.setTitleJustification(TitledBorder.LEFT);
      Sp.setBorder(border);

      add(Sp, "Center");

      // Add the save button
      JPanel pan2 = new JPanel();
      pan2.setLayout(new FlowLayout());
      
      bt2 = new JButton("Save");
      bt2.addActionListener(this);
      pan2.add(bt2);
      
      add(pan2, "South");

      ReadCfg();
      upDate();          // Method to the display      
    }

  // Method to read Config file 
  private void ReadCfg()
    {
       if(cfile.isFile())
	{
          TextInputFile f = new TextInputFile(cfile);
          APP_BIN = f.readString();
          REM_EXT = f.readBoolean();
        
	  // now had the list of servers
          while(!f.eof())
	    {
              ServerList.addElement(f.readString());
	    }
          f.close();
	}
       else
	 {
           SaveCfg();
	 }
    }
  private void SaveCfg()
    {
      
      Enumeration theServer = ServerList.elements();

      // write the values to the file
      TextOutputFile f = new TextOutputFile(cfile);
      f.println(APP_BIN);
      f.println(REM_EXT);

      while(theServer.hasMoreElements())
	{
          f.println((String)theServer.nextElement());
	}
      f.close();
    }

  private void upDate()
    {
      tf1.setText(APP_BIN);
      ab1.setSelected(REM_EXT);
      Sp.setServer(ServerList);      
    }

  // Method to handel the events
  public void actionPerformed(ActionEvent e)
    {
      if(e.getSource() == bt1)
	{
          getMopac();
	}
      else if(e.getSource() == ab1)
	{
          REM_EXT = ab1.isSelected();
          //System.out.println("OK " + REM_EXT); test code 
	}
      else if(e.getSource() == bt2)
	{
          SaveCfg();
	}
      
    }
  
  private void getMopac()
    {
      String dir;
      String name;

      fDialog fd = new fDialog(this,"Mopac File");
      fd.setBackground(getPanelColor());
      fd.show();
      
      dir = fd.getDirectory();
      name = fd.getFile();
      
      if(name !=null)
	{
          File f = new File(dir + name);

          if(f.isFile())
	    {
              APP_BIN = dir + name;
              tf1.setText(APP_BIN);
	    }
          else
	    {
              m.errPrint("The file " + name + " doesn't exist", "File Error");
	    }
	}  
    }

  //Method to get the panel color 
  private Color getPanelColor()
    {
      return getBackground();
    }          
}




