
/**
 * MopacPanel.java
 *
 *
 * Created: Thu Apr 22 14:04:00 1999
 *
 * @author Nathan Stevens
 * @version 0.3
 */
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.event.*;
//import javax.swing.*;
//import javax.swing.border.*;
//import javax.swing.event.*;

public class MopacPanel extends JPanel implements ActionListener, Serializable,
                                                  ListSelectionListener
{
  private String Mode;
  private String command;
  private File Pool = new File("JobPool/mpool");
  private static File cfile = new File("Config/mopac.cfg");
  private File datafile;
  private JList list; 
  private int last;
  private Object[] selValues;                    
  private Vector listdata = new Vector(); 
  private String[] jobs;
  private Vector ServerList;                    
  private JButton addb, remb, remab, startb, stopb, statb;  
  private JButton stopab, edit, loadj, savej, selb;
  private fDialog fd;         
  private ChemMessage m = new ChemMessage(this);
  private MopacApp ma;
  private NetworkPanel np;
  private DataFileEditorPanel ed;
  public boolean REM_EXT = true;
     
  //default constructor
  public MopacPanel()
    {
      this("local");
    }
  
  public MopacPanel(String mode)
    {
      Mode = mode;

      //set Layout
      setLayout(new BorderLayout());
      
      // set the border bevel border
      SoftBevelBorder mopb = new SoftBevelBorder(SoftBevelBorder.RAISED);
      setBorder(mopb); 

      //the title line boarder
      TitledBorder border;

      //Check to what mode we are in
      if(Mode.equals("network"))
	{
	  np = new NetworkPanel();
          add(np, "South");
	}

      //add title to north
      Font font = new Font("Times-Roman", Font.ITALIC, 14);
      JLabel name = new JLabel("Mopac", JLabel.CENTER);
      name.setFont(font);
      add(name, "North");

      /** 
       *add the job pool and its buttons to the main panel
       */
      JPanel jpp  = new JPanel();
      jpp.setLayout(new BorderLayout());
      border = new TitledBorder("Mopac Job Pool");
      border.setTitlePosition(TitledBorder.TOP);
      border.setTitleJustification(TitledBorder.CENTER);
      jpp.setBorder(border);
     
      // add the dynamic  List to center of jpp
      final DefaultListModel model = new DefaultListModel();
      list = new JList(model);
      list.addListSelectionListener(this);
      JScrollPane sp = new JScrollPane(list);
      jpp.add(sp, "Center");
      
      // add buttons to the south of jpp
      JPanel btp1 = new JPanel();
      btp1.setLayout(new FlowLayout(FlowLayout.CENTER, 5, 10));
      
      selb = new JButton("Select All");
      selb.addActionListener(this);
      btp1.add(selb);
      
      statb = new JButton("  Status  ");
      statb.addActionListener(this);
      btp1.add(statb);
     
      jpp.add(btp1, "South");
      add(jpp,"Center");
      
      /**
       * Add the Job Control panel to the east side
       */
      JPanel jcp  = new JPanel();
      jcp.setLayout(new GridLayout(5,1));
      border = new TitledBorder("Job Control");
      border.setTitlePosition(TitledBorder.TOP);
      border.setTitleJustification(TitledBorder.CENTER);
      jcp.setBorder(border);

      // add the Add, Remove and Remove All buttons
      JPanel arp = new JPanel();
      arp.setLayout(new FlowLayout(FlowLayout.CENTER, 5, 0));
      
      addb = new JButton("   Add    ");
      addb.addActionListener(this);
      arp.add(addb);
      
      remb = new JButton("  Remove  "); 
      remb.addActionListener(this);
      arp.add(remb);
      
      remab = new JButton("Remove All");
      remab.addActionListener(this);
      arp.add(remab);
 
      jcp.add(arp);
      
      // add the Start and Stop Button and Stop all
      JPanel sst = new JPanel();
      sst.setLayout(new FlowLayout(FlowLayout.CENTER, 5, 0));
      
      startb = new JButton(" Start  ");
      startb.addActionListener(this);
      sst.add(startb);
      
      stopb = new JButton("  Stop  "); 
      stopb.addActionListener(this);
      sst.add(stopb);
      
      stopab = new JButton("Stop All");
      stopab.addActionListener(this);
      sst.add(stopab);
 
      jcp.add(sst);

      //add the Edit button
      edit = new JButton("Edit");
      edit.addActionListener(this); 
      jcp.add(edit);
     
      //add the load job pool button
      loadj = new JButton("Load Job Pool");
      loadj.addActionListener(this); 
      jcp.add(loadj);

      //add the save job pool button
      savej = new JButton("Save Job Pool");
      savej.addActionListener(this); 
      jcp.add(savej);
      
      add(jcp,"East");
       
      ReadCfg();
      upDate();
      //
    }

  // Method to read the configuration file mopac.cfg in dir Config
  private void ReadCfg()
    {
      if(cfile.isFile())
        {
          TextInputFile f = new TextInputFile(cfile);
          command = f.readString();
          REM_EXT = f.readBoolean();

          // If mode is equal to network then read servers and set the servers
          if(Mode.equals("network"))
            {
              ServerList = new Vector();
              while(!f.eof())
                {
                  ServerList.addElement(f.readString());
                }              
            }
          f.close();
	}
      else
        {
          String[] emsg = {"The Config file \"babel.cfg\" was found.",
                           "Please Run the Config Utility.",
                           "Using Defaults."}; 
          m.errPrint(emsg, "File Error");
        } 
    }

  // Method to load set config values.
  private void upDate ()
    {
      if(Mode.equals("network"))
	 {
           np.setBoxData(ServerList);
	 }
      mJobPool();
    }
             
  // Method to creat the job pool dir name if it doesn't exist already
  private void mJobPool()
    {
      try
	{ 
	  // if the dir doesn't exist create it else do nothing
          if(!Pool.exists())
	    {
              Pool.mkdir();
	    }
	}
      catch(Exception e)
	{
          m.errPrint("Exeception thrown: " + e, "Excetion");
	}
    }        
     
  //Handel the events
  public void actionPerformed(ActionEvent e)
    {
      if(e.getSource() == addb)
	{
          addJob();
	}
      else if(e.getSource() == remb)
	{
          remJob();
	}
      else if(e.getSource() == remab)
	{
          remAllJob();
	}      
      else if(e.getSource() == startb && selValues != null)
	{
          startJob();
	}
      else if(e.getSource() == stopb && ma != null)
	{
          stopJob();
	}
      else if(e.getSource() == stopab && ma != null)
	{
          stopAllJobs();
	}
      else if(e.getSource() == edit && selValues != null)
	{
          editFile();
	}
      else if(e.getSource() == loadj)
	{
          loadJobPool();
	}
      else if(e.getSource() == savej)
	{
          saveJobPool();
	}
      else if(e.getSource() == selb)
	{
          selectAll();
	}
      else if(e.getSource() == statb)
	{
          getStatus();
	}
    } 
  
  public void valueChanged(ListSelectionEvent e)
    {
      selValues = list.getSelectedValues();
      last = selValues.length;
    }

  /**
   *all methods  below this point handle events
   */

  //Method for button one
  private void addJob()
    {
      fd  = new fDialog(this, "Data File Input");
      fd.setBackground(getPanelColor());
      
      // add a filter to dialog. note doesn't seem to work
      FilenameFilter extension = new FileListFilter(null, "dat");
      fd.setFilenameFilter(extension);

      fd.show();

      //get the filename and check to see it it exist
      String filename = fd.getFile();
      try
	{
          if(filename != null)
	    {
              File tmpfile = new File(filename);
              if(tmpfile.isFile())
	        {
                 //call the addData method and add
	         //if that's the way mopac was configured
                 if(REM_EXT && Mode.equals("local"))
	           {
                      int fl = filename.length() - 4; 
                      String jobName = filename.substring(0,fl); 
                      addData(jobName);
	           }
                 else
	           {  
	             //just add the filename
                     addData(filename);
	           }
	        } 
              else 
		{
                  m.errPrint("The file " + filename + " doesn't exist", 
                                   "Data File Input Error");
	        }
	    }
	}
      catch(Exception e)
	{
	  System.out.println("An error occured " + e);
	} 
    }

  // Method to remove the selected job from list
  private void remJob()
    {
      //remove the the selected values from vector
      for(int i = 0; i < last; i++)
	{
          listdata.removeElement(selValues[i]);
	}
      // now reset the data.
      addData();
    }
  private void remAllJob()
    {
      selectAll();
      listdata.removeAllElements();
      addData();
    }
  
  //Method to start the job
  private void startJob()
    {      
      if(selValues.length != 0)
	{
          ma = new MopacApp(this);
          ma.start();
	}
      else
	{
	  m.errPrint("No Input File(s) selected", "Input Error");
	}      
    }

  //Method to stop the current job
  private void stopJob()
    {
      ma.stopJob();
    }
  // Method to stop all jobs
  private void stopAllJobs()
    {
      ma.stopAllJobs();
    }
  // Method to edit data file
  private void editFile()
    {
      for(int i = 0; i < last; i++)
	{
          if(REM_EXT)
	    {
              datafile = new File((String)selValues[i] + ".dat");
	    }
          else
	    {
              datafile = new File((String)selValues[i]);
	    }

          if(datafile.isFile())
	    {
              ed = new DataFileEditorPanel("Mopac Data", datafile);
	    }
	}      

    }
  // Method to laod job pool vector
  private void loadJobPool()
    {
      // first we is get the name of the file we want to save to
      fd  = new fDialog(this, "Load Job Pool");
      fd.setBackground(getPanelColor()); 
      fd.show();      
       
      String fname = fd.getFile();	
      try
        {
           if(fname != null)
	     {
               //check to see if file exist
               File tf = new File(Pool, fname);
               if(tf.exists())
	         {
                   // Create the output object
                   ObjectInputStream in = 
                           new ObjectInputStream(
                           new BufferedInputStream(
                           new FileInputStream(tf)));

                   listdata = (Vector)in.readObject();
                   addData();
	         }
	     
               else
	         {
                   m.errPrint("The file you specified doesn't exist",
                         "Pool File Error");
	         }
	     }
	} 
      catch(IOException e)
        {
          m.errPrint("The following error ocurred " + e,
                     "IO Error");          
	}
      catch(ClassNotFoundException e)
        {
          m.errPrint("The following error occured " + e,
                         "ClassNotFound Error");
	}         
    }

  // Method to save job pool
  private void saveJobPool()
    {
      // first we is get the name of the file we want to save to
      fd  = new fDialog(this, "Save Job Pool");
      fd.setBackground(getPanelColor()); 
      fd.show();
      
      String fname = fd.getFile();
      try
        {
          if(fname != null)
	    {
              File tf = new File(Pool, fname + ".mjp");
          
	      //Create the object ouput stream
              ObjectOutputStream out = 
                      new ObjectOutputStream(
                      new BufferedOutputStream(
                      new FileOutputStream(tf)));

              out.writeObject(listdata);
              out.close();
	    }
	}
 
     catch(IOException e)
        {
             m.errPrint("IO exception " + e, "IO Exception");
	}     
    }

  // Method to select all the data in items in the list
  private void selectAll()
    { 
      int[] Indices = new int[listdata.size()];
      int listSize  = listdata.size();
      for(int i = 0; i < listSize; i++)
	{
          Indices[i] = i;
	}
      list.setSelectedIndices(Indices); 
    }

  // Method to get the status of run program
  private void getStatus()
    {
      if(ma != null)
        m.msgPrint(ma.getStatus(), "Status");
      else
	m.msgPrint("There are no Mopac Jobs Runing", "Status");
    }
	   
  /** Method to aad the data to list called when the add button is called
   *  it doesn't directly add data to the list, but rather to the vector
   * then to the list.
   **/
  private void addData(String filename)
    {
      //put the file String into a vector the main vector
      listdata.addElement(filename);
      addData(); 
    }

  private void addData()
    {
      // all the addData methods eventually calls this method
      list.setListData(listdata);
      list.revalidate();
      
      //Bug work around
      revalidate();
      if(listdata.size() != 0)
	{           
          list.setSelectedIndex(0);
	}
    }

  // method to get the color of JPanel and return it
  private Color getPanelColor()
    {
      return getBackground(); 
    }
  
  /**
   * These methods get the private data fields in this class and make them
   * avaliable to any Object which request them.
   **/
   public String getMode()
    {
      return Mode;
    }
   public String getCommand()
    {
      return command;
    }
   public String[] getJobs()
    {
       jobs = new String[last];

       for(int i = 0; i < last; i++)
	 {
           jobs[i] = (String)selValues[i];
	 }
  
       return jobs;
    }
   public String getServer()
    {
     return np.getServer();
    }
   public boolean isRetrieve()
    {
      return np.isRetrieve();
    }

  // Method to lock the start button
  public void setActive(boolean b)
    {
      if(b == true)
	{
          startb.setEnabled(b);
	}
      else
	{
          startb.setEnabled(b);
	}         
    }           
}  











